/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.rule.engine.api.MailService;
import org.thingsboard.server.cache.limits.RateLimitService;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.limit.LimitedApi;
import org.thingsboard.server.common.data.security.UserCredentials;
import org.thingsboard.server.common.data.security.event.UserCredentialsInvalidationEvent;
import org.thingsboard.server.common.data.security.event.UserSessionInvalidationEvent;
import org.thingsboard.server.common.data.security.model.JwtPair;
import org.thingsboard.server.common.data.security.model.SecuritySettings;
import org.thingsboard.server.common.data.security.model.UserPasswordPolicy;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.settings.SecuritySettingsService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.auth.rest.RestAuthenticationDetails;
import org.thingsboard.server.service.security.model.ActivateUserRequest;
import org.thingsboard.server.service.security.model.ChangePasswordRequest;
import org.thingsboard.server.service.security.model.ResetPasswordEmailRequest;
import org.thingsboard.server.service.security.model.ResetPasswordRequest;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.model.UserPrincipal;
import org.thingsboard.server.service.security.model.token.JwtTokenFactory;
import org.thingsboard.server.service.security.system.SystemSecurityService;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class AuthController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthController.class);
    @Value(value="${server.rest.rate_limits.reset_password_per_user:5:3600}")
    private String defaultLimitsConfiguration;
    private final BCryptPasswordEncoder passwordEncoder;
    private final JwtTokenFactory tokenFactory;
    private final MailService mailService;
    private final SystemSecurityService systemSecurityService;
    private final SecuritySettingsService securitySettingsService;
    private final RateLimitService rateLimitService;
    private final ApplicationEventPublisher eventPublisher;

    @ApiOperation(value="Get current User (getUser)", notes="Get the information about the User which credentials are used to perform this REST API call.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/auth/user"})
    public User getUser() throws ThingsboardException {
        SecurityUser securityUser = this.getCurrentUser();
        User user = this.userService.findUserById(securityUser.getTenantId(), securityUser.getId());
        this.checkDashboardInfo(user.getAdditionalInfo());
        return user;
    }

    @ApiOperation(value="Logout (logout)", notes="Special API call to record the 'logout' of the user to the Audit Logs. Since platform uses [JWT](https://jwt.io/), the actual logout is the procedure of clearing the [JWT](https://jwt.io/) token on the client side. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/auth/logout"})
    public void logout(HttpServletRequest request) throws ThingsboardException {
        this.logLogoutAction(request);
    }

    @ApiOperation(value="Change password for current User (changePassword)", notes="Change the password for the User which credentials are used to perform this REST API call. Be aware that previously generated [JWT](https://jwt.io/) tokens will be still valid until they expire.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @PostMapping(value={"/auth/changePassword"})
    public JwtPair changePassword(@Parameter(description="Change Password Request") @RequestBody ChangePasswordRequest changePasswordRequest) throws ThingsboardException {
        String currentPassword = changePasswordRequest.getCurrentPassword();
        String newPassword = changePasswordRequest.getNewPassword();
        SecurityUser securityUser = this.getCurrentUser();
        UserCredentials userCredentials = this.userService.findUserCredentialsByUserId(TenantId.SYS_TENANT_ID, securityUser.getId());
        if (!this.passwordEncoder.matches((CharSequence)currentPassword, userCredentials.getPassword())) {
            throw new ThingsboardException("Current password doesn't match!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        this.systemSecurityService.validatePassword(newPassword, userCredentials);
        if (this.passwordEncoder.matches((CharSequence)newPassword, userCredentials.getPassword())) {
            throw new ThingsboardException("New password should be different from existing!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        userCredentials.setPassword(this.passwordEncoder.encode((CharSequence)newPassword));
        this.userService.replaceUserCredentials(securityUser.getTenantId(), userCredentials);
        this.eventPublisher.publishEvent((Object)new UserCredentialsInvalidationEvent(securityUser.getId()));
        return this.tokenFactory.createTokenPair(securityUser);
    }

    @ApiOperation(value="Get the current User password policy (getUserPasswordPolicy)", notes="API call to get the password policy for the password validation form(s).")
    @GetMapping(value={"/noauth/userPasswordPolicy"})
    public UserPasswordPolicy getUserPasswordPolicy() throws ThingsboardException {
        SecuritySettings securitySettings = (SecuritySettings)this.checkNotNull((Object)this.securitySettingsService.getSecuritySettings());
        return securitySettings.getPasswordPolicy();
    }

    @ApiOperation(value="Check Activate User Token (checkActivateToken)", notes="Checks the activation token and forwards user to 'Create Password' page. If token is valid, returns '303 See Other' (redirect) response code with the correct address of 'Create Password' page and same 'activateToken' specified in the URL parameters. If token is not valid, returns '409 Conflict'. If token is expired, redirects to error page.")
    @GetMapping(value={"/noauth/activate"}, params={"activateToken"})
    public ResponseEntity<?> checkActivateToken(@Parameter(description="The activate token string.") @RequestParam(value="activateToken") String activateToken) {
        UserCredentials userCredentials = this.userService.findUserCredentialsByActivateToken(TenantId.SYS_TENANT_ID, activateToken);
        if (userCredentials == null) {
            return this.response(HttpStatus.CONFLICT);
        }
        if (userCredentials.isActivationTokenExpired()) {
            return this.redirectTo("/activationLinkExpired");
        }
        return this.redirectTo("/login/createPassword?activateToken=" + activateToken);
    }

    @ApiOperation(value="Request reset password email (requestResetPasswordByEmail)", notes="Request to send the reset password email if the user with specified email address is present in the database. Always return '200 OK' status for security purposes.")
    @PostMapping(value={"/noauth/resetPasswordByEmail"})
    public void requestResetPasswordByEmail(@Parameter(description="The JSON object representing the reset password email request.") @RequestBody ResetPasswordEmailRequest resetPasswordByEmailRequest, HttpServletRequest request) throws ThingsboardException {
        try {
            String email = resetPasswordByEmailRequest.getEmail();
            UserCredentials userCredentials = this.userService.requestPasswordReset(TenantId.SYS_TENANT_ID, email);
            User user = this.userService.findUserById(TenantId.SYS_TENANT_ID, userCredentials.getUserId());
            String baseUrl = this.systemSecurityService.getBaseUrl(user.getTenantId(), user.getCustomerId(), request);
            String resetUrl = String.format("%s/api/noauth/resetPassword?resetToken=%s", baseUrl, userCredentials.getResetToken());
            this.mailService.sendResetPasswordEmailAsync(resetUrl, userCredentials.getResetTokenTtl(), email);
        }
        catch (Exception e) {
            log.warn("Error occurred: {}", (Object)e.getMessage());
        }
    }

    @ApiOperation(value="Check password reset token (checkResetToken)", notes="Checks the password reset token and forwards user to 'Reset Password' page. If token is valid, returns '303 See Other' (redirect) response code with the correct address of 'Reset Password' page and same 'resetToken' specified in the URL parameters. If token is not valid, returns '409 Conflict'. If token is expired, redirects to error page.")
    @GetMapping(value={"/noauth/resetPassword"}, params={"resetToken"})
    public ResponseEntity<?> checkResetToken(@Parameter(description="The reset token string.") @RequestParam(value="resetToken") String resetToken) {
        UserCredentials userCredentials = this.userService.findUserCredentialsByResetToken(TenantId.SYS_TENANT_ID, resetToken);
        if (userCredentials == null) {
            return this.response(HttpStatus.CONFLICT);
        }
        if (userCredentials.isResetTokenExpired()) {
            return this.redirectTo("/passwordResetLinkExpired");
        }
        if (!this.rateLimitService.checkRateLimit(LimitedApi.PASSWORD_RESET, (Object)userCredentials.getUserId(), this.defaultLimitsConfiguration)) {
            return this.response(HttpStatus.TOO_MANY_REQUESTS);
        }
        return this.redirectTo("/login/resetPassword?resetToken=" + resetToken);
    }

    @ApiOperation(value="Activate User", notes="Checks the activation token and updates corresponding user password in the database. Now the user may start using his password to login. The response already contains the [JWT](https://jwt.io) activation and refresh tokens, to simplify the user activation flow and avoid asking user to input password again after activation. If token is valid, returns the object that contains [JWT](https://jwt.io/) access and refresh tokens. If token is not valid, returns '400 Bad Request'.")
    @PostMapping(value={"/noauth/activate"})
    public JwtPair activateUser(@Parameter(description="Activate user request.") @RequestBody ActivateUserRequest activateRequest, @RequestParam(required=false, defaultValue="true") boolean sendActivationMail, HttpServletRequest request) {
        String activateToken = activateRequest.getActivateToken();
        String password = activateRequest.getPassword();
        this.systemSecurityService.validatePassword(password, null);
        String encodedPassword = this.passwordEncoder.encode((CharSequence)password);
        UserCredentials credentials = this.userService.activateUserCredentials(TenantId.SYS_TENANT_ID, activateToken, encodedPassword);
        User user = this.userService.findUserById(TenantId.SYS_TENANT_ID, credentials.getUserId());
        UserPrincipal principal = new UserPrincipal(UserPrincipal.Type.USER_NAME, user.getEmail());
        SecurityUser securityUser = new SecurityUser(user, credentials.isEnabled(), principal);
        this.userService.setUserCredentialsEnabled(user.getTenantId(), user.getId(), true);
        String baseUrl = this.systemSecurityService.getBaseUrl(user.getTenantId(), user.getCustomerId(), request);
        String loginUrl = String.format("%s/login", baseUrl);
        String email = user.getEmail();
        if (sendActivationMail) {
            try {
                this.mailService.sendAccountActivatedEmail(loginUrl, email);
            }
            catch (Exception e) {
                log.warn("Unable to send account activation email [{}]", (Object)e.getMessage());
            }
        }
        JwtPair tokenPair = this.tokenFactory.createTokenPair(securityUser);
        this.systemSecurityService.logLoginAction(user, (Object)new RestAuthenticationDetails(request), ActionType.LOGIN, null);
        return tokenPair;
    }

    @ApiOperation(value="Reset password (resetPassword)", notes="Checks the password reset token and updates the password. If token is not valid, returns '400 Bad Request'.")
    @PostMapping(value={"/noauth/resetPassword"})
    public void resetPassword(@Parameter(description="Reset password request.") @RequestBody ResetPasswordRequest resetPasswordRequest, HttpServletRequest request) throws ThingsboardException {
        SecurityUser securityUser;
        String resetToken = resetPasswordRequest.getResetToken();
        String password = resetPasswordRequest.getPassword();
        UserCredentials userCredentials = this.userService.findUserCredentialsByResetToken(TenantId.SYS_TENANT_ID, resetToken);
        if (userCredentials != null) {
            if (userCredentials.isResetTokenExpired()) {
                throw new ThingsboardException("Password reset token expired", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
            }
            this.systemSecurityService.validatePassword(password, userCredentials);
            if (this.passwordEncoder.matches((CharSequence)password, userCredentials.getPassword())) {
                throw new ThingsboardException("New password should be different from existing!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
            }
            String encodedPassword = this.passwordEncoder.encode((CharSequence)password);
            userCredentials.setPassword(encodedPassword);
            userCredentials.setResetToken(null);
            userCredentials.setResetTokenExpTime(null);
            userCredentials = this.userService.replaceUserCredentials(TenantId.SYS_TENANT_ID, userCredentials);
            User user = this.userService.findUserById(TenantId.SYS_TENANT_ID, userCredentials.getUserId());
            UserPrincipal principal = new UserPrincipal(UserPrincipal.Type.USER_NAME, user.getEmail());
            securityUser = new SecurityUser(user, userCredentials.isEnabled(), principal);
            String baseUrl = this.systemSecurityService.getBaseUrl(user.getTenantId(), user.getCustomerId(), request);
            String loginUrl = String.format("%s/login", baseUrl);
            String email = user.getEmail();
            try {
                this.mailService.sendPasswordWasResetEmail(loginUrl, email);
            }
            catch (Exception e) {
                log.warn("Couldn't send password was reset email: {}", (Object)e.getMessage());
            }
        } else {
            throw new ThingsboardException("Invalid reset token!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        this.eventPublisher.publishEvent((Object)new UserCredentialsInvalidationEvent(securityUser.getId()));
    }

    private void logLogoutAction(HttpServletRequest request) throws ThingsboardException {
        SecurityUser user = this.getCurrentUser();
        this.systemSecurityService.logLoginAction((User)user, (Object)new RestAuthenticationDetails(request), ActionType.LOGOUT, null);
        this.eventPublisher.publishEvent((Object)new UserSessionInvalidationEvent(user.getSessionId()));
    }

    @ConstructorProperties(value={"passwordEncoder", "tokenFactory", "mailService", "systemSecurityService", "securitySettingsService", "rateLimitService", "eventPublisher"})
    @Generated
    public AuthController(BCryptPasswordEncoder passwordEncoder, JwtTokenFactory tokenFactory, MailService mailService, SystemSecurityService systemSecurityService, SecuritySettingsService securitySettingsService, RateLimitService rateLimitService, ApplicationEventPublisher eventPublisher) {
        this.passwordEncoder = passwordEncoder;
        this.tokenFactory = tokenFactory;
        this.mailService = mailService;
        this.systemSecurityService = systemSecurityService;
        this.securitySettingsService = securitySettingsService;
        this.rateLimitService = rateLimitService;
        this.eventPublisher = eventPublisher;
    }
}

