/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.google.common.util.concurrent.ListenableFuture;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.EntitySubtype;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.asset.AssetInfo;
import org.thingsboard.server.common.data.asset.AssetSearchQuery;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.AssetProfileId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.common.data.sync.ie.importing.csv.BulkImportRequest;
import org.thingsboard.server.common.data.sync.ie.importing.csv.BulkImportResult;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.exception.IncorrectParameterException;
import org.thingsboard.server.dao.model.ModelConstants;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.asset.AssetBulkImportService;
import org.thingsboard.server.service.entitiy.asset.TbAssetService;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.Operation;
import org.thingsboard.server.service.security.permission.Resource;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class AssetController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetController.class);
    private final AssetBulkImportService assetBulkImportService;
    private final TbAssetService tbAssetService;
    public static final String ASSET_ID = "assetId";

    @ApiOperation(value="Get Asset (getAssetById)", notes="Fetch the Asset object based on the provided Asset Id. If the user has the authority of 'Tenant Administrator', the server checks that the asset is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the asset is assigned to the same customer.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/asset/{assetId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Asset getAssetById(@Parameter(description="A string value representing the asset id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="assetId") String strAssetId) throws ThingsboardException {
        this.checkParameter(ASSET_ID, strAssetId);
        AssetId assetId = new AssetId(this.toUUID(strAssetId));
        return this.checkAssetId(assetId, Operation.READ);
    }

    @ApiOperation(value="Get Asset Info (getAssetInfoById)", notes="Fetch the Asset Info object based on the provided Asset Id. If the user has the authority of 'Tenant Administrator', the server checks that the asset is owned by the same tenant. If the user has the authority of 'Customer User', the server checks that the asset is assigned to the same customer. Asset Info is an extension of the default Asset object that contains information about the assigned customer name. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/asset/info/{assetId}"}, method={RequestMethod.GET})
    @ResponseBody
    public AssetInfo getAssetInfoById(@Parameter(description="A string value representing the asset id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="assetId") String strAssetId) throws ThingsboardException {
        this.checkParameter(ASSET_ID, strAssetId);
        AssetId assetId = new AssetId(this.toUUID(strAssetId));
        return this.checkAssetInfoId(assetId, Operation.READ);
    }

    @ApiOperation(value="Create Or Update Asset (saveAsset)", notes="Creates or Updates the Asset. When creating asset, platform generates Asset Id as [time-based UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier#Version_1_(date-time_and_MAC_address)). The newly created Asset id will be present in the response. Specify existing Asset id to update the asset. Referencing non-existing Asset Id will cause 'Not Found' error. Remove 'id', 'tenantId' and optionally 'customerId' from the request body example (below) to create new Asset entity. \n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/asset"}, method={RequestMethod.POST})
    @ResponseBody
    public Asset saveAsset(@RequestBody(description="A JSON value representing the asset.") @org.springframework.web.bind.annotation.RequestBody Asset asset) throws Exception {
        asset.setTenantId(this.getTenantId());
        this.checkEntity((EntityId)asset.getId(), (HasTenantId)asset, Resource.ASSET);
        return this.tbAssetService.save(asset, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Delete asset (deleteAsset)", notes="Deletes the asset and all the relations (from and to the asset). Referencing non-existing asset Id will cause an error.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/asset/{assetId}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteAsset(@Parameter(description="A string value representing the asset id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="assetId") String strAssetId) throws Exception {
        this.checkParameter(ASSET_ID, strAssetId);
        AssetId assetId = new AssetId(this.toUUID(strAssetId));
        Asset asset = this.checkAssetId(assetId, Operation.DELETE);
        this.tbAssetService.delete(asset, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Assign asset to customer (assignAssetToCustomer)", notes="Creates assignment of the asset to customer. Customer will be able to query asset afterwards.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/customer/{customerId}/asset/{assetId}"}, method={RequestMethod.POST})
    @ResponseBody
    public Asset assignAssetToCustomer(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="customerId") String strCustomerId, @Parameter(description="A string value representing the asset id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="assetId") String strAssetId) throws ThingsboardException {
        this.checkParameter("customerId", strCustomerId);
        this.checkParameter(ASSET_ID, strAssetId);
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        Customer customer = this.checkCustomerId(customerId, Operation.READ);
        AssetId assetId = new AssetId(this.toUUID(strAssetId));
        this.checkAssetId(assetId, Operation.ASSIGN_TO_CUSTOMER);
        return this.tbAssetService.assignAssetToCustomer(this.getTenantId(), assetId, customer, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Unassign asset from customer (unassignAssetFromCustomer)", notes="Clears assignment of the asset to customer. Customer will not be able to query asset afterwards.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/customer/asset/{assetId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Asset unassignAssetFromCustomer(@Parameter(description="A string value representing the asset id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="assetId") String strAssetId) throws ThingsboardException {
        this.checkParameter(ASSET_ID, strAssetId);
        AssetId assetId = new AssetId(this.toUUID(strAssetId));
        Asset asset = this.checkAssetId(assetId, Operation.UNASSIGN_FROM_CUSTOMER);
        if (asset.getCustomerId() == null || asset.getCustomerId().getId().equals(ModelConstants.NULL_UUID)) {
            throw new IncorrectParameterException("Asset isn't assigned to any customer!");
        }
        Customer customer = this.checkCustomerId(asset.getCustomerId(), Operation.READ);
        return this.tbAssetService.unassignAssetToCustomer(this.getTenantId(), assetId, customer, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Make asset publicly available (assignAssetToPublicCustomer)", notes="Asset will be available for non-authorized (not logged-in) users. This is useful to create dashboards that you plan to share/embed on a publicly available website. However, users that are logged-in and belong to different tenant will not be able to access the asset.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/customer/public/asset/{assetId}"}, method={RequestMethod.POST})
    @ResponseBody
    public Asset assignAssetToPublicCustomer(@Parameter(description="A string value representing the asset id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="assetId") String strAssetId) throws ThingsboardException {
        this.checkParameter(ASSET_ID, strAssetId);
        AssetId assetId = new AssetId(this.toUUID(strAssetId));
        this.checkAssetId(assetId, Operation.ASSIGN_TO_CUSTOMER);
        return this.tbAssetService.assignAssetToPublicCustomer(this.getTenantId(), assetId, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get Tenant Assets (getTenantAssets)", notes="Returns a page of assets owned by tenant. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/tenant/assets"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<Asset> getTenantAssets(@Parameter(description="Maximum amount of entities in a one page") @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0") @RequestParam int page, @Parameter(description="Asset type") @RequestParam(required=false) String type, @Parameter(description="The case insensitive 'substring' filter based on the asset name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type", "label", "customerTitle"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        TenantId tenantId = this.getCurrentUser().getTenantId();
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (type != null && type.trim().length() > 0) {
            return (PageData)this.checkNotNull((Object)this.assetService.findAssetsByTenantIdAndType(tenantId, type, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.assetService.findAssetsByTenantId(tenantId, pageLink));
    }

    @ApiOperation(value="Get Tenant Asset Infos (getTenantAssetInfos)", notes="Returns a page of assets info objects owned by tenant. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. Asset Info is an extension of the default Asset object that contains information about the assigned customer name. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/tenant/assetInfos"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<AssetInfo> getTenantAssetInfos(@Parameter(description="Maximum amount of entities in a one page") @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0") @RequestParam int page, @Parameter(description="Asset type") @RequestParam(required=false) String type, @Parameter(description="A string value representing the asset profile id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @RequestParam(required=false) String assetProfileId, @Parameter(description="The case insensitive 'substring' filter based on the asset name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type", "label", "customerTitle"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        TenantId tenantId = this.getCurrentUser().getTenantId();
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (type != null && type.trim().length() > 0) {
            return (PageData)this.checkNotNull((Object)this.assetService.findAssetInfosByTenantIdAndType(tenantId, type, pageLink));
        }
        if (assetProfileId != null && assetProfileId.length() > 0) {
            AssetProfileId profileId = new AssetProfileId(this.toUUID(assetProfileId));
            return (PageData)this.checkNotNull((Object)this.assetService.findAssetInfosByTenantIdAndAssetProfileId(tenantId, profileId, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.assetService.findAssetInfosByTenantId(tenantId, pageLink));
    }

    @ApiOperation(value="Get Tenant Asset (getTenantAsset)", notes="Requested asset must be owned by tenant that the user belongs to. Asset name is an unique property of asset. So it can be used to identify the asset.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/tenant/assets"}, params={"assetName"}, method={RequestMethod.GET})
    @ResponseBody
    public Asset getTenantAsset(@Parameter(description="A string value representing the Asset name.") @RequestParam String assetName) throws ThingsboardException {
        TenantId tenantId = this.getCurrentUser().getTenantId();
        return (Asset)this.checkNotNull((Object)this.assetService.findAssetByTenantIdAndName(tenantId, assetName));
    }

    @ApiOperation(value="Get Customer Assets (getCustomerAssets)", notes="Returns a page of assets objects assigned to customer. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. ")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/customer/{customerId}/assets"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<Asset> getCustomerAssets(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="customerId") String strCustomerId, @Parameter(description="Maximum amount of entities in a one page") @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0") @RequestParam int page, @Parameter(description="Asset type") @RequestParam(required=false) String type, @Parameter(description="The case insensitive 'substring' filter based on the asset name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type", "label", "customerTitle"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.checkParameter("customerId", strCustomerId);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        this.checkCustomerId(customerId, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (type != null && type.trim().length() > 0) {
            return (PageData)this.checkNotNull((Object)this.assetService.findAssetsByTenantIdAndCustomerIdAndType(tenantId, customerId, type, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.assetService.findAssetsByTenantIdAndCustomerId(tenantId, customerId, pageLink));
    }

    @ApiOperation(value="Get Customer Asset Infos (getCustomerAssetInfos)", notes="Returns a page of assets info objects assigned to customer. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. Asset Info is an extension of the default Asset object that contains information about the assigned customer name. ")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/customer/{customerId}/assetInfos"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<AssetInfo> getCustomerAssetInfos(@Parameter(description="A string value representing the customer id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="customerId") String strCustomerId, @Parameter(description="Maximum amount of entities in a one page") @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0") @RequestParam int page, @Parameter(description="Asset type") @RequestParam(required=false) String type, @Parameter(description="A string value representing the asset profile id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @RequestParam(required=false) String assetProfileId, @Parameter(description="The case insensitive 'substring' filter based on the asset name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type", "label", "customerTitle"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.checkParameter("customerId", strCustomerId);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        CustomerId customerId = new CustomerId(this.toUUID(strCustomerId));
        this.checkCustomerId(customerId, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (type != null && type.trim().length() > 0) {
            return (PageData)this.checkNotNull((Object)this.assetService.findAssetInfosByTenantIdAndCustomerIdAndType(tenantId, customerId, type, pageLink));
        }
        if (assetProfileId != null && assetProfileId.length() > 0) {
            AssetProfileId profileId = new AssetProfileId(this.toUUID(assetProfileId));
            return (PageData)this.checkNotNull((Object)this.assetService.findAssetInfosByTenantIdAndCustomerIdAndAssetProfileId(tenantId, customerId, profileId, pageLink));
        }
        return (PageData)this.checkNotNull((Object)this.assetService.findAssetInfosByTenantIdAndCustomerId(tenantId, customerId, pageLink));
    }

    @ApiOperation(value="Get Assets By Ids (getAssetsByIds)", notes="Requested assets must be owned by tenant or assigned to customer which user is performing the request. ")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/assets"}, params={"assetIds"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Asset> getAssetsByIds(@Parameter(description="A list of assets ids, separated by comma ','", array=@ArraySchema(schema=@Schema(type="string"))) @RequestParam(value="assetIds") String[] strAssetIds) throws ThingsboardException, ExecutionException, InterruptedException {
        this.checkArrayParameter("assetIds", strAssetIds);
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        CustomerId customerId = user.getCustomerId();
        ArrayList<AssetId> assetIds = new ArrayList<AssetId>();
        for (String strAssetId : strAssetIds) {
            assetIds.add(new AssetId(this.toUUID(strAssetId)));
        }
        ListenableFuture assets = customerId == null || customerId.isNullUid() ? this.assetService.findAssetsByTenantIdAndIdsAsync(tenantId, assetIds) : this.assetService.findAssetsByTenantIdCustomerIdAndIdsAsync(tenantId, customerId, assetIds);
        return (List)this.checkNotNull((Object)((List)assets.get()));
    }

    @ApiOperation(value="Find related assets (findByQuery)", notes="Returns all assets that are related to the specific entity. The entity id, relation type, asset types, depth of the search, and other query parameters defined using complex 'AssetSearchQuery' object. See 'Model' tab of the Parameters for more info.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/assets"}, method={RequestMethod.POST})
    @ResponseBody
    public List<Asset> findByQuery(@org.springframework.web.bind.annotation.RequestBody AssetSearchQuery query) throws ThingsboardException, ExecutionException, InterruptedException {
        this.checkNotNull((Object)query);
        this.checkNotNull((Object)query.getParameters());
        this.checkNotNull((Object)query.getAssetTypes());
        this.checkEntityId(query.getParameters().getEntityId(), Operation.READ);
        List<Asset> assets = (List<Asset>)this.checkNotNull((Object)((List)this.assetService.findAssetsByQuery(this.getTenantId(), query).get()));
        assets = assets.stream().filter(asset -> {
            try {
                this.accessControlService.checkPermission(this.getCurrentUser(), Resource.ASSET, Operation.READ, (EntityId)asset.getId(), (HasTenantId)asset);
                return true;
            }
            catch (ThingsboardException e) {
                return false;
            }
        }).collect(Collectors.toList());
        return assets;
    }

    @ApiOperation(value="Get Asset Types (getAssetTypes)", notes="Deprecated. See 'getAssetProfileNames' API from Asset Profile Controller instead.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/asset/types"}, method={RequestMethod.GET})
    @ResponseBody
    @Deprecated(since="3.6.2")
    public List<EntitySubtype> getAssetTypes() throws ThingsboardException, ExecutionException, InterruptedException {
        SecurityUser user = this.getCurrentUser();
        TenantId tenantId = user.getTenantId();
        ListenableFuture assetTypes = this.assetService.findAssetTypesByTenantId(tenantId);
        return (List)this.checkNotNull((Object)((List)assetTypes.get()));
    }

    @ApiOperation(value="Assign asset to edge (assignAssetToEdge)", notes="Creates assignment of an existing asset to an instance of The Edge. Assignment works in async way - first, notification event pushed to edge service queue on platform. Second, remote edge service will receive a copy of assignment asset (Edge will receive this instantly, if it's currently connected, or once it's going to be connected to platform). Third, once asset will be delivered to edge service, it's going to be available for usage on remote edge instance.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/edge/{edgeId}/asset/{assetId}"}, method={RequestMethod.POST})
    @ResponseBody
    public Asset assignAssetToEdge(@Parameter(description="A string value representing the edge id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="edgeId") String strEdgeId, @Parameter(description="A string value representing the asset id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="assetId") String strAssetId) throws ThingsboardException {
        this.checkParameter("edgeId", strEdgeId);
        this.checkParameter(ASSET_ID, strAssetId);
        EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
        Edge edge = this.checkEdgeId(edgeId, Operation.READ);
        AssetId assetId = new AssetId(this.toUUID(strAssetId));
        this.checkAssetId(assetId, Operation.READ);
        return this.tbAssetService.assignAssetToEdge(this.getTenantId(), assetId, edge, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Unassign asset from edge (unassignAssetFromEdge)", notes="Clears assignment of the asset to the edge. Unassignment works in async way - first, 'unassign' notification event pushed to edge queue on platform. Second, remote edge service will receive an 'unassign' command to remove asset (Edge will receive this instantly, if it's currently connected, or once it's going to be connected to platform). Third, once 'unassign' command will be delivered to edge service, it's going to remove asset locally.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/edge/{edgeId}/asset/{assetId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Asset unassignAssetFromEdge(@Parameter(description="A string value representing the edge id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="edgeId") String strEdgeId, @Parameter(description="A string value representing the asset id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="assetId") String strAssetId) throws ThingsboardException {
        this.checkParameter("edgeId", strEdgeId);
        this.checkParameter(ASSET_ID, strAssetId);
        EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
        Edge edge = this.checkEdgeId(edgeId, Operation.READ);
        AssetId assetId = new AssetId(this.toUUID(strAssetId));
        Asset asset = this.checkAssetId(assetId, Operation.READ);
        return this.tbAssetService.unassignAssetFromEdge(this.getTenantId(), asset, edge, (User)this.getCurrentUser());
    }

    @ApiOperation(value="Get assets assigned to edge (getEdgeAssets)", notes="Returns a page of assets assigned to edge. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. ")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/edge/{edgeId}/assets"}, params={"pageSize", "page"}, method={RequestMethod.GET})
    @ResponseBody
    public PageData<Asset> getEdgeAssets(@Parameter(description="A string value representing the edge id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="edgeId") String strEdgeId, @Parameter(description="Maximum amount of entities in a one page") @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0") @RequestParam int page, @Parameter(description="Asset type") @RequestParam(required=false) String type, @Parameter(description="The case insensitive 'substring' filter based on the asset name.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "type", "label", "customerTitle"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder, @Parameter(description="Timestamp. Assets with creation time before it won't be queried") @RequestParam(required=false) Long startTime, @Parameter(description="Timestamp. Assets with creation time after it won't be queried") @RequestParam(required=false) Long endTime) throws ThingsboardException {
        this.checkParameter("edgeId", strEdgeId);
        TenantId tenantId = this.getCurrentUser().getTenantId();
        EdgeId edgeId = new EdgeId(this.toUUID(strEdgeId));
        this.checkEdgeId(edgeId, Operation.READ);
        TimePageLink pageLink = this.createTimePageLink(pageSize, page, textSearch, sortProperty, sortOrder, startTime, endTime);
        PageData nonFilteredResult = type != null && type.trim().length() > 0 ? this.assetService.findAssetsByTenantIdAndEdgeIdAndType(tenantId, edgeId, type, (PageLink)pageLink) : this.assetService.findAssetsByTenantIdAndEdgeId(tenantId, edgeId, (PageLink)pageLink);
        List filteredAssets = nonFilteredResult.getData().stream().filter(asset -> {
            try {
                this.accessControlService.checkPermission(this.getCurrentUser(), Resource.ASSET, Operation.READ, (EntityId)asset.getId(), (HasTenantId)asset);
                return true;
            }
            catch (ThingsboardException e) {
                return false;
            }
        }).collect(Collectors.toList());
        PageData filteredResult = new PageData(filteredAssets, nonFilteredResult.getTotalPages(), nonFilteredResult.getTotalElements(), nonFilteredResult.hasNext());
        return (PageData)this.checkNotNull((Object)filteredResult);
    }

    @ApiOperation(value="Import the bulk of assets (processAssetsBulkImport)", notes="There's an ability to import the bulk of assets using the only .csv file.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/asset/bulk_import"})
    public BulkImportResult<Asset> processAssetsBulkImport(@org.springframework.web.bind.annotation.RequestBody BulkImportRequest request) throws Exception {
        SecurityUser user = this.getCurrentUser();
        return this.assetBulkImportService.processBulkImport(request, user);
    }

    @ConstructorProperties(value={"assetBulkImportService", "tbAssetService"})
    @Generated
    public AssetController(AssetBulkImportService assetBulkImportService, TbAssetService tbAssetService) {
        this.assetBulkImportService = assetBulkImportService;
        this.tbAssetService = tbAssetService;
    }
}

