/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import dev.langchain4j.model.chat.request.ChatRequest;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.ai.AiModel;
import org.thingsboard.server.common.data.ai.dto.TbChatRequest;
import org.thingsboard.server.common.data.ai.dto.TbChatResponse;
import org.thingsboard.server.common.data.ai.model.chat.AiChatModelConfig;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.AiModelId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.ai.AiChatModelService;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.Operation;
import org.thingsboard.server.service.security.permission.Resource;

@Validated
@RestController
@TbCoreComponent
@RequestMapping(value={"/api/ai/model"})
class AiModelController
extends BaseController {
    private final AiChatModelService aiChatModelService;

    @ApiOperation(value="Create or update AI model (saveAiModel)", notes="Creates or updates an AI model record.\n\n\u2022 **Create:** Omit the `id` to create a new record. The platform assigns a UUID to the new record and returns it in the `id` field of the response.\n\n\u2022 **Update:** Include an existing `id` to modify that record. If no matching record exists, the API responds with **404 Not Found**.\n\nTenant ID for the AI model will be taken from the authenticated user making the request, regardless of any value provided in the request body.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @PostMapping
    public AiModel saveAiModel(@RequestBody @Valid AiModel model) throws ThingsboardException {
        SecurityUser user = this.getCurrentUser();
        model.setTenantId(user.getTenantId());
        this.checkEntity((EntityId)((AiModelId)model.getId()), (HasTenantId)model, Resource.AI_MODEL);
        return this.tbAiModelService.save(model, (User)user);
    }

    @ApiOperation(value="Get AI model by ID (getAiModelById)", notes="Fetches an AI model record by its `id`.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping(value={"/{modelUuid}"})
    public AiModel getAiModelById(@Parameter(description="ID of the AI model record", required=true, example="de7900d4-30e2-11f0-9cd2-0242ac120002") @PathVariable UUID modelUuid) throws ThingsboardException {
        return this.checkAiModelId(new AiModelId(modelUuid), Operation.READ);
    }

    @ApiOperation(value="Get AI models (getAiModels)", notes="Returns a page of AI models. You can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @GetMapping
    public PageData<AiModel> getAiModels(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="The case insensitive 'substring' filter based on the AI model name, provider and model ID.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "name", "provider", "modelId"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        SecurityUser user = this.getCurrentUser();
        this.accessControlService.checkPermission(user, Resource.AI_MODEL, Operation.READ);
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        return this.aiModelService.findAiModelsByTenantId(user.getTenantId(), pageLink);
    }

    @ApiOperation(value="Delete AI model by ID (deleteAiModelById)", notes="Deletes the AI model record by its `id`. If a record with the specified `id` exists, the record is deleted and the endpoint returns `true`. If no such record exists, the endpoint returns `false`.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @DeleteMapping(value={"/{modelUuid}"})
    public boolean deleteAiModelById(@Parameter(description="ID of the AI model record", required=true, example="de7900d4-30e2-11f0-9cd2-0242ac120002") @PathVariable UUID modelUuid) throws ThingsboardException {
        SecurityUser user = this.getCurrentUser();
        AiModelId modelId = new AiModelId(modelUuid);
        this.accessControlService.checkPermission(user, Resource.AI_MODEL, Operation.DELETE);
        Optional toDelete = this.aiModelService.findAiModelByTenantIdAndId(user.getTenantId(), modelId);
        if (toDelete.isEmpty()) {
            return false;
        }
        this.accessControlService.checkPermission(user, Resource.AI_MODEL, Operation.DELETE, (EntityId)modelId, (HasTenantId)((AiModel)toDelete.get()));
        return this.tbAiModelService.delete((AiModel)toDelete.get(), (User)user);
    }

    @ApiOperation(value="Send request to AI chat model (sendChatRequest)", notes="Submits a single prompt - made up of an optional system message and a required user message - to the specified AI chat model and returns either the generated answer or an error envelope.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @PostMapping(value={"/chat"})
    public DeferredResult<TbChatResponse> sendChatRequest(@Valid @RequestBody TbChatRequest tbChatRequest) {
        ChatRequest langChainChatRequest = tbChatRequest.toLangChainChatRequest();
        AiChatModelConfig chatModelConfig = tbChatRequest.chatModelConfig();
        FluentFuture future = this.aiChatModelService.sendChatRequestAsync(chatModelConfig, langChainChatRequest).transform(chatResponse -> new TbChatResponse.Success(chatResponse.aiMessage().text()), MoreExecutors.directExecutor()).catching(Throwable.class, ex -> new TbChatResponse.Failure(ex.getMessage()), MoreExecutors.directExecutor());
        Integer requestTimeoutSeconds = chatModelConfig.timeoutSeconds();
        return requestTimeoutSeconds != null ? this.wrapFuture((ListenableFuture)future, Duration.ofSeconds(requestTimeoutSeconds.intValue()).toMillis()) : this.wrapFuture((ListenableFuture)future);
    }

    @ConstructorProperties(value={"aiChatModelService"})
    @Generated
    public AiModelController(AiChatModelService aiChatModelService) {
        this.aiChatModelService = aiChatModelService;
    }
}

