/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.config;

import jakarta.servlet.Filter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.RequestCacheConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2LoginConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.client.web.AuthorizationRequestRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.header.writers.StaticHeadersWriter;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.filter.ShallowEtagHeaderFilter;
import org.thingsboard.server.config.MvcCorsProperties;
import org.thingsboard.server.config.RateLimitProcessingFilter;
import org.thingsboard.server.dao.oauth2.OAuth2Configuration;
import org.thingsboard.server.exception.ThingsboardErrorResponseHandler;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.auth.AuthExceptionHandler;
import org.thingsboard.server.service.security.auth.jwt.JwtAuthenticationProvider;
import org.thingsboard.server.service.security.auth.jwt.JwtTokenAuthenticationProcessingFilter;
import org.thingsboard.server.service.security.auth.jwt.RefreshTokenAuthenticationProvider;
import org.thingsboard.server.service.security.auth.jwt.RefreshTokenProcessingFilter;
import org.thingsboard.server.service.security.auth.jwt.SkipPathRequestMatcher;
import org.thingsboard.server.service.security.auth.jwt.extractor.TokenExtractor;
import org.thingsboard.server.service.security.auth.oauth2.HttpCookieOAuth2AuthorizationRequestRepository;
import org.thingsboard.server.service.security.auth.rest.RestAuthenticationProvider;
import org.thingsboard.server.service.security.auth.rest.RestLoginProcessingFilter;
import org.thingsboard.server.service.security.auth.rest.RestPublicLoginProcessingFilter;
import org.thingsboard.server.transport.http.config.PayloadSizeFilter;

@Configuration
@EnableWebSecurity
@EnableMethodSecurity
@Order(value=0x7FFFFFFA)
@TbCoreComponent
public class ThingsboardSecurityConfiguration {
    public static final String JWT_TOKEN_HEADER_PARAM = "X-Authorization";
    public static final String JWT_TOKEN_HEADER_PARAM_V2 = "Authorization";
    public static final String JWT_TOKEN_QUERY_PARAM = "token";
    public static final String DEVICE_API_ENTRY_POINT = "/api/v1/**";
    public static final String FORM_BASED_LOGIN_ENTRY_POINT = "/api/auth/login";
    public static final String PUBLIC_LOGIN_ENTRY_POINT = "/api/auth/login/public";
    public static final String TOKEN_REFRESH_ENTRY_POINT = "/api/auth/token";
    protected static final String[] NON_TOKEN_BASED_AUTH_ENTRY_POINTS = new String[]{"/index.html", "/assets/**", "/static/**", "/api/noauth/**", "/webjars/**", "/api/license/**", "/api/images/public/**", "/.well-known/**"};
    public static final String TOKEN_BASED_AUTH_ENTRY_POINT = "/api/**";
    public static final String WS_ENTRY_POINT = "/api/ws/**";
    public static final String MAIL_OAUTH2_PROCESSING_ENTRY_POINT = "/api/admin/mail/oauth2/code";
    public static final String DEVICE_CONNECTIVITY_CERTIFICATE_DOWNLOAD_ENTRY_POINT = "/api/device-connectivity/*/certificate/download";
    @Value(value="${server.http.max_payload_size:/api/image*/**=52428800;/api/resource/**=52428800;/api/**=16777216}")
    private String maxPayloadSizeConfig;
    @Autowired
    private ThingsboardErrorResponseHandler restAccessDeniedHandler;
    @Autowired(required=false)
    @Qualifier(value="oauth2AuthenticationSuccessHandler")
    private AuthenticationSuccessHandler oauth2AuthenticationSuccessHandler;
    @Autowired(required=false)
    @Qualifier(value="oauth2AuthenticationFailureHandler")
    private AuthenticationFailureHandler oauth2AuthenticationFailureHandler;
    @Autowired(required=false)
    private HttpCookieOAuth2AuthorizationRequestRepository httpCookieOAuth2AuthorizationRequestRepository;
    @Autowired
    @Qualifier(value="defaultAuthenticationSuccessHandler")
    private AuthenticationSuccessHandler successHandler;
    @Autowired
    @Qualifier(value="defaultAuthenticationFailureHandler")
    private AuthenticationFailureHandler failureHandler;
    @Autowired
    private RestAuthenticationProvider restAuthenticationProvider;
    @Autowired
    private JwtAuthenticationProvider jwtAuthenticationProvider;
    @Autowired
    private RefreshTokenAuthenticationProvider refreshTokenAuthenticationProvider;
    @Autowired(required=false)
    OAuth2Configuration oauth2Configuration;
    @Autowired
    @Qualifier(value="jwtHeaderTokenExtractor")
    private TokenExtractor jwtHeaderTokenExtractor;
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private RateLimitProcessingFilter rateLimitProcessingFilter;
    @Autowired
    private AuthExceptionHandler authExceptionHandler;
    @Autowired
    private OAuth2AuthorizationRequestResolver oAuth2AuthorizationRequestResolver;

    @Bean
    protected PayloadSizeFilter payloadSizeFilter() {
        return new PayloadSizeFilter(this.maxPayloadSizeConfig);
    }

    @Bean
    protected FilterRegistrationBean<ShallowEtagHeaderFilter> buildEtagFilter() throws Exception {
        ShallowEtagHeaderFilter etagFilter = new ShallowEtagHeaderFilter();
        etagFilter.setWriteWeakETag(true);
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)etagFilter, new ServletRegistrationBean[0]);
        filterRegistrationBean.addUrlPatterns(new String[]{"*.js", "*.css", "*.ico", "/assets/*", "/static/*"});
        filterRegistrationBean.setName("etagFilter");
        return filterRegistrationBean;
    }

    @Bean
    protected RestLoginProcessingFilter buildRestLoginProcessingFilter() throws Exception {
        RestLoginProcessingFilter filter = new RestLoginProcessingFilter(FORM_BASED_LOGIN_ENTRY_POINT, this.successHandler, this.failureHandler);
        filter.setAuthenticationManager(this.authenticationManager);
        return filter;
    }

    @Bean
    protected RestPublicLoginProcessingFilter buildRestPublicLoginProcessingFilter() throws Exception {
        RestPublicLoginProcessingFilter filter = new RestPublicLoginProcessingFilter(PUBLIC_LOGIN_ENTRY_POINT, this.successHandler, this.failureHandler);
        filter.setAuthenticationManager(this.authenticationManager);
        return filter;
    }

    protected JwtTokenAuthenticationProcessingFilter buildJwtTokenAuthenticationProcessingFilter() throws Exception {
        ArrayList<String> pathsToSkip = new ArrayList<String>(Arrays.asList(NON_TOKEN_BASED_AUTH_ENTRY_POINTS));
        pathsToSkip.addAll(Arrays.asList(WS_ENTRY_POINT, TOKEN_REFRESH_ENTRY_POINT, FORM_BASED_LOGIN_ENTRY_POINT, PUBLIC_LOGIN_ENTRY_POINT, DEVICE_API_ENTRY_POINT, MAIL_OAUTH2_PROCESSING_ENTRY_POINT, DEVICE_CONNECTIVITY_CERTIFICATE_DOWNLOAD_ENTRY_POINT));
        SkipPathRequestMatcher matcher = new SkipPathRequestMatcher(pathsToSkip, TOKEN_BASED_AUTH_ENTRY_POINT);
        JwtTokenAuthenticationProcessingFilter filter = new JwtTokenAuthenticationProcessingFilter(this.failureHandler, this.jwtHeaderTokenExtractor, (RequestMatcher)matcher);
        filter.setAuthenticationManager(this.authenticationManager);
        return filter;
    }

    @Bean
    protected RefreshTokenProcessingFilter buildRefreshTokenProcessingFilter() throws Exception {
        RefreshTokenProcessingFilter filter = new RefreshTokenProcessingFilter(TOKEN_REFRESH_ENTRY_POINT, this.successHandler, this.failureHandler);
        filter.setAuthenticationManager(this.authenticationManager);
        return filter;
    }

    @Bean
    public AuthenticationManager authenticationManager() {
        return new ProviderManager(List.of(this.restAuthenticationProvider, this.jwtAuthenticationProvider, this.refreshTokenAuthenticationProvider));
    }

    @Bean
    @Order(value=0)
    SecurityFilterChain resources(HttpSecurity http) throws Exception {
        http.securityMatchers(matchers -> matchers.requestMatchers(new String[]{"/*.js", "/*.css", "/*.ico", "/assets/**", "/static/**"})).headers(header -> header.defaultsDisabled().addHeaderWriter((HeaderWriter)new StaticHeadersWriter("Cache-Control", new String[]{"max-age=0, public"}))).authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.anyRequest()).permitAll()).requestCache(RequestCacheConfigurer::disable).securityContext(AbstractHttpConfigurer::disable).sessionManagement(AbstractHttpConfigurer::disable);
        return (SecurityFilterChain)http.build();
    }

    @Bean
    SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        http.headers(headers -> headers.cacheControl(config -> {}).frameOptions(config -> {}).disable()).cors(cors -> {}).csrf(AbstractHttpConfigurer::disable).exceptionHandling(config -> {}).sessionManagement(config -> config.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).authorizeHttpRequests(config -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)config.requestMatchers(NON_TOKEN_BASED_AUTH_ENTRY_POINTS)).permitAll().requestMatchers(new String[]{FORM_BASED_LOGIN_ENTRY_POINT, PUBLIC_LOGIN_ENTRY_POINT, TOKEN_REFRESH_ENTRY_POINT, MAIL_OAUTH2_PROCESSING_ENTRY_POINT, DEVICE_CONNECTIVITY_CERTIFICATE_DOWNLOAD_ENTRY_POINT, WS_ENTRY_POINT})).permitAll().requestMatchers(new String[]{TOKEN_BASED_AUTH_ENTRY_POINT})).authenticated().anyRequest()).permitAll()).exceptionHandling(config -> config.accessDeniedHandler((AccessDeniedHandler)this.restAccessDeniedHandler)).addFilterBefore((Filter)this.buildRestLoginProcessingFilter(), UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)this.buildRestPublicLoginProcessingFilter(), UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)this.buildJwtTokenAuthenticationProcessingFilter(), UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)this.buildRefreshTokenProcessingFilter(), UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)this.payloadSizeFilter(), UsernamePasswordAuthenticationFilter.class).addFilterAfter((Filter)this.rateLimitProcessingFilter, UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)this.authExceptionHandler, this.buildRestLoginProcessingFilter().getClass());
        if (this.oauth2Configuration != null) {
            http.oauth2Login(login -> ((OAuth2LoginConfigurer)login.authorizationEndpoint(config -> config.authorizationRequestRepository((AuthorizationRequestRepository)this.httpCookieOAuth2AuthorizationRequestRepository).authorizationRequestResolver(this.oAuth2AuthorizationRequestResolver)).loginPage("/oauth2Login").loginProcessingUrl(this.oauth2Configuration.getLoginProcessingUrl()).successHandler(this.oauth2AuthenticationSuccessHandler)).failureHandler(this.oauth2AuthenticationFailureHandler));
        }
        return (SecurityFilterChain)http.build();
    }

    @Bean
    @ConditionalOnMissingBean(value={CorsFilter.class})
    public CorsFilter corsFilter(@Autowired MvcCorsProperties mvcCorsProperties) {
        if (mvcCorsProperties.getMappings().isEmpty()) {
            return new CorsFilter((CorsConfigurationSource)new UrlBasedCorsConfigurationSource());
        }
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.setCorsConfigurations(mvcCorsProperties.getMappings());
        return new CorsFilter((CorsConfigurationSource)source);
    }
}

