/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.config;

import jakarta.servlet.http.HttpServletRequest;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.keygen.Base64StringKeyGenerator;
import org.springframework.security.crypto.keygen.StringKeyGenerator;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.id.OAuth2ClientId;
import org.thingsboard.server.common.data.oauth2.PlatformType;
import org.thingsboard.server.dao.oauth2.OAuth2ClientService;
import org.thingsboard.server.dao.oauth2.OAuth2Configuration;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.model.token.OAuth2AppTokenFactory;
import org.thingsboard.server.utils.MiscUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@TbCoreComponent
@Service
public class CustomOAuth2AuthorizationRequestResolver
implements OAuth2AuthorizationRequestResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomOAuth2AuthorizationRequestResolver.class);
    private static final String DEFAULT_AUTHORIZATION_REQUEST_BASE_URI = "/oauth2/authorization";
    private static final String DEFAULT_LOGIN_PROCESSING_URI = "/login/oauth2/code/";
    private static final String REGISTRATION_ID_URI_VARIABLE_NAME = "registrationId";
    private static final char PATH_DELIMITER = '/';
    private final AntPathRequestMatcher authorizationRequestMatcher = new AntPathRequestMatcher("/oauth2/authorization/{registrationId}");
    private final StringKeyGenerator stateGenerator = new Base64StringKeyGenerator(Base64.getUrlEncoder());
    private final StringKeyGenerator secureKeyGenerator = new Base64StringKeyGenerator(Base64.getUrlEncoder().withoutPadding(), 96);
    @Autowired
    private ClientRegistrationRepository clientRegistrationRepository;
    @Autowired
    private OAuth2ClientService oAuth2ClientService;
    @Autowired
    private OAuth2AppTokenFactory oAuth2AppTokenFactory;
    @Autowired(required=false)
    private OAuth2Configuration oauth2Configuration;

    public OAuth2AuthorizationRequest resolve(HttpServletRequest request) {
        String registrationId = this.resolveRegistrationId(request);
        String redirectUriAction = this.getAction(request, "login");
        String appPackage = this.getAppPackage(request);
        String platform = this.getPlatform(request);
        String appToken = this.getAppToken(request);
        return this.resolve(request, registrationId, redirectUriAction, appPackage, platform, appToken);
    }

    public OAuth2AuthorizationRequest resolve(HttpServletRequest request, String registrationId) {
        if (registrationId == null) {
            return null;
        }
        String redirectUriAction = this.getAction(request, "authorize");
        String appPackage = this.getAppPackage(request);
        String platform = this.getPlatform(request);
        String appToken = this.getAppToken(request);
        return this.resolve(request, registrationId, redirectUriAction, appPackage, platform, appToken);
    }

    private String getAction(HttpServletRequest request, String defaultAction) {
        String action = request.getParameter("action");
        if (action == null) {
            return defaultAction;
        }
        return action;
    }

    private String getAppPackage(HttpServletRequest request) {
        return request.getParameter("pkg");
    }

    private String getPlatform(HttpServletRequest request) {
        return request.getParameter("platform");
    }

    private String getAppToken(HttpServletRequest request) {
        return request.getParameter("appToken");
    }

    private OAuth2AuthorizationRequest resolve(HttpServletRequest request, String oauth2ClientId, String redirectUriAction, String appPackage, String platform, String appToken) {
        HashMap additionalParameters;
        OAuth2AuthorizationRequest.Builder builder;
        if (oauth2ClientId == null) {
            return null;
        }
        ClientRegistration clientRegistration = this.clientRegistrationRepository.findByRegistrationId(oauth2ClientId);
        if (clientRegistration == null) {
            throw new IllegalArgumentException("Invalid Client Registration with Id: " + oauth2ClientId);
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("registration_id", clientRegistration.getRegistrationId());
        if (!StringUtils.isEmpty((String)appPackage)) {
            String callbackUrlScheme;
            if (StringUtils.isEmpty((String)appToken)) {
                throw new IllegalArgumentException("Invalid application token.");
            }
            if (platform != null) {
                callbackUrlScheme = this.validateMobileAppToken(oauth2ClientId, appPackage, PlatformType.valueOf((String)platform), appToken);
            } else {
                try {
                    callbackUrlScheme = this.validateMobileAppToken(oauth2ClientId, appPackage, PlatformType.ANDROID, appToken);
                }
                catch (IllegalArgumentException e) {
                    log.debug("Failed attempt to validate android application token, oauth client id: [{}], package name: [{}], appToken [{}] ", new Object[]{oauth2ClientId, appPackage, appToken, e});
                    callbackUrlScheme = this.validateMobileAppToken(oauth2ClientId, appPackage, PlatformType.IOS, appToken);
                }
            }
            attributes.put("callback_url_scheme", callbackUrlScheme);
        }
        if (AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)clientRegistration.getAuthorizationGrantType())) {
            builder = OAuth2AuthorizationRequest.authorizationCode();
            additionalParameters = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)clientRegistration.getScopes()) && clientRegistration.getScopes().contains("openid")) {
                this.addNonceParameters(attributes, additionalParameters);
            }
            if (ClientAuthenticationMethod.NONE.equals((Object)clientRegistration.getClientAuthenticationMethod())) {
                this.addPkceParameters(attributes, additionalParameters);
            }
        } else {
            throw new IllegalArgumentException("Invalid Authorization Grant Type (" + clientRegistration.getAuthorizationGrantType().getValue() + ") for Client Registration with Id: " + clientRegistration.getRegistrationId());
        }
        builder.additionalParameters(additionalParameters);
        String redirectUriStr = this.expandRedirectUri(request, clientRegistration, redirectUriAction);
        return builder.clientId(clientRegistration.getClientId()).authorizationUri(clientRegistration.getProviderDetails().getAuthorizationUri()).redirectUri(redirectUriStr).scopes(clientRegistration.getScopes()).state(this.stateGenerator.generateKey()).attributes(attributes).build();
    }

    private String validateMobileAppToken(String oauth2ClientId, String appPackage, PlatformType platformType, String appToken) {
        String appSecret = this.oAuth2ClientService.findAppSecret(new OAuth2ClientId(UUID.fromString(oauth2ClientId)), appPackage, platformType);
        if (StringUtils.isEmpty((String)appSecret)) {
            throw new IllegalArgumentException("Invalid package: " + appPackage + ". No application secret found for Client Registration with given application package.");
        }
        return this.oAuth2AppTokenFactory.validateTokenAndGetCallbackUrlScheme(appPackage, appToken, appSecret);
    }

    private String resolveRegistrationId(HttpServletRequest request) {
        if (this.authorizationRequestMatcher.matches(request)) {
            return (String)this.authorizationRequestMatcher.matcher(request).getVariables().get("registrationId");
        }
        return null;
    }

    private String expandRedirectUri(HttpServletRequest request, ClientRegistration clientRegistration, String action) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("registrationId", clientRegistration.getRegistrationId());
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)UrlUtils.buildFullRequestUrl((HttpServletRequest)request)).replacePath(request.getContextPath()).replaceQuery(null).fragment(null).build();
        String scheme = uriComponents.getScheme();
        uriVariables.put("baseScheme", scheme == null ? "" : scheme);
        String host = uriComponents.getHost();
        uriVariables.put("baseHost", host == null ? "" : host);
        int port = uriComponents.getPort();
        uriVariables.put("basePort", port == -1 ? "" : ":" + port);
        Object path = uriComponents.getPath();
        if (StringUtils.hasLength((String)path) && ((String)path).charAt(0) != '/') {
            path = "/" + (String)path;
        }
        uriVariables.put("basePath", path == null ? "" : path);
        uriVariables.put("baseUrl", uriComponents.toUriString());
        uriVariables.put("action", action == null ? "" : action);
        String redirectUri = this.getRedirectUri(request);
        log.trace("Redirect URI - {}.", (Object)redirectUri);
        return UriComponentsBuilder.fromUriString((String)redirectUri).buildAndExpand(uriVariables).toUriString();
    }

    private String getRedirectUri(HttpServletRequest request) {
        String loginProcessingUri = this.oauth2Configuration != null ? this.oauth2Configuration.getLoginProcessingUrl() : "/login/oauth2/code/";
        String scheme = MiscUtils.getScheme((HttpServletRequest)request);
        String domainName = MiscUtils.getDomainName((HttpServletRequest)request);
        int port = MiscUtils.getPort((HttpServletRequest)request);
        String baseUrl = scheme + "://" + domainName;
        if (this.needsPort(scheme, port)) {
            baseUrl = baseUrl + ":" + port;
        }
        return baseUrl + loginProcessingUri;
    }

    private boolean needsPort(String scheme, int port) {
        boolean isHttpDefault = "http".equals(scheme.toLowerCase()) && port == 80;
        boolean isHttpsDefault = "https".equals(scheme.toLowerCase()) && port == 443;
        return !isHttpDefault && !isHttpsDefault;
    }

    private void addNonceParameters(Map<String, Object> attributes, Map<String, Object> additionalParameters) {
        try {
            String nonce = this.secureKeyGenerator.generateKey();
            String nonceHash = CustomOAuth2AuthorizationRequestResolver.createHash((String)nonce);
            attributes.put("nonce", nonce);
            additionalParameters.put("nonce", nonceHash);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    private void addPkceParameters(Map<String, Object> attributes, Map<String, Object> additionalParameters) {
        String codeVerifier = this.secureKeyGenerator.generateKey();
        attributes.put("code_verifier", codeVerifier);
        try {
            String codeChallenge = CustomOAuth2AuthorizationRequestResolver.createHash((String)codeVerifier);
            additionalParameters.put("code_challenge", codeChallenge);
            additionalParameters.put("code_challenge_method", "S256");
        }
        catch (NoSuchAlgorithmException e) {
            additionalParameters.put("code_challenge", codeVerifier);
        }
    }

    private static String createHash(String value) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] digest = md.digest(value.getBytes(StandardCharsets.US_ASCII));
        return Base64.getUrlEncoder().withoutPadding().encodeToString(digest);
    }
}

