/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors.ruleChain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DebugModeUtil;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.actors.TbActorCtx;
import org.thingsboard.server.actors.TbActorId;
import org.thingsboard.server.actors.TbActorRef;
import org.thingsboard.server.actors.TbEntityActorId;
import org.thingsboard.server.actors.ruleChain.DefaultTbContext;
import org.thingsboard.server.actors.ruleChain.RuleChainActorMessageProcessor;
import org.thingsboard.server.actors.ruleChain.RuleChainInputMsg;
import org.thingsboard.server.actors.ruleChain.RuleChainOutputMsg;
import org.thingsboard.server.actors.ruleChain.RuleChainToRuleChainMsg;
import org.thingsboard.server.actors.ruleChain.RuleChainToRuleNodeMsg;
import org.thingsboard.server.actors.ruleChain.RuleNodeActor;
import org.thingsboard.server.actors.ruleChain.RuleNodeCtx;
import org.thingsboard.server.actors.ruleChain.RuleNodeRelation;
import org.thingsboard.server.actors.ruleChain.RuleNodeToRuleChainTellNextMsg;
import org.thingsboard.server.actors.shared.ComponentMsgProcessor;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasDebugSettings;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleState;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.data.rule.RuleChainType;
import org.thingsboard.server.common.data.rule.RuleNode;
import org.thingsboard.server.common.msg.TbActorMsg;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.plugin.ComponentLifecycleMsg;
import org.thingsboard.server.common.msg.plugin.RuleNodeUpdatedMsg;
import org.thingsboard.server.common.msg.queue.PartitionChangeMsg;
import org.thingsboard.server.common.msg.queue.QueueToRuleEngineMsg;
import org.thingsboard.server.common.msg.queue.RuleEngineException;
import org.thingsboard.server.common.msg.queue.RuleNodeException;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.dao.rule.RuleChainService;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.common.MultipleTbQueueTbMsgCallbackWrapper;
import org.thingsboard.server.queue.common.TbQueueTbMsgCallbackWrapper;

public class RuleChainActorMessageProcessor
extends ComponentMsgProcessor<RuleChainId> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleChainActorMessageProcessor.class);
    private static final String NA_RELATION_TYPE = "";
    private final TbActorRef parent;
    private final TbActorRef self;
    private final Map<RuleNodeId, RuleNodeCtx> nodeActors;
    private final Map<RuleNodeId, List<RuleNodeRelation>> nodeRoutes;
    private final RuleChainService service;
    private final TbClusterService clusterService;
    private String ruleChainName;
    private RuleNodeId firstId;
    private RuleNodeCtx firstNode;
    private boolean started;

    RuleChainActorMessageProcessor(TenantId tenantId, RuleChain ruleChain, ActorSystemContext systemContext, TbActorRef parent, TbActorRef self) {
        super(systemContext, tenantId, (EntityId)ruleChain.getId());
        this.ruleChainName = ruleChain.getName();
        this.parent = parent;
        this.self = self;
        this.nodeActors = new HashMap();
        this.nodeRoutes = new HashMap();
        this.service = systemContext.getRuleChainService();
        this.clusterService = systemContext.getClusterService();
    }

    public String getComponentName() {
        return this.ruleChainName;
    }

    public void start(TbActorCtx context) {
        if (!this.started) {
            RuleChain ruleChain = this.service.findRuleChainById(this.tenantId, (RuleChainId)this.entityId);
            if (ruleChain != null && RuleChainType.CORE.equals((Object)ruleChain.getType())) {
                List ruleNodeList = this.service.getRuleChainNodes(this.tenantId, (RuleChainId)this.entityId);
                log.debug("[{}][{}] Starting rule chain with {} nodes", new Object[]{this.tenantId, this.entityId, ruleNodeList.size()});
                for (RuleNode ruleNode : ruleNodeList) {
                    log.trace("[{}][{}] Creating rule node [{}]: {}", new Object[]{this.entityId, ruleNode.getId(), ruleNode.getName(), ruleNode});
                    TbActorRef ruleNodeActor = this.createRuleNodeActor(context, ruleNode);
                    this.nodeActors.put(ruleNode.getId(), new RuleNodeCtx(this.tenantId, this.self, ruleNodeActor, ruleNode));
                }
                this.initRoutes(ruleChain, ruleNodeList);
                this.started = true;
            }
        } else {
            this.onUpdate(context);
        }
    }

    public void onUpdate(TbActorCtx context) {
        RuleChain ruleChain = this.service.findRuleChainById(this.tenantId, (RuleChainId)this.entityId);
        if (ruleChain != null && RuleChainType.CORE.equals((Object)ruleChain.getType())) {
            this.ruleChainName = ruleChain.getName();
            List ruleNodeList = this.service.getRuleChainNodes(this.tenantId, (RuleChainId)this.entityId);
            log.debug("[{}][{}] Updating rule chain with {} nodes", new Object[]{this.tenantId, this.entityId, ruleNodeList.size()});
            for (RuleNode ruleNode : ruleNodeList) {
                RuleNodeCtx existing = (RuleNodeCtx)this.nodeActors.get(ruleNode.getId());
                if (existing == null) {
                    log.trace("[{}][{}] Creating rule node [{}]: {}", new Object[]{this.entityId, ruleNode.getId(), ruleNode.getName(), ruleNode});
                    TbActorRef ruleNodeActor = this.createRuleNodeActor(context, ruleNode);
                    this.nodeActors.put(ruleNode.getId(), new RuleNodeCtx(this.tenantId, this.self, ruleNodeActor, ruleNode));
                    continue;
                }
                log.trace("[{}][{}] Updating rule node [{}]: {}", new Object[]{this.entityId, ruleNode.getId(), ruleNode.getName(), ruleNode});
                existing.setSelf(ruleNode);
                existing.getSelfActor().tellWithHighPriority((TbActorMsg)new RuleNodeUpdatedMsg(this.tenantId, (EntityId)existing.getSelf().getId()));
            }
            Set existingNodes = ruleNodeList.stream().map(RuleNode::getId).collect(Collectors.toSet());
            List<RuleNodeId> removedRules = this.nodeActors.keySet().stream().filter(node -> !existingNodes.contains(node)).toList();
            removedRules.forEach(ruleNodeId -> {
                log.trace("[{}][{}] Removing rule node [{}]", new Object[]{this.tenantId, this.entityId, ruleNodeId});
                RuleNodeCtx removed = (RuleNodeCtx)this.nodeActors.remove(ruleNodeId);
                removed.getSelfActor().tellWithHighPriority((TbActorMsg)new ComponentLifecycleMsg(this.tenantId, (EntityId)removed.getSelf().getId(), ComponentLifecycleEvent.DELETED));
            });
            this.initRoutes(ruleChain, ruleNodeList);
        }
    }

    public void stop(TbActorCtx ctx) {
        log.trace("[{}][{}] Stopping rule chain with {} nodes", new Object[]{this.tenantId, this.entityId, this.nodeActors.size()});
        this.nodeActors.values().stream().map(RuleNodeCtx::getSelfActor).map(TbActorRef::getActorId).forEach(arg_0 -> ((TbActorCtx)ctx).stop(arg_0));
        this.nodeActors.clear();
        this.nodeRoutes.clear();
        this.started = false;
    }

    public void onPartitionChangeMsg(PartitionChangeMsg msg) {
        log.debug("[{}][{}] onPartitionChangeMsg: [{}]", new Object[]{this.tenantId, this.entityId, msg});
        this.nodeActors.values().stream().map(RuleNodeCtx::getSelfActor).forEach(actorRef -> actorRef.tellWithHighPriority((TbActorMsg)msg));
    }

    private TbActorRef createRuleNodeActor(TbActorCtx ctx, RuleNode ruleNode) {
        return ctx.getOrCreateChildActor((TbActorId)new TbEntityActorId((EntityId)ruleNode.getId()), () -> "rule-dispatcher", () -> new RuleNodeActor.ActorCreator(this.systemContext, this.tenantId, (RuleChainId)this.entityId, this.ruleChainName, ruleNode.getId()), () -> true);
    }

    private void initRoutes(RuleChain ruleChain, List<RuleNode> ruleNodeList) {
        this.nodeRoutes.clear();
        for (RuleNode ruleNode : ruleNodeList) {
            List relations = this.service.getRuleNodeRelations(TenantId.SYS_TENANT_ID, ruleNode.getId());
            log.trace("[{}][{}][{}] Processing rule node relations [{}]", new Object[]{this.tenantId, this.entityId, ruleNode.getId(), relations.size()});
            if (relations.isEmpty()) {
                this.nodeRoutes.put(ruleNode.getId(), Collections.emptyList());
                continue;
            }
            for (EntityRelation relation : relations) {
                RuleNodeCtx ruleNodeCtx;
                log.trace("[{}][{}][{}] Processing rule node relation [{}]", new Object[]{this.tenantId, this.entityId, ruleNode.getId(), relation.getTo()});
                if (relation.getTo().getEntityType() == EntityType.RULE_NODE && (ruleNodeCtx = (RuleNodeCtx)this.nodeActors.get(new RuleNodeId(relation.getTo().getId()))) == null) {
                    throw new IllegalArgumentException("Rule Node [" + String.valueOf(relation.getFrom()) + "] has invalid relation to Rule node [" + String.valueOf(relation.getTo()) + "]");
                }
                this.nodeRoutes.computeIfAbsent(ruleNode.getId(), k -> new ArrayList()).add(new RuleNodeRelation((EntityId)ruleNode.getId(), relation.getTo(), relation.getType()));
            }
        }
        this.firstId = ruleChain.getFirstRuleNodeId();
        this.firstNode = (RuleNodeCtx)this.nodeActors.get(this.firstId);
        this.state = ComponentLifecycleState.ACTIVE;
    }

    void onQueueToRuleEngineMsg(QueueToRuleEngineMsg envelope) {
        TbMsg msg = envelope.getMsg();
        if (!this.checkMsgValid(msg)) {
            return;
        }
        log.trace("[{}][{}] Processing message [{}]: {}", new Object[]{this.entityId, this.firstId, msg.getId(), msg});
        if (envelope.getRelationTypes() == null || envelope.getRelationTypes().isEmpty()) {
            this.onTellNext(msg, true);
        } else {
            this.onTellNext(msg, envelope.getMsg().getRuleNodeId(), envelope.getRelationTypes(), envelope.getFailureMessage());
        }
    }

    private void onTellNext(TbMsg msg, boolean useRuleNodeIdFromMsg) {
        try {
            RuleNodeCtx targetCtx;
            RuleNodeId targetId;
            this.checkComponentStateActive(msg);
            RuleNodeId ruleNodeId = targetId = useRuleNodeIdFromMsg ? msg.getRuleNodeId() : null;
            if (targetId == null) {
                targetCtx = this.firstNode;
                msg = msg.copy().ruleChainId((RuleChainId)this.entityId).resetRuleNodeId().build();
            } else {
                targetCtx = (RuleNodeCtx)this.nodeActors.get(targetId);
            }
            if (targetCtx != null) {
                log.trace("[{}][{}] Pushing message to target rule node", (Object)this.entityId, (Object)targetId);
                this.pushMsgToNode(targetCtx, msg, NA_RELATION_TYPE);
            } else {
                log.trace("[{}][{}] Rule node does not exist. Probably old message", (Object)this.entityId, (Object)targetId);
                msg.getCallback().onSuccess();
            }
        }
        catch (RuleNodeException rne) {
            msg.getCallback().onFailure((RuleEngineException)rne);
        }
        catch (Exception e) {
            msg.getCallback().onFailure(new RuleEngineException(e.getMessage(), (Throwable)e));
        }
    }

    public void onRuleChainInputMsg(RuleChainInputMsg envelope) {
        TbMsg tbMsg = envelope.getMsg();
        if (!this.checkMsgValid(tbMsg)) {
            return;
        }
        if (((RuleChainId)this.entityId).equals((Object)envelope.getRuleChainId())) {
            this.onTellNext(tbMsg, false);
        } else {
            this.parent.tell((TbActorMsg)envelope);
        }
    }

    public void onRuleChainOutputMsg(RuleChainOutputMsg envelope) {
        TbMsg tbMsg = envelope.getMsg();
        if (!this.checkMsgValid(tbMsg)) {
            return;
        }
        if (((RuleChainId)this.entityId).equals((Object)envelope.getRuleChainId())) {
            RuleNodeId originatorNodeId = envelope.getTargetRuleNodeId();
            RuleNodeCtx ruleNodeCtx = (RuleNodeCtx)this.nodeActors.get(originatorNodeId);
            if (ruleNodeCtx != null && DebugModeUtil.isDebugAvailable((HasDebugSettings)ruleNodeCtx.getSelf(), (String)envelope.getRelationType())) {
                this.systemContext.persistDebugOutput(this.tenantId, (EntityId)originatorNodeId, tbMsg, envelope.getRelationType());
            }
            this.onTellNext(tbMsg, originatorNodeId, Collections.singleton(envelope.getRelationType()), "Unknown");
        } else {
            this.parent.tell((TbActorMsg)envelope);
        }
    }

    void onRuleChainToRuleChainMsg(RuleChainToRuleChainMsg envelope) {
        TbMsg tbMsg = envelope.getMsg();
        if (!this.checkMsgValid(tbMsg)) {
            return;
        }
        try {
            this.checkComponentStateActive(tbMsg);
            if (this.firstNode != null) {
                this.pushMsgToNode(this.firstNode, tbMsg, envelope.getFromRelationType());
            } else {
                tbMsg.getCallback().onSuccess();
            }
        }
        catch (RuleNodeException e) {
            log.debug("Rule Chain is not active. Current state [{}] for processor [{}][{}] tenant [{}]", new Object[]{this.state, ((RuleChainId)this.entityId).getEntityType(), this.entityId, this.tenantId});
        }
    }

    void onTellNext(RuleNodeToRuleChainTellNextMsg envelope) {
        TbMsg msg = envelope.getMsg();
        if (this.checkMsgValid(msg)) {
            this.onTellNext(msg, envelope.getOriginator(), envelope.getRelationTypes(), envelope.getFailureMessage());
        }
    }

    private void onTellNext(TbMsg msg, RuleNodeId originatorNodeId, Set<String> relationTypes, String failureMessage) {
        try {
            List relationsByTypes;
            int relationsCount;
            this.checkComponentStateActive(msg);
            EntityId entityId = msg.getOriginator();
            TopicPartitionInfo tpi = this.systemContext.resolve(this.tenantId, entityId, msg);
            List ruleNodeRelations = (List)this.nodeRoutes.get(originatorNodeId);
            if (ruleNodeRelations == null) {
                log.warn("[{}][{}][{}] No outbound relations (null). Probably rule node does not exist. Probably old message.", new Object[]{this.tenantId, entityId, msg.getId()});
                ruleNodeRelations = Collections.emptyList();
            }
            if ((relationsCount = (relationsByTypes = ruleNodeRelations.stream().filter(r -> this.contains(relationTypes, r.getType())).collect(Collectors.toList())).size()) == 0) {
                log.trace("[{}][{}][{}] No outbound relations to process", new Object[]{this.tenantId, entityId, msg.getId()});
                if (relationTypes.contains("Failure")) {
                    RuleNodeCtx ruleNodeCtx = (RuleNodeCtx)this.nodeActors.get(originatorNodeId);
                    if (ruleNodeCtx != null) {
                        msg.getCallback().onFailure((RuleEngineException)new RuleNodeException(failureMessage, this.ruleChainName, ruleNodeCtx.getSelf()));
                    } else {
                        log.debug("[{}] Failure during message processing by Rule Node [{}]. Enable and see debug events for more info", (Object)entityId, (Object)originatorNodeId.getId());
                        msg.getCallback().onFailure(new RuleEngineException("Failure during message processing by Rule Node [" + originatorNodeId.getId().toString() + "]"));
                    }
                } else {
                    msg.getCallback().onSuccess();
                }
            } else if (relationsCount == 1) {
                for (RuleNodeRelation relation : relationsByTypes) {
                    log.trace("[{}][{}][{}] Pushing message to single target: [{}]", new Object[]{this.tenantId, entityId, msg.getId(), relation.getOut()});
                    this.pushToTarget(tpi, msg, relation.getOut(), relation.getType());
                }
            } else {
                MultipleTbQueueTbMsgCallbackWrapper callbackWrapper = new MultipleTbQueueTbMsgCallbackWrapper(relationsCount, msg.getCallback());
                log.trace("[{}][{}][{}] Pushing message to multiple targets: [{}]", new Object[]{this.tenantId, entityId, msg.getId(), relationsByTypes});
                for (RuleNodeRelation relation : relationsByTypes) {
                    EntityId target = relation.getOut();
                    this.putToQueue(tpi, msg, (TbQueueCallback)callbackWrapper, target);
                }
            }
        }
        catch (RuleNodeException rne) {
            msg.getCallback().onFailure((RuleEngineException)rne);
        }
        catch (Exception e) {
            log.warn("[" + String.valueOf(this.tenantId) + "][" + String.valueOf(this.entityId) + "][" + String.valueOf(msg.getId()) + "] onTellNext failure", (Throwable)e);
            msg.getCallback().onFailure(new RuleEngineException("onTellNext - " + e.getMessage(), (Throwable)e));
        }
    }

    private void putToQueue(TopicPartitionInfo tpi, TbMsg msg, TbQueueCallback callbackWrapper, EntityId target) {
        switch (1.$SwitchMap$org$thingsboard$server$common$data$EntityType[target.getEntityType().ordinal()]) {
            case 1: {
                this.putToQueue(tpi, msg.copy().id(UUID.randomUUID()).ruleChainId((RuleChainId)this.entityId).ruleNodeId(new RuleNodeId(target.getId())).build(), callbackWrapper);
                break;
            }
            case 2: {
                this.putToQueue(tpi, msg.copy().id(UUID.randomUUID()).ruleChainId(new RuleChainId(target.getId())).resetRuleNodeId().build(), callbackWrapper);
            }
        }
    }

    private void pushToTarget(TopicPartitionInfo tpi, TbMsg msg, EntityId target, String fromRelationType) {
        if (tpi.isMyPartition()) {
            switch (1.$SwitchMap$org$thingsboard$server$common$data$EntityType[target.getEntityType().ordinal()]) {
                case 1: {
                    this.pushMsgToNode((RuleNodeCtx)this.nodeActors.get(new RuleNodeId(target.getId())), msg, fromRelationType);
                    break;
                }
                case 2: {
                    this.parent.tell((TbActorMsg)new RuleChainToRuleChainMsg(new RuleChainId(target.getId()), (RuleChainId)this.entityId, msg, fromRelationType));
                }
            }
        } else {
            this.putToQueue(tpi, msg, (TbQueueCallback)new TbQueueTbMsgCallbackWrapper(msg.getCallback()), target);
        }
    }

    private void putToQueue(TopicPartitionInfo tpi, TbMsg newMsg, TbQueueCallback callbackWrapper) {
        TransportProtos.ToRuleEngineMsg toQueueMsg = TransportProtos.ToRuleEngineMsg.newBuilder().setTenantIdMSB(this.tenantId.getId().getMostSignificantBits()).setTenantIdLSB(this.tenantId.getId().getLeastSignificantBits()).setTbMsgProto(TbMsg.toProto((TbMsg)newMsg)).build();
        this.clusterService.pushMsgToRuleEngine(tpi, newMsg.getId(), toQueueMsg, callbackWrapper);
    }

    private boolean contains(Set<String> relationTypes, String type) {
        if (relationTypes == null) {
            return true;
        }
        for (String relationType : relationTypes) {
            if (!relationType.equalsIgnoreCase(type)) continue;
            return true;
        }
        return false;
    }

    private void pushMsgToNode(RuleNodeCtx nodeCtx, TbMsg msg, String fromRelationType) {
        if (nodeCtx != null) {
            DefaultTbContext tbCtx = new DefaultTbContext(this.systemContext, this.ruleChainName, nodeCtx);
            nodeCtx.getSelfActor().tell((TbActorMsg)new RuleChainToRuleNodeMsg((TbContext)tbCtx, msg, fromRelationType));
        } else {
            log.error("[{}][{}] RuleNodeCtx is empty", (Object)this.entityId, (Object)this.ruleChainName);
            msg.getCallback().onFailure(new RuleEngineException("Rule Node CTX is empty"));
        }
    }

    protected RuleNodeException getInactiveException() {
        RuleNode firstRuleNode = this.firstNode != null ? this.firstNode.getSelf() : null;
        return new RuleNodeException("Rule Chain is not active!  Failed to initialize.", this.ruleChainName, firstRuleNode);
    }
}

