/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors.calculatedField;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DebugModeUtil;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.actors.TbActorCtx;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldEntityDeleteMsg;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldException;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldStateRestoreMsg;
import org.thingsboard.server.actors.calculatedField.EntityCalculatedFieldLinkedTelemetryMsg;
import org.thingsboard.server.actors.calculatedField.EntityCalculatedFieldTelemetryMsg;
import org.thingsboard.server.actors.calculatedField.EntityInitCalculatedFieldMsg;
import org.thingsboard.server.actors.calculatedField.MultipleTbCallback;
import org.thingsboard.server.actors.shared.AbstractContextAwareMsgProcessor;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.HasDebugSettings;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.cf.configuration.Argument;
import org.thingsboard.server.common.data.cf.configuration.ArgumentType;
import org.thingsboard.server.common.data.cf.configuration.ReferencedEntityKey;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.BasicKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.StringDataEntry;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.msg.cf.CalculatedFieldPartitionChangeMsg;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TbCallback;
import org.thingsboard.server.common.util.ProtoUtils;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.service.cf.CalculatedFieldProcessingService;
import org.thingsboard.server.service.cf.CalculatedFieldResult;
import org.thingsboard.server.service.cf.CalculatedFieldStateService;
import org.thingsboard.server.service.cf.ctx.CalculatedFieldEntityCtxId;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.SingleValueArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.TsRollingArgumentEntry;

/*
 * Exception performing whole class analysis ignored.
 */
public class CalculatedFieldEntityMessageProcessor
extends AbstractContextAwareMsgProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalculatedFieldEntityMessageProcessor.class);
    public static final int CALLBACKS_PER_CF = 2;
    final TenantId tenantId;
    final EntityId entityId;
    final CalculatedFieldProcessingService cfService;
    final CalculatedFieldStateService cfStateService;
    TbActorCtx ctx;
    Map<CalculatedFieldId, CalculatedFieldState> states = new HashMap();

    CalculatedFieldEntityMessageProcessor(ActorSystemContext systemContext, TenantId tenantId, EntityId entityId) {
        super(systemContext);
        this.tenantId = tenantId;
        this.entityId = entityId;
        this.cfService = systemContext.getCalculatedFieldProcessingService();
        this.cfStateService = systemContext.getCalculatedFieldStateService();
    }

    void init(TbActorCtx ctx) {
        this.ctx = ctx;
    }

    public void stop() {
        log.info("[{}][{}] Stopping entity actor.", (Object)this.tenantId, (Object)this.entityId);
        this.states.clear();
        this.ctx.stop(this.ctx.getSelf());
    }

    public void process(CalculatedFieldPartitionChangeMsg msg) {
        if (!this.systemContext.getPartitionService().resolve(ServiceType.TB_RULE_ENGINE, "CalculatedFields", this.tenantId, this.entityId).isMyPartition()) {
            log.info("[{}] Stopping entity actor due to change partition event.", (Object)this.entityId);
            this.ctx.stop(this.ctx.getSelf());
        }
    }

    public void process(CalculatedFieldStateRestoreMsg msg) {
        CalculatedFieldId cfId = msg.getId().cfId();
        log.debug("[{}] [{}] Processing CF state restore msg.", (Object)msg.getId().entityId(), (Object)cfId);
        if (msg.getState() != null) {
            this.states.put(cfId, msg.getState());
        } else {
            this.states.remove(cfId);
        }
        msg.getCallback().onSuccess();
    }

    public void process(EntityInitCalculatedFieldMsg msg) throws CalculatedFieldException {
        log.debug("[{}] Processing entity init CF msg.", (Object)msg.getCtx().getCfId());
        CalculatedFieldCtx ctx = msg.getCtx();
        if (msg.isForceReinit()) {
            log.debug("Force reinitialization of CF: [{}].", (Object)ctx.getCfId());
            this.states.remove(ctx.getCfId());
        }
        try {
            CalculatedFieldState state = this.getOrInitState(ctx);
            if (!state.isSizeOk()) {
                throw new RuntimeException(ctx.getSizeExceedsLimitMessage());
            }
            this.processStateIfReady(ctx, Collections.singletonList(ctx.getCfId()), state, null, null, msg.getCallback());
        }
        catch (Exception e) {
            if (e instanceof CalculatedFieldException) {
                CalculatedFieldException cfe = (CalculatedFieldException)e;
                throw cfe;
            }
            throw CalculatedFieldException.builder().ctx(ctx).eventEntity(this.entityId).cause(e).build();
        }
    }

    public void process(CalculatedFieldEntityDeleteMsg msg) {
        log.debug("[{}] Processing CF entity delete msg.", (Object)msg.getEntityId());
        if (this.entityId.equals(msg.getEntityId())) {
            if (this.states.isEmpty()) {
                msg.getCallback().onSuccess();
            } else {
                MultipleTbCallback multipleTbCallback = new MultipleTbCallback(this.states.size(), msg.getCallback());
                this.states.forEach((cfId, state) -> this.cfStateService.removeState(new CalculatedFieldEntityCtxId(this.tenantId, cfId, this.entityId), (TbCallback)multipleTbCallback));
                this.ctx.stop(this.ctx.getSelf());
            }
        } else {
            CalculatedFieldId cfId2 = new CalculatedFieldId(msg.getEntityId().getId());
            CalculatedFieldState state2 = (CalculatedFieldState)this.states.remove(cfId2);
            if (state2 != null) {
                this.cfStateService.removeState(new CalculatedFieldEntityCtxId(this.tenantId, cfId2, this.entityId), msg.getCallback());
            } else {
                msg.getCallback().onSuccess();
            }
        }
    }

    public void process(EntityCalculatedFieldTelemetryMsg msg) throws CalculatedFieldException {
        log.debug("[{}] Processing CF telemetry msg.", (Object)msg.getEntityId());
        TransportProtos.CalculatedFieldTelemetryMsgProto proto = msg.getProto();
        int numberOfCallbacks = 2 * (msg.getEntityIdFields().size() + msg.getProfileIdFields().size());
        MultipleTbCallback callback = new MultipleTbCallback(numberOfCallbacks, msg.getCallback());
        List cfIdList = CalculatedFieldEntityMessageProcessor.getCalculatedFieldIds((TransportProtos.CalculatedFieldTelemetryMsgProto)proto);
        HashSet cfIdSet = new HashSet(cfIdList);
        for (CalculatedFieldCtx ctx : msg.getEntityIdFields()) {
            this.process(ctx, proto, cfIdSet, cfIdList, callback);
        }
        for (CalculatedFieldCtx ctx : msg.getProfileIdFields()) {
            this.process(ctx, proto, cfIdSet, cfIdList, callback);
        }
    }

    public void process(EntityCalculatedFieldLinkedTelemetryMsg msg) throws CalculatedFieldException {
        log.debug("[{}] Processing CF link telemetry msg.", (Object)msg.getEntityId());
        TransportProtos.CalculatedFieldTelemetryMsgProto proto = msg.getProto();
        CalculatedFieldCtx ctx = msg.getCtx();
        MultipleTbCallback callback = new MultipleTbCallback(2, msg.getCallback());
        try {
            List cfIds = CalculatedFieldEntityMessageProcessor.getCalculatedFieldIds((TransportProtos.CalculatedFieldTelemetryMsgProto)proto);
            if (cfIds.contains(ctx.getCfId())) {
                callback.onSuccess(2);
            } else if (proto.getTsDataCount() > 0) {
                this.processArgumentValuesUpdate(ctx, cfIds, callback, this.mapToArguments(ctx, msg.getEntityId(), proto.getTsDataList()), this.toTbMsgId(proto), this.toTbMsgType(proto));
            } else if (proto.getAttrDataCount() > 0) {
                this.processArgumentValuesUpdate(ctx, cfIds, callback, this.mapToArguments(ctx, msg.getEntityId(), proto.getScope(), proto.getAttrDataList()), this.toTbMsgId(proto), this.toTbMsgType(proto));
            } else if (proto.getRemovedTsKeysCount() > 0) {
                this.processArgumentValuesUpdate(ctx, cfIds, callback, this.mapToArgumentsWithFetchedValue(ctx, (List)proto.getRemovedTsKeysList()), this.toTbMsgId(proto), this.toTbMsgType(proto));
            } else if (proto.getRemovedAttrKeysCount() > 0) {
                this.processArgumentValuesUpdate(ctx, cfIds, callback, this.mapToArgumentsWithDefaultValue(ctx, msg.getEntityId(), proto.getScope(), (List)proto.getRemovedAttrKeysList()), this.toTbMsgId(proto), this.toTbMsgType(proto));
            } else {
                callback.onSuccess(2);
            }
        }
        catch (Exception e) {
            throw CalculatedFieldException.builder().ctx(ctx).eventEntity(this.entityId).cause(e).build();
        }
    }

    private void process(CalculatedFieldCtx ctx, TransportProtos.CalculatedFieldTelemetryMsgProto proto, Collection<CalculatedFieldId> cfIds, List<CalculatedFieldId> cfIdList, MultipleTbCallback callback) throws CalculatedFieldException {
        try {
            if (cfIds.contains(ctx.getCfId())) {
                callback.onSuccess(2);
            } else if (proto.getTsDataCount() > 0) {
                this.processTelemetry(ctx, proto, cfIdList, callback);
            } else if (proto.getAttrDataCount() > 0) {
                this.processAttributes(ctx, proto, cfIdList, callback);
            } else if (proto.getRemovedTsKeysCount() > 0) {
                this.processRemovedTelemetry(ctx, proto, cfIdList, callback);
            } else if (proto.getRemovedAttrKeysCount() > 0) {
                this.processRemovedAttributes(ctx, proto, cfIdList, callback);
            } else {
                callback.onSuccess(2);
            }
        }
        catch (Exception e) {
            if (e instanceof CalculatedFieldException) {
                CalculatedFieldException cfe = (CalculatedFieldException)e;
                throw cfe;
            }
            throw CalculatedFieldException.builder().ctx(ctx).eventEntity(this.entityId).cause(e).build();
        }
    }

    private void processTelemetry(CalculatedFieldCtx ctx, TransportProtos.CalculatedFieldTelemetryMsgProto proto, List<CalculatedFieldId> cfIdList, MultipleTbCallback callback) throws CalculatedFieldException {
        this.processArgumentValuesUpdate(ctx, cfIdList, callback, this.mapToArguments(ctx, proto.getTsDataList()), this.toTbMsgId(proto), this.toTbMsgType(proto));
    }

    private void processAttributes(CalculatedFieldCtx ctx, TransportProtos.CalculatedFieldTelemetryMsgProto proto, List<CalculatedFieldId> cfIdList, MultipleTbCallback callback) throws CalculatedFieldException {
        this.processArgumentValuesUpdate(ctx, cfIdList, callback, this.mapToArguments(ctx, proto.getScope(), proto.getAttrDataList()), this.toTbMsgId(proto), this.toTbMsgType(proto));
    }

    private void processRemovedTelemetry(CalculatedFieldCtx ctx, TransportProtos.CalculatedFieldTelemetryMsgProto proto, List<CalculatedFieldId> cfIdList, MultipleTbCallback callback) throws CalculatedFieldException {
        this.processArgumentValuesUpdate(ctx, cfIdList, callback, this.mapToArgumentsWithFetchedValue(ctx, (List)proto.getRemovedTsKeysList()), this.toTbMsgId(proto), this.toTbMsgType(proto));
    }

    private void processRemovedAttributes(CalculatedFieldCtx ctx, TransportProtos.CalculatedFieldTelemetryMsgProto proto, List<CalculatedFieldId> cfIdList, MultipleTbCallback callback) throws CalculatedFieldException {
        this.processArgumentValuesUpdate(ctx, cfIdList, callback, this.mapToArgumentsWithDefaultValue(ctx, proto.getScope(), (List)proto.getRemovedAttrKeysList()), this.toTbMsgId(proto), this.toTbMsgType(proto));
    }

    private void processArgumentValuesUpdate(CalculatedFieldCtx ctx, List<CalculatedFieldId> cfIdList, MultipleTbCallback callback, Map<String, ArgumentEntry> newArgValues, UUID tbMsgId, TbMsgType tbMsgType) throws CalculatedFieldException {
        if (newArgValues.isEmpty()) {
            log.debug("[{}] No new argument values to process for CF.", (Object)ctx.getCfId());
            callback.onSuccess(2);
        }
        CalculatedFieldState state = (CalculatedFieldState)this.states.get(ctx.getCfId());
        boolean justRestored = false;
        if (state == null) {
            state = this.getOrInitState(ctx);
            justRestored = true;
        }
        if (state.isSizeOk()) {
            if (state.updateState(ctx, newArgValues) || justRestored) {
                cfIdList = new ArrayList<CalculatedFieldId>(cfIdList);
                cfIdList.add(ctx.getCfId());
                this.processStateIfReady(ctx, cfIdList, state, tbMsgId, tbMsgType, (TbCallback)callback);
            } else {
                callback.onSuccess(2);
            }
        } else {
            throw CalculatedFieldException.builder().ctx(ctx).eventEntity(this.entityId).errorMessage(ctx.getSizeExceedsLimitMessage()).build();
        }
    }

    private CalculatedFieldState getOrInitState(CalculatedFieldCtx ctx) {
        CalculatedFieldState state = (CalculatedFieldState)this.states.get(ctx.getCfId());
        if (state != null) {
            return state;
        }
        ListenableFuture stateFuture = this.systemContext.getCalculatedFieldProcessingService().fetchStateFromDb(ctx, this.entityId);
        state = (CalculatedFieldState)stateFuture.get(1L, TimeUnit.MINUTES);
        state.checkStateSize(new CalculatedFieldEntityCtxId(this.tenantId, ctx.getCfId(), this.entityId), ctx.getMaxStateSize());
        this.states.put(ctx.getCfId(), state);
        return state;
    }

    private void processStateIfReady(CalculatedFieldCtx ctx, List<CalculatedFieldId> cfIdList, CalculatedFieldState state, UUID tbMsgId, TbMsgType tbMsgType, TbCallback callback) throws CalculatedFieldException {
        CalculatedFieldEntityCtxId ctxId = new CalculatedFieldEntityCtxId(this.tenantId, ctx.getCfId(), this.entityId);
        boolean stateSizeChecked = false;
        try {
            if (ctx.isInitialized() && state.isReady()) {
                CalculatedFieldResult calculationResult = (CalculatedFieldResult)state.performCalculation(ctx).get(this.systemContext.getCfCalculationResultTimeout(), TimeUnit.SECONDS);
                state.checkStateSize(ctxId, ctx.getMaxStateSize());
                stateSizeChecked = true;
                if (state.isSizeOk()) {
                    if (!calculationResult.isEmpty()) {
                        this.cfService.pushMsgToRuleEngine(this.tenantId, this.entityId, calculationResult, cfIdList, callback);
                    } else {
                        callback.onSuccess();
                    }
                    if (DebugModeUtil.isDebugAllAvailable((HasDebugSettings)ctx.getCalculatedField())) {
                        this.systemContext.persistCalculatedFieldDebugEvent(this.tenantId, ctx.getCfId(), this.entityId, state.getArguments(), tbMsgId, tbMsgType, calculationResult.getResult().toString(), null);
                    }
                }
            } else {
                callback.onSuccess();
            }
        }
        catch (Exception e) {
            throw CalculatedFieldException.builder().ctx(ctx).eventEntity(this.entityId).msgId(tbMsgId).msgType(tbMsgType).arguments(state.getArguments()).cause(e).build();
        }
        finally {
            if (!stateSizeChecked) {
                state.checkStateSize(ctxId, ctx.getMaxStateSize());
            }
            if (state.isSizeOk()) {
                this.cfStateService.persistState(ctxId, state, callback);
            } else {
                this.removeStateAndRaiseSizeException(ctxId, CalculatedFieldException.builder().ctx(ctx).eventEntity(this.entityId).errorMessage(ctx.getSizeExceedsLimitMessage()).build(), callback);
            }
        }
    }

    private void removeStateAndRaiseSizeException(CalculatedFieldEntityCtxId ctxId, CalculatedFieldException ex, TbCallback callback) throws CalculatedFieldException {
        this.cfStateService.removeState(ctxId, (TbCallback)new /* Unavailable Anonymous Inner Class!! */);
        throw ex;
    }

    private Map<String, ArgumentEntry> mapToArguments(CalculatedFieldCtx ctx, List<TransportProtos.TsKvProto> data) {
        return this.mapToArguments(ctx.getMainEntityArguments(), data);
    }

    private Map<String, ArgumentEntry> mapToArguments(CalculatedFieldCtx ctx, EntityId entityId, List<TransportProtos.TsKvProto> data) {
        Map argNames = (Map)ctx.getLinkedEntityArguments().get(entityId);
        if (argNames.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.mapToArguments(argNames, data);
    }

    private Map<String, ArgumentEntry> mapToArguments(Map<ReferencedEntityKey, Set<String>> args, List<TransportProtos.TsKvProto> data) {
        if (args.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, ArgumentEntry> arguments = new HashMap<String, ArgumentEntry>();
        for (TransportProtos.TsKvProto item : data) {
            ReferencedEntityKey key = new ReferencedEntityKey(item.getKv().getKey(), ArgumentType.TS_LATEST, null);
            Set<String> argNames = args.get(key);
            if (argNames != null) {
                SingleValueArgumentEntry incoming = new SingleValueArgumentEntry(item);
                argNames.forEach(argName -> arguments.compute((String)argName, (name, existing) -> {
                    if (existing == null) {
                        return incoming;
                    }
                    existing.updateEntry((ArgumentEntry)incoming);
                    return existing;
                }));
            }
            if ((argNames = args.get(key = new ReferencedEntityKey(item.getKv().getKey(), ArgumentType.TS_ROLLING, null))) == null) continue;
            Double recordValue = TsRollingArgumentEntry.getValueForTsRecord((KvEntry)ProtoUtils.fromProto((TransportProtos.KeyValueProto)item.getKv()));
            argNames.forEach(argName -> arguments.compute((String)argName, (name, existing) -> {
                SingleValueArgumentEntry single;
                Double existingValue;
                if (existing instanceof TsRollingArgumentEntry) {
                    TsRollingArgumentEntry rolling = (TsRollingArgumentEntry)existing;
                    if (recordValue != null) {
                        rolling.getTsRecords().put(item.getTs(), recordValue);
                    }
                    return rolling;
                }
                TsRollingArgumentEntry rolling = new TsRollingArgumentEntry();
                if (recordValue != null) {
                    rolling.getTsRecords().put(item.getTs(), recordValue);
                }
                if (existing instanceof SingleValueArgumentEntry && (existingValue = TsRollingArgumentEntry.getValueForTsRecord((KvEntry)(single = (SingleValueArgumentEntry)existing).getKvEntryValue())) != null) {
                    rolling.getTsRecords().put(single.getTs(), existingValue);
                }
                return rolling;
            }));
        }
        return arguments;
    }

    private Map<String, ArgumentEntry> mapToArguments(CalculatedFieldCtx ctx, TransportProtos.AttributeScopeProto scope, List<TransportProtos.AttributeValueProto> attrDataList) {
        return this.mapToArguments(ctx.getMainEntityArguments(), scope, attrDataList);
    }

    private Map<String, ArgumentEntry> mapToArguments(CalculatedFieldCtx ctx, EntityId entityId, TransportProtos.AttributeScopeProto scope, List<TransportProtos.AttributeValueProto> attrDataList) {
        Map argNames = (Map)ctx.getLinkedEntityArguments().get(entityId);
        if (argNames.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.mapToArguments(argNames, scope, attrDataList);
    }

    private Map<String, ArgumentEntry> mapToArguments(Map<ReferencedEntityKey, Set<String>> args, TransportProtos.AttributeScopeProto scope, List<TransportProtos.AttributeValueProto> attrDataList) {
        HashMap<String, ArgumentEntry> arguments = new HashMap<String, ArgumentEntry>();
        for (TransportProtos.AttributeValueProto item : attrDataList) {
            ReferencedEntityKey key = new ReferencedEntityKey(item.getKey(), ArgumentType.ATTRIBUTE, AttributeScope.valueOf((String)scope.name()));
            Set<String> argNames = args.get(key);
            if (argNames == null) continue;
            argNames.forEach(argName -> arguments.put((String)argName, (ArgumentEntry)new SingleValueArgumentEntry(item)));
        }
        return arguments;
    }

    private Map<String, ArgumentEntry> mapToArgumentsWithDefaultValue(CalculatedFieldCtx ctx, EntityId entityId, TransportProtos.AttributeScopeProto scope, List<String> removedAttrKeys) {
        Map argNames = (Map)ctx.getLinkedEntityArguments().get(entityId);
        if (argNames.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.mapToArgumentsWithDefaultValue(argNames, ctx.getArguments(), scope, removedAttrKeys);
    }

    private Map<String, ArgumentEntry> mapToArgumentsWithDefaultValue(CalculatedFieldCtx ctx, TransportProtos.AttributeScopeProto scope, List<String> removedAttrKeys) {
        return this.mapToArgumentsWithDefaultValue(ctx.getMainEntityArguments(), ctx.getArguments(), scope, removedAttrKeys);
    }

    private Map<String, ArgumentEntry> mapToArgumentsWithDefaultValue(Map<ReferencedEntityKey, Set<String>> args, Map<String, Argument> configArguments, TransportProtos.AttributeScopeProto scope, List<String> removedAttrKeys) {
        HashMap<String, ArgumentEntry> arguments = new HashMap<String, ArgumentEntry>();
        for (String removedKey : removedAttrKeys) {
            ReferencedEntityKey key = new ReferencedEntityKey(removedKey, ArgumentType.ATTRIBUTE, AttributeScope.valueOf((String)scope.name()));
            Set<String> argNames = args.get(key);
            if (argNames == null) continue;
            argNames.forEach(argName -> {
                Argument argument = (Argument)configArguments.get(argName);
                String defaultValue = argument != null ? argument.getDefaultValue() : null;
                arguments.put((String)argName, (ArgumentEntry)(StringUtils.isNotEmpty((String)defaultValue) ? new SingleValueArgumentEntry(System.currentTimeMillis(), (BasicKvEntry)new StringDataEntry(removedKey, defaultValue), null) : new SingleValueArgumentEntry()));
            });
        }
        return arguments;
    }

    private Map<String, ArgumentEntry> mapToArgumentsWithFetchedValue(CalculatedFieldCtx ctx, List<String> removedTelemetryKeys) {
        Map<String, Argument> deletedArguments = ctx.getArguments().entrySet().stream().filter(entry -> removedTelemetryKeys.contains(((Argument)entry.getValue()).getRefEntityKey().getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map fetchedArgs = this.cfService.fetchArgsFromDb(this.tenantId, this.entityId, deletedArguments);
        fetchedArgs.values().forEach(arg -> arg.setForceResetPrevious(true));
        return fetchedArgs;
    }

    private static List<CalculatedFieldId> getCalculatedFieldIds(TransportProtos.CalculatedFieldTelemetryMsgProto proto) {
        LinkedList<CalculatedFieldId> cfIds = new LinkedList<CalculatedFieldId>();
        for (TransportProtos.CalculatedFieldIdProto cfId : proto.getPreviousCalculatedFieldsList()) {
            cfIds.add(new CalculatedFieldId(new UUID(cfId.getCalculatedFieldIdMSB(), cfId.getCalculatedFieldIdLSB())));
        }
        return cfIds;
    }

    private UUID toTbMsgId(TransportProtos.CalculatedFieldTelemetryMsgProto proto) {
        if (proto.getTbMsgIdMSB() != 0L && proto.getTbMsgIdLSB() != 0L) {
            return new UUID(proto.getTbMsgIdMSB(), proto.getTbMsgIdLSB());
        }
        return null;
    }

    private TbMsgType toTbMsgType(TransportProtos.CalculatedFieldTelemetryMsgProto proto) {
        if (!proto.getTbMsgType().isEmpty()) {
            return TbMsgType.valueOf((String)proto.getTbMsgType());
        }
        return null;
    }
}

