/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.ttl;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.ttl.AbstractCleanUpService;

@TbCoreComponent
@Service
public class TimeseriesCleanUpService
extends AbstractCleanUpService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TimeseriesCleanUpService.class);
    @Value(value="${sql.ttl.ts.ts_key_value_ttl}")
    protected long systemTtl;
    @Value(value="${sql.ttl.ts.enabled}")
    private boolean ttlTaskExecutionEnabled;
    private final TimeseriesService timeseriesService;

    public TimeseriesCleanUpService(PartitionService partitionService, TimeseriesService timeseriesService) {
        super(partitionService);
        this.timeseriesService = timeseriesService;
    }

    @Scheduled(initialDelayString="${sql.ttl.ts.execution_interval_ms}", fixedDelayString="${sql.ttl.ts.execution_interval_ms}")
    public void cleanUp() {
        if (this.ttlTaskExecutionEnabled && this.isSystemTenantPartitionMine()) {
            this.timeseriesService.cleanup(this.systemTtl);
        }
    }
}

