/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.importing.csv;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.FutureCallback;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.rule.engine.api.AttributesSaveRequest;
import org.thingsboard.rule.engine.api.TimeseriesSaveRequest;
import org.thingsboard.server.common.adaptor.JsonConverter;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasAdditionalInfo;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.HasId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.DataType;
import org.thingsboard.server.common.data.sync.ie.importing.csv.BulkImportColumnType;
import org.thingsboard.server.common.data.sync.ie.importing.csv.BulkImportRequest;
import org.thingsboard.server.common.data.sync.ie.importing.csv.BulkImportResult;
import org.thingsboard.server.common.data.tenant.profile.DefaultTenantProfileConfiguration;
import org.thingsboard.server.common.data.util.TypeCastUtil;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.tenant.TbTenantProfileCache;
import org.thingsboard.server.service.action.EntityActionService;
import org.thingsboard.server.service.security.AccessValidator;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.AccessControlService;
import org.thingsboard.server.service.security.permission.Operation;
import org.thingsboard.server.service.security.permission.Resource;
import org.thingsboard.server.service.sync.ie.importing.csv.ImportedEntityInfo;
import org.thingsboard.server.service.telemetry.TelemetrySubscriptionService;
import org.thingsboard.server.utils.CsvUtils;

public abstract class AbstractBulkImportService<E extends HasId<? extends EntityId> & HasTenantId> {
    @Autowired
    private TelemetrySubscriptionService tsSubscriptionService;
    @Autowired
    private TbTenantProfileCache tenantProfileCache;
    @Autowired
    private AccessControlService accessControlService;
    @Autowired
    private AccessValidator accessValidator;
    @Autowired
    private EntityActionService entityActionService;
    private ExecutorService executor;

    @PostConstruct
    private void initExecutor() {
        this.executor = ThingsBoardExecutors.newLimitedTasksExecutor((int)Runtime.getRuntime().availableProcessors(), (int)150000, (String)"bulk-import");
    }

    public final BulkImportResult<E> processBulkImport(BulkImportRequest request, SecurityUser user) throws Exception {
        List<EntityData> entitiesData = this.parseData(request);
        BulkImportResult result = new BulkImportResult();
        CountDownLatch completionLatch = new CountDownLatch(entitiesData.size());
        SecurityContext securityContext = SecurityContextHolder.getContext();
        entitiesData.forEach(entityData -> DonAsynchron.submit(() -> {
            SecurityContextHolder.setContext((SecurityContext)securityContext);
            ImportedEntityInfo<E> importedEntityInfo = this.saveEntity(entityData.getFields(), user);
            HasId entity = (HasId)importedEntityInfo.getEntity();
            if (request.getMapping().getUpdate().booleanValue() || !importedEntityInfo.isUpdated()) {
                this.saveKvs(user, entity, entityData.getKvs());
            }
            return importedEntityInfo;
        }, importedEntityInfo -> {
            if (importedEntityInfo.isUpdated()) {
                result.getUpdated().incrementAndGet();
            } else {
                result.getCreated().incrementAndGet();
            }
            completionLatch.countDown();
        }, throwable -> {
            result.getErrors().incrementAndGet();
            result.getErrorsList().add(String.format("Line %d: %s", entityData.getLineNumber(), ExceptionUtils.getRootCauseMessage((Throwable)throwable)));
            completionLatch.countDown();
        }, (Executor)this.executor));
        completionLatch.await();
        return result;
    }

    private ImportedEntityInfo<E> saveEntity(Map<BulkImportColumnType, String> fields, SecurityUser user) {
        ImportedEntityInfo<Object> importedEntityInfo = new ImportedEntityInfo<Object>();
        E entity = this.findOrCreateEntity(user.getTenantId(), fields.get(BulkImportColumnType.NAME));
        if (entity.getId() != null) {
            importedEntityInfo.setOldEntity((HasId)entity.getClass().getConstructor(entity.getClass()).newInstance(entity));
            importedEntityInfo.setUpdated(true);
            if (entity instanceof HasVersion) {
                HasVersion versionedEntity = (HasVersion)entity;
                versionedEntity.setVersion(null);
            }
        } else {
            this.setOwners(entity, user);
        }
        this.setEntityFields(entity, fields);
        this.accessControlService.checkPermission(user, Resource.of(this.getEntityType()), Operation.WRITE, (EntityId)entity.getId(), entity);
        E savedEntity = this.saveEntity(user, entity, fields);
        importedEntityInfo.setEntity(savedEntity);
        return importedEntityInfo;
    }

    protected abstract E findOrCreateEntity(TenantId var1, String var2);

    protected abstract void setOwners(E var1, SecurityUser var2);

    protected abstract void setEntityFields(E var1, Map<BulkImportColumnType, String> var2);

    protected abstract E saveEntity(SecurityUser var1, E var2, Map<BulkImportColumnType, String> var3);

    protected abstract EntityType getEntityType();

    protected ObjectNode getOrCreateAdditionalInfoObj(HasAdditionalInfo entity) {
        return entity.getAdditionalInfo() == null || entity.getAdditionalInfo().isNull() ? JacksonUtil.newObjectNode() : (ObjectNode)entity.getAdditionalInfo();
    }

    private void saveKvs(SecurityUser user, E entity, Map<BulkImportRequest.ColumnMapping, ParsedValue> data) {
        Arrays.stream(BulkImportColumnType.values()).filter(BulkImportColumnType::isKv).map(kvType -> {
            JsonObject kvs = new JsonObject();
            data.entrySet().stream().filter(dataEntry -> ((BulkImportRequest.ColumnMapping)dataEntry.getKey()).getType() == kvType && StringUtils.isNotEmpty((String)((BulkImportRequest.ColumnMapping)dataEntry.getKey()).getKey())).forEach(dataEntry -> kvs.add(((BulkImportRequest.ColumnMapping)dataEntry.getKey()).getKey(), (JsonElement)((ParsedValue)dataEntry.getValue()).toJsonPrimitive()));
            return Map.entry(kvType, kvs);
        }).filter(kvsEntry -> ((JsonObject)kvsEntry.getValue()).entrySet().size() > 0).forEach(kvsEntry -> {
            BulkImportColumnType kvType = (BulkImportColumnType)kvsEntry.getKey();
            if (kvType == BulkImportColumnType.SHARED_ATTRIBUTE || kvType == BulkImportColumnType.SERVER_ATTRIBUTE) {
                this.saveAttributes(user, entity, (Map.Entry<BulkImportColumnType, JsonObject>)kvsEntry, kvType);
            } else {
                this.saveTelemetry(user, entity, (Map.Entry<BulkImportColumnType, JsonObject>)kvsEntry);
            }
        });
    }

    private void saveTelemetry(final SecurityUser user, E entity, Map.Entry<BulkImportColumnType, JsonObject> kvsEntry) {
        final List timeseries = JsonConverter.convertToTelemetry((JsonElement)((JsonElement)kvsEntry.getValue()), (long)System.currentTimeMillis()).entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(kvEntry -> new BasicTsKvEntry(((Long)entry.getKey()).longValue(), kvEntry))).collect(Collectors.toList());
        this.accessValidator.validateEntityAndCallback(user, Operation.WRITE_TELEMETRY, (EntityId)entity.getId(), (result, tenantId, entityId) -> {
            TenantProfile tenantProfile = this.tenantProfileCache.get(tenantId);
            long tenantTtl = TimeUnit.DAYS.toSeconds(((DefaultTenantProfileConfiguration)tenantProfile.getProfileData().getConfiguration()).getDefaultStorageTtlDays());
            this.tsSubscriptionService.saveTimeseries(TimeseriesSaveRequest.builder().tenantId(tenantId).customerId(user.getCustomerId()).entityId(entityId).entries(timeseries).ttl(tenantTtl).callback((FutureCallback)new FutureCallback<Void>(){

                public void onSuccess(@Nullable Void tmp) {
                    AbstractBulkImportService.this.entityActionService.logEntityAction(user, (UUIDBased)entityId, null, null, ActionType.TIMESERIES_UPDATED, null, timeseries);
                }

                public void onFailure(Throwable t) {
                    AbstractBulkImportService.this.entityActionService.logEntityAction(user, (UUIDBased)entityId, null, null, ActionType.TIMESERIES_UPDATED, BaseController.toException(t), timeseries);
                    throw new RuntimeException(t);
                }
            }).build());
        });
    }

    private void saveAttributes(final SecurityUser user, E entity, Map.Entry<BulkImportColumnType, JsonObject> kvsEntry, BulkImportColumnType kvType) {
        final String scope = kvType.getKey();
        final List attributes = JsonConverter.convertToAttributes((JsonElement)((JsonElement)kvsEntry.getValue()));
        this.accessValidator.validateEntityAndCallback(user, Operation.WRITE_ATTRIBUTES, (EntityId)entity.getId(), (result, tenantId, entityId) -> this.tsSubscriptionService.saveAttributes(AttributesSaveRequest.builder().tenantId(tenantId).entityId(entityId).scope(AttributeScope.valueOf((String)scope)).entries(attributes).callback((FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void unused) {
                AbstractBulkImportService.this.entityActionService.logEntityAction(user, (UUIDBased)entityId, null, (CustomerId)null, ActionType.ATTRIBUTES_UPDATED, (Exception)null, AttributeScope.valueOf((String)scope), attributes);
            }

            public void onFailure(Throwable throwable) {
                AbstractBulkImportService.this.entityActionService.logEntityAction(user, (UUIDBased)entityId, null, (CustomerId)null, ActionType.ATTRIBUTES_UPDATED, BaseController.toException(throwable), AttributeScope.valueOf((String)scope), attributes);
                throw new RuntimeException(throwable);
            }
        }).build()));
    }

    private List<EntityData> parseData(BulkImportRequest request) throws Exception {
        List<List<String>> records = CsvUtils.parseCsv(request.getFile(), request.getMapping().getDelimiter());
        AtomicInteger linesCounter = new AtomicInteger(0);
        if (request.getMapping().getHeader().booleanValue()) {
            records.remove(0);
            linesCounter.incrementAndGet();
        }
        List columnsMappings = request.getMapping().getColumns();
        return records.stream().map(record -> {
            EntityData entityData = new EntityData();
            Stream.iterate(0, i -> i < record.size(), i -> i + 1).map(i -> Map.entry((BulkImportRequest.ColumnMapping)columnsMappings.get((int)i), (String)record.get((int)i))).filter(entry -> StringUtils.isNotEmpty((String)((String)entry.getValue()))).forEach(entry -> {
                if (!((BulkImportRequest.ColumnMapping)entry.getKey()).getType().isKv()) {
                    entityData.getFields().put(((BulkImportRequest.ColumnMapping)entry.getKey()).getType(), (String)entry.getValue());
                } else {
                    Pair castResult = TypeCastUtil.castValue((String)((String)entry.getValue()));
                    entityData.getKvs().put((BulkImportRequest.ColumnMapping)entry.getKey(), new ParsedValue(castResult.getValue(), (DataType)castResult.getKey()));
                }
            });
            entityData.setLineNumber(linesCounter.incrementAndGet());
            return entityData;
        }).collect(Collectors.toList());
    }

    @PreDestroy
    private void shutdownExecutor() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    protected static class EntityData {
        private final Map<BulkImportColumnType, String> fields = new LinkedHashMap<BulkImportColumnType, String>();
        private final Map<BulkImportRequest.ColumnMapping, ParsedValue> kvs = new LinkedHashMap<BulkImportRequest.ColumnMapping, ParsedValue>();
        private int lineNumber;

        @Generated
        public EntityData() {
        }

        @Generated
        public Map<BulkImportColumnType, String> getFields() {
            return this.fields;
        }

        @Generated
        public Map<BulkImportRequest.ColumnMapping, ParsedValue> getKvs() {
            return this.kvs;
        }

        @Generated
        public int getLineNumber() {
            return this.lineNumber;
        }

        @Generated
        public void setLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EntityData)) {
                return false;
            }
            EntityData other = (EntityData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLineNumber() != other.getLineNumber()) {
                return false;
            }
            Map<BulkImportColumnType, String> this$fields = this.getFields();
            Map<BulkImportColumnType, String> other$fields = other.getFields();
            if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
                return false;
            }
            Map<BulkImportRequest.ColumnMapping, ParsedValue> this$kvs = this.getKvs();
            Map<BulkImportRequest.ColumnMapping, ParsedValue> other$kvs = other.getKvs();
            return !(this$kvs == null ? other$kvs != null : !((Object)this$kvs).equals(other$kvs));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EntityData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLineNumber();
            Map<BulkImportColumnType, String> $fields = this.getFields();
            result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
            Map<BulkImportRequest.ColumnMapping, ParsedValue> $kvs = this.getKvs();
            result = result * 59 + ($kvs == null ? 43 : ((Object)$kvs).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AbstractBulkImportService.EntityData(fields=" + String.valueOf(this.getFields()) + ", kvs=" + String.valueOf(this.getKvs()) + ", lineNumber=" + this.getLineNumber() + ")";
        }
    }

    protected static class ParsedValue {
        private final Object value;
        private final DataType dataType;

        public JsonPrimitive toJsonPrimitive() {
            return switch (this.dataType) {
                case DataType.STRING -> new JsonPrimitive((String)this.value);
                case DataType.LONG -> new JsonPrimitive((Number)((Long)this.value));
                case DataType.DOUBLE -> new JsonPrimitive((Number)((Double)this.value));
                case DataType.BOOLEAN -> new JsonPrimitive((Boolean)this.value);
                default -> null;
            };
        }

        public String stringValue() {
            return this.value.toString();
        }

        @ConstructorProperties(value={"value", "dataType"})
        @Generated
        public ParsedValue(Object value, DataType dataType) {
            this.value = value;
            this.dataType = dataType;
        }

        @Generated
        public Object getValue() {
            return this.value;
        }

        @Generated
        public DataType getDataType() {
            return this.dataType;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParsedValue)) {
                return false;
            }
            ParsedValue other = (ParsedValue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            DataType this$dataType = this.getDataType();
            DataType other$dataType = other.getDataType();
            return !(this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParsedValue;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            DataType $dataType = this.getDataType();
            result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AbstractBulkImportService.ParsedValue(value=" + String.valueOf(this.getValue()) + ", dataType=" + String.valueOf(this.getDataType()) + ")";
        }
    }
}

