/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.exporting.impl;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.NotificationRuleId;
import org.thingsboard.server.common.data.id.NotificationTargetId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.notification.rule.DefaultNotificationRuleRecipientsConfig;
import org.thingsboard.server.common.data.notification.rule.EscalatedNotificationRuleRecipientsConfig;
import org.thingsboard.server.common.data.notification.rule.NotificationRule;
import org.thingsboard.server.common.data.notification.rule.NotificationRuleRecipientsConfig;
import org.thingsboard.server.common.data.notification.rule.trigger.config.DeviceActivityNotificationRuleTriggerConfig;
import org.thingsboard.server.common.data.notification.rule.trigger.config.EdgeCommunicationFailureNotificationRuleTriggerConfig;
import org.thingsboard.server.common.data.notification.rule.trigger.config.EdgeConnectionNotificationRuleTriggerConfig;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerConfig;
import org.thingsboard.server.common.data.notification.rule.trigger.config.RuleEngineComponentLifecycleEventNotificationRuleTriggerConfig;
import org.thingsboard.server.common.data.sync.ie.EntityExportData;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.sync.ie.exporting.impl.BaseEntityExportService;
import org.thingsboard.server.service.sync.vc.data.EntitiesExportCtx;

@Service
@TbCoreComponent
public class NotificationRuleExportService<I extends EntityId, E extends ExportableEntity<I>, D extends EntityExportData<E>>
extends BaseEntityExportService<NotificationRuleId, NotificationRule, EntityExportData<NotificationRule>> {
    @Override
    protected void setRelatedEntities(EntitiesExportCtx<?> ctx, NotificationRule notificationRule, EntityExportData<NotificationRule> exportData) {
        notificationRule.setTemplateId(this.getExternalIdOrElseInternal(ctx, notificationRule.getTemplateId()));
        NotificationRuleTriggerConfig ruleTriggerConfig = notificationRule.getTriggerConfig();
        switch (ruleTriggerConfig.getTriggerType()) {
            case DEVICE_ACTIVITY: {
                Set deviceProfiles;
                DeviceActivityNotificationRuleTriggerConfig triggerConfig = (DeviceActivityNotificationRuleTriggerConfig)ruleTriggerConfig;
                Set devices = triggerConfig.getDevices();
                if (devices != null) {
                    triggerConfig.setDevices(this.toExternalIds(devices, DeviceId::new, ctx).collect(Collectors.toSet()));
                }
                if ((deviceProfiles = triggerConfig.getDeviceProfiles()) == null) break;
                triggerConfig.setDeviceProfiles(this.toExternalIds(deviceProfiles, DeviceProfileId::new, ctx).collect(Collectors.toSet()));
                break;
            }
            case RULE_ENGINE_COMPONENT_LIFECYCLE_EVENT: {
                DeviceActivityNotificationRuleTriggerConfig triggerConfig = (RuleEngineComponentLifecycleEventNotificationRuleTriggerConfig)ruleTriggerConfig;
                Set ruleChains = triggerConfig.getRuleChains();
                if (ruleChains == null) break;
                triggerConfig.setRuleChains(this.toExternalIds(ruleChains, RuleChainId::new, ctx).collect(Collectors.toSet()));
                break;
            }
            case EDGE_CONNECTION: {
                DeviceActivityNotificationRuleTriggerConfig triggerConfig = (EdgeConnectionNotificationRuleTriggerConfig)ruleTriggerConfig;
                triggerConfig.setEdges(null);
                break;
            }
            case EDGE_COMMUNICATION_FAILURE: {
                DeviceActivityNotificationRuleTriggerConfig triggerConfig = (EdgeCommunicationFailureNotificationRuleTriggerConfig)ruleTriggerConfig;
                triggerConfig.setEdges(null);
                break;
            }
        }
        NotificationRuleRecipientsConfig ruleRecipientsConfig = notificationRule.getRecipientsConfig();
        switch (ruleTriggerConfig.getTriggerType()) {
            case ALARM: {
                EscalatedNotificationRuleRecipientsConfig recipientsConfig = (EscalatedNotificationRuleRecipientsConfig)ruleRecipientsConfig;
                LinkedHashMap<Integer, List> escalationTable = new LinkedHashMap<Integer, List>(recipientsConfig.getEscalationTable());
                escalationTable.replaceAll((delay, targets) -> this.toExternalIds((Collection<UUID>)targets, NotificationTargetId::new, ctx).collect(Collectors.toList()));
                recipientsConfig.setEscalationTable(escalationTable);
                break;
            }
            default: {
                EscalatedNotificationRuleRecipientsConfig recipientsConfig = (DefaultNotificationRuleRecipientsConfig)ruleRecipientsConfig;
                List targets2 = recipientsConfig.getTargets();
                targets2 = this.toExternalIds(targets2, NotificationTargetId::new, ctx).collect(Collectors.toList());
                recipientsConfig.setTargets(targets2);
                break;
            }
        }
    }

    @Override
    public Set<EntityType> getSupportedEntityTypes() {
        return Set.of(EntityType.NOTIFICATION_RULE);
    }
}

