/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.subscription;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.server.queue.util.TbCoreComponent;

@TbCoreComponent
@Service
public class SubscriptionSchedulerComponent {
    private ScheduledExecutorService scheduler;

    @PostConstruct
    public void initExecutor() {
        this.scheduler = ThingsBoardExecutors.newSingleThreadScheduledExecutor((String)"subscription-scheduler");
    }

    @PreDestroy
    public void shutdownExecutor() {
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.scheduler.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    @Generated
    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }
}

