/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.permission;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.Operation;

public interface PermissionChecker<I extends EntityId, T extends HasTenantId> {
    public static final PermissionChecker denyAllPermissionChecker = new PermissionChecker(){};
    public static final PermissionChecker allowAllPermissionChecker = new PermissionChecker<EntityId, HasTenantId>(){

        @Override
        public boolean hasPermission(SecurityUser user, Operation operation) {
            return true;
        }

        @Override
        public boolean hasPermission(SecurityUser user, Operation operation, EntityId entityId, HasTenantId entity) {
            return true;
        }
    };

    default public boolean hasPermission(SecurityUser user, Operation operation) {
        return false;
    }

    default public boolean hasPermission(SecurityUser user, Operation operation, I entityId, T entity) {
        return false;
    }

    public static class GenericPermissionChecker<I extends EntityId, T extends HasTenantId>
    implements PermissionChecker<I, T> {
        private final Set<Operation> allowedOperations;

        public GenericPermissionChecker(Operation ... operations) {
            this.allowedOperations = new HashSet<Operation>(Arrays.asList(operations));
        }

        @Override
        public boolean hasPermission(SecurityUser user, Operation operation) {
            return this.allowedOperations.contains((Object)Operation.ALL) || this.allowedOperations.contains((Object)operation);
        }

        @Override
        public boolean hasPermission(SecurityUser user, Operation operation, I entityId, T entity) {
            return this.allowedOperations.contains((Object)Operation.ALL) || this.allowedOperations.contains((Object)operation);
        }
    }
}

