/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth.oauth2;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.oauth2.MapperType;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.auth.oauth2.OAuth2ClientMapper;

@Component
@TbCoreComponent
public class OAuth2ClientMapperProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAuth2ClientMapperProvider.class);
    @Autowired
    @Qualifier(value="basicOAuth2ClientMapper")
    private OAuth2ClientMapper basicOAuth2ClientMapper;
    @Autowired
    @Qualifier(value="customOAuth2ClientMapper")
    private OAuth2ClientMapper customOAuth2ClientMapper;
    @Autowired
    @Qualifier(value="githubOAuth2ClientMapper")
    private OAuth2ClientMapper githubOAuth2ClientMapper;
    @Autowired
    @Qualifier(value="appleOAuth2ClientMapper")
    private OAuth2ClientMapper appleOAuth2ClientMapper;

    public OAuth2ClientMapper getOAuth2ClientMapperByType(MapperType oauth2MapperType) {
        switch (oauth2MapperType) {
            case CUSTOM: {
                return this.customOAuth2ClientMapper;
            }
            case BASIC: {
                return this.basicOAuth2ClientMapper;
            }
            case GITHUB: {
                return this.githubOAuth2ClientMapper;
            }
            case APPLE: {
                return this.appleOAuth2ClientMapper;
            }
        }
        throw new RuntimeException("OAuth2ClientRegistrationMapper with type " + String.valueOf(oauth2MapperType) + " is not supported!");
    }
}

