/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth.oauth2;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;
import org.thingsboard.server.common.data.oauth2.OAuth2Client;
import org.thingsboard.server.common.data.oauth2.OAuth2MapperConfig;
import org.thingsboard.server.dao.oauth2.OAuth2Configuration;
import org.thingsboard.server.dao.oauth2.OAuth2User;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.auth.oauth2.AbstractOAuth2ClientMapper;
import org.thingsboard.server.service.security.auth.oauth2.BasicMapperUtils;
import org.thingsboard.server.service.security.auth.oauth2.OAuth2ClientMapper;
import org.thingsboard.server.service.security.model.SecurityUser;

@Service(value="githubOAuth2ClientMapper")
@TbCoreComponent
public class GithubOAuth2ClientMapper
extends AbstractOAuth2ClientMapper
implements OAuth2ClientMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GithubOAuth2ClientMapper.class);
    private static final String EMAIL_URL_KEY = "emailUrl";
    private static final String AUTHORIZATION = "Authorization";
    private RestTemplateBuilder restTemplateBuilder = new RestTemplateBuilder(new RestTemplateCustomizer[0]);
    @Autowired
    private OAuth2Configuration oAuth2Configuration;

    @Override
    public SecurityUser getOrCreateUserByClientPrincipal(HttpServletRequest request, OAuth2AuthenticationToken token, String providerAccessToken, OAuth2Client oAuth2Client) {
        OAuth2MapperConfig config = oAuth2Client.getMapperConfig();
        Map githubMapperConfig = this.oAuth2Configuration.getGithubMapper();
        String email = this.getEmail((String)githubMapperConfig.get(EMAIL_URL_KEY), providerAccessToken);
        Map attributes = token.getPrincipal().getAttributes();
        OAuth2User oAuth2User = BasicMapperUtils.getOAuth2User(email, attributes, config);
        return this.getOrCreateSecurityUserFromOAuth2User(oAuth2User, oAuth2Client);
    }

    private synchronized String getEmail(String emailUrl, String oauth2Token) {
        GithubEmailsResponse githubEmailsResponse;
        this.restTemplateBuilder = this.restTemplateBuilder.defaultHeader(AUTHORIZATION, new String[]{"token " + oauth2Token});
        RestTemplate restTemplate = this.restTemplateBuilder.build();
        try {
            githubEmailsResponse = (GithubEmailsResponse)restTemplate.getForEntity(emailUrl, GithubEmailsResponse.class, new Object[0]).getBody();
            if (githubEmailsResponse == null) {
                throw new RuntimeException("Empty Github response!");
            }
        }
        catch (Exception e) {
            log.error("There was an error during connection to Github API", (Throwable)e);
            throw new RuntimeException("Unable to login. Please contact your Administrator!");
        }
        Optional<String> emailOpt = githubEmailsResponse.stream().filter(GithubEmailResponse::isPrimary).map(GithubEmailResponse::getEmail).findAny();
        if (emailOpt.isPresent()) {
            return emailOpt.get();
        }
        log.error("Could not find primary email from {}.", (Object)githubEmailsResponse);
        throw new RuntimeException("Unable to login. Please contact your Administrator!");
    }

    private static class GithubEmailsResponse
    extends ArrayList<GithubEmailResponse> {
        private GithubEmailsResponse() {
        }
    }

    private static class GithubEmailResponse {
        private String email;
        private boolean verified;
        private boolean primary;
        private String visibility;

        @Generated
        public GithubEmailResponse() {
        }

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public boolean isVerified() {
            return this.verified;
        }

        @Generated
        public boolean isPrimary() {
            return this.primary;
        }

        @Generated
        public String getVisibility() {
            return this.visibility;
        }

        @Generated
        public void setEmail(String email) {
            this.email = email;
        }

        @Generated
        public void setVerified(boolean verified) {
            this.verified = verified;
        }

        @Generated
        public void setPrimary(boolean primary) {
            this.primary = primary;
        }

        @Generated
        public void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GithubEmailResponse)) {
                return false;
            }
            GithubEmailResponse other = (GithubEmailResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isVerified() != other.isVerified()) {
                return false;
            }
            if (this.isPrimary() != other.isPrimary()) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                return false;
            }
            String this$visibility = this.getVisibility();
            String other$visibility = other.getVisibility();
            return !(this$visibility == null ? other$visibility != null : !this$visibility.equals(other$visibility));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof GithubEmailResponse;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isVerified() ? 79 : 97);
            result = result * 59 + (this.isPrimary() ? 79 : 97);
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            String $visibility = this.getVisibility();
            result = result * 59 + ($visibility == null ? 43 : $visibility.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GithubOAuth2ClientMapper.GithubEmailResponse(email=" + this.getEmail() + ", verified=" + this.isVerified() + ", primary=" + this.isPrimary() + ", visibility=" + this.getVisibility() + ")";
        }
    }
}

