/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth.oauth2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.DashboardInfo;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.IdBased;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.oauth2.OAuth2Client;
import org.thingsboard.server.common.data.oauth2.OAuth2MapperConfig;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.common.data.security.UserCredentials;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.dashboard.DashboardService;
import org.thingsboard.server.dao.oauth2.OAuth2User;
import org.thingsboard.server.dao.tenant.TbTenantProfileCache;
import org.thingsboard.server.dao.tenant.TenantService;
import org.thingsboard.server.dao.user.UserService;
import org.thingsboard.server.service.entitiy.tenant.TbTenantService;
import org.thingsboard.server.service.entitiy.user.TbUserService;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.model.UserPrincipal;

public abstract class AbstractOAuth2ClientMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractOAuth2ClientMapper.class);
    private static final int DASHBOARDS_REQUEST_LIMIT = 10;
    @Autowired
    private UserService userService;
    @Autowired
    private BCryptPasswordEncoder passwordEncoder;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private TbTenantService tbTenantService;
    @Autowired
    private CustomerService customerService;
    @Autowired
    private DashboardService dashboardService;
    @Autowired
    private TbUserService tbUserService;
    @Autowired
    protected TbTenantProfileCache tenantProfileCache;
    @Value(value="${edges.enabled}")
    private boolean edgesEnabled;
    private final Lock userCreationLock = new ReentrantLock();

    protected SecurityUser getOrCreateSecurityUserFromOAuth2User(OAuth2User oauth2User, OAuth2Client oAuth2Client) {
        OAuth2MapperConfig config = oAuth2Client.getMapperConfig();
        UserPrincipal principal = new UserPrincipal(UserPrincipal.Type.USER_NAME, oauth2User.getEmail());
        User user = this.userService.findUserByEmail(TenantId.SYS_TENANT_ID, oauth2User.getEmail());
        if (user == null && !config.isAllowUserCreation()) {
            throw new UsernameNotFoundException("User not found: " + oauth2User.getEmail());
        }
        if (user == null) {
            this.userCreationLock.lock();
            try {
                user = this.userService.findUserByEmail(TenantId.SYS_TENANT_ID, oauth2User.getEmail());
                if (user == null) {
                    user = new User();
                    if (oauth2User.getCustomerId() == null && StringUtils.isEmpty((String)oauth2User.getCustomerName())) {
                        user.setAuthority(Authority.TENANT_ADMIN);
                    } else {
                        user.setAuthority(Authority.CUSTOMER_USER);
                    }
                    TenantId tenantId = oauth2User.getTenantId() != null ? oauth2User.getTenantId() : this.getTenantId(oauth2User.getTenantName());
                    user.setTenantId(tenantId);
                    CustomerId customerId = oauth2User.getCustomerId() != null ? oauth2User.getCustomerId() : this.getCustomerId(user.getTenantId(), oauth2User.getCustomerName());
                    user.setCustomerId(customerId);
                    user.setEmail(oauth2User.getEmail());
                    user.setFirstName(oauth2User.getFirstName());
                    user.setLastName(oauth2User.getLastName());
                    ObjectNode additionalInfo = JacksonUtil.newObjectNode();
                    if (!StringUtils.isEmpty((String)oauth2User.getDefaultDashboardName())) {
                        Optional<DashboardId> dashboardIdOpt;
                        Optional<DashboardId> optional = dashboardIdOpt = user.getAuthority() == Authority.TENANT_ADMIN ? this.getDashboardId(tenantId, oauth2User.getDefaultDashboardName()) : this.getDashboardId(tenantId, customerId, oauth2User.getDefaultDashboardName());
                        if (dashboardIdOpt.isPresent()) {
                            additionalInfo.put("defaultDashboardFullscreen", oauth2User.isAlwaysFullScreen());
                            additionalInfo.put("defaultDashboardId", dashboardIdOpt.get().getId().toString());
                        }
                    }
                    if (oAuth2Client.getAdditionalInfo() != null && oAuth2Client.getAdditionalInfo().has("providerName")) {
                        additionalInfo.put("authProviderName", oAuth2Client.getAdditionalInfo().get("providerName").asText());
                    }
                    user.setAdditionalInfo((JsonNode)additionalInfo);
                    user = this.tbUserService.save(tenantId, customerId, user, false, null, null);
                    if (config.isActivateUser()) {
                        UserCredentials userCredentials = this.userService.findUserCredentialsByUserId(user.getTenantId(), user.getId());
                        this.userService.activateUserCredentials(user.getTenantId(), userCredentials.getActivateToken(), this.passwordEncoder.encode((CharSequence)""));
                    }
                }
            }
            catch (Exception e) {
                log.error("Can't get or create security user from oauth2 user", (Throwable)e);
                throw new RuntimeException("Can't get or create security user from oauth2 user", e);
            }
            finally {
                this.userCreationLock.unlock();
            }
        }
        try {
            SecurityUser securityUser = new SecurityUser(user, true, principal);
            return (SecurityUser)((Object)new UsernamePasswordAuthenticationToken((Object)securityUser, null, securityUser.getAuthorities()).getPrincipal());
        }
        catch (Exception e) {
            log.error("Can't get or create security user from oauth2 user", (Throwable)e);
            throw new RuntimeException("Can't get or create security user from oauth2 user", e);
        }
    }

    private TenantId getTenantId(String name) throws Exception {
        Tenant tenant = this.tenantService.findTenantByName(name);
        if (tenant != null) {
            return tenant.getId();
        }
        tenant = new Tenant();
        tenant.setTitle(name);
        tenant = this.tbTenantService.save(tenant);
        return tenant.getId();
    }

    private CustomerId getCustomerId(TenantId tenantId, String customerName) {
        if (StringUtils.isEmpty((String)customerName)) {
            return null;
        }
        Optional customerOpt = this.customerService.findCustomerByTenantIdAndTitle(tenantId, customerName);
        if (customerOpt.isPresent()) {
            return ((Customer)customerOpt.get()).getId();
        }
        Customer customer = new Customer();
        customer.setTenantId(tenantId);
        customer.setTitle(customerName);
        return this.customerService.saveCustomer(customer).getId();
    }

    private Optional<DashboardId> getDashboardId(TenantId tenantId, String dashboardName) {
        return Optional.ofNullable(this.dashboardService.findFirstDashboardInfoByTenantIdAndName(tenantId, dashboardName)).map(IdBased::getId);
    }

    private Optional<DashboardId> getDashboardId(TenantId tenantId, CustomerId customerId, String dashboardName) {
        PageData dashboardsPage;
        PageLink pageLink = null;
        do {
            Optional<DashboardInfo> dashboardInfoOpt;
            if (!(dashboardInfoOpt = (dashboardsPage = this.dashboardService.findDashboardsByTenantIdAndCustomerId(tenantId, customerId, pageLink = pageLink == null ? new PageLink(10) : pageLink.nextPageLink())).getData().stream().filter(dashboardInfo -> dashboardName.equals(dashboardInfo.getName())).findAny()).isPresent()) continue;
            return dashboardInfoOpt.map(DashboardInfo::getId);
        } while (dashboardsPage.hasNext());
        return Optional.empty();
    }

    @Generated
    public boolean isEdgesEnabled() {
        return this.edgesEnabled;
    }
}

