/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth.jwt;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;
import org.thingsboard.server.service.security.auth.JwtAuthenticationToken;
import org.thingsboard.server.service.security.auth.TokenOutdatingService;
import org.thingsboard.server.service.security.exception.JwtExpiredTokenException;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.model.token.JwtTokenFactory;
import org.thingsboard.server.service.security.model.token.RawAccessJwtToken;

@Component
public class JwtAuthenticationProvider
implements AuthenticationProvider {
    private final JwtTokenFactory tokenFactory;
    private final TokenOutdatingService tokenOutdatingService;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        RawAccessJwtToken rawAccessToken = (RawAccessJwtToken)authentication.getCredentials();
        SecurityUser securityUser = this.authenticate(rawAccessToken.getToken());
        return new JwtAuthenticationToken(securityUser);
    }

    public SecurityUser authenticate(String accessToken) throws AuthenticationException {
        if (StringUtils.isEmpty((CharSequence)accessToken)) {
            throw new BadCredentialsException("Token is invalid");
        }
        SecurityUser securityUser = this.tokenFactory.parseAccessJwtToken(accessToken);
        if (this.tokenOutdatingService.isOutdated(accessToken, securityUser.getId())) {
            throw new JwtExpiredTokenException("Token is outdated");
        }
        return securityUser;
    }

    public boolean supports(Class<?> authentication) {
        return JwtAuthenticationToken.class.isAssignableFrom(authentication);
    }

    @ConstructorProperties(value={"tokenFactory", "tokenOutdatingService"})
    @Generated
    public JwtAuthenticationProvider(JwtTokenFactory tokenFactory, TokenOutdatingService tokenOutdatingService) {
        this.tokenFactory = tokenFactory;
        this.tokenOutdatingService = tokenOutdatingService;
    }
}

