/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security;

import com.google.common.util.concurrent.FutureCallback;
import org.thingsboard.server.exception.AccessDeniedException;
import org.thingsboard.server.exception.EntityNotFoundException;
import org.thingsboard.server.exception.InternalErrorException;
import org.thingsboard.server.exception.UnauthorizedException;
import org.thingsboard.server.service.security.ValidationResult;
import org.thingsboard.server.service.security.ValidationResultCode;

public class ValidationCallback<T>
implements FutureCallback<ValidationResult> {
    private final T response;
    private final FutureCallback<T> action;

    public ValidationCallback(T response, FutureCallback<T> action) {
        this.response = response;
        this.action = action;
    }

    public void onSuccess(ValidationResult result) {
        if (result.getResultCode() == ValidationResultCode.OK) {
            this.action.onSuccess(this.response);
        } else {
            this.onFailure(ValidationCallback.getException(result));
        }
    }

    public void onFailure(Throwable e) {
        this.action.onFailure(e);
    }

    public static Exception getException(ValidationResult result) {
        ValidationResultCode resultCode = result.getResultCode();
        return switch (resultCode) {
            case ValidationResultCode.ENTITY_NOT_FOUND -> new EntityNotFoundException(result.getMessage());
            case ValidationResultCode.UNAUTHORIZED -> new UnauthorizedException(result.getMessage());
            case ValidationResultCode.ACCESS_DENIED -> new AccessDeniedException(result.getMessage());
            case ValidationResultCode.INTERNAL_ERROR -> new InternalErrorException(result.getMessage());
            default -> new UnauthorizedException("Permission denied.");
        };
    }
}

