/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.queue.processing;

import com.google.protobuf.GeneratedMessageV3;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.service.queue.processing.IdMsgPair;
import org.thingsboard.server.service.queue.processing.TbRuleEngineSubmitStrategy;

public abstract class AbstractTbRuleEngineSubmitStrategy
implements TbRuleEngineSubmitStrategy {
    protected final String queueName;
    protected List<IdMsgPair<TransportProtos.ToRuleEngineMsg>> orderedMsgList;
    private volatile boolean stopped;

    public AbstractTbRuleEngineSubmitStrategy(String queueName) {
        this.queueName = queueName;
    }

    protected abstract void doOnSuccess(UUID var1);

    @Override
    public void init(List<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> msgs) {
        this.orderedMsgList = msgs.stream().map(msg -> new IdMsgPair(UUID.randomUUID(), msg)).collect(Collectors.toList());
    }

    @Override
    public ConcurrentMap<UUID, TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> getPendingMap() {
        return this.orderedMsgList.stream().collect(Collectors.toConcurrentMap(pair -> pair.uuid, pair -> pair.msg));
    }

    @Override
    public void update(ConcurrentMap<UUID, TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> reprocessMap) {
        ArrayList<IdMsgPair<TransportProtos.ToRuleEngineMsg>> newOrderedMsgList = new ArrayList<IdMsgPair<TransportProtos.ToRuleEngineMsg>>(reprocessMap.size());
        for (IdMsgPair<TransportProtos.ToRuleEngineMsg> pair : this.orderedMsgList) {
            if (!reprocessMap.containsKey(pair.uuid)) continue;
            if (StringUtils.isNotEmpty((String)((TransportProtos.ToRuleEngineMsg)pair.getMsg().getValue()).getFailureMessage())) {
                TransportProtos.ToRuleEngineMsg toRuleEngineMsg = TransportProtos.ToRuleEngineMsg.newBuilder((TransportProtos.ToRuleEngineMsg)((TransportProtos.ToRuleEngineMsg)pair.getMsg().getValue())).clearFailureMessage().clearRelationTypes().build();
                TbProtoQueueMsg newMsg = new TbProtoQueueMsg(pair.getMsg().getKey(), (GeneratedMessageV3)toRuleEngineMsg, pair.getMsg().getHeaders());
                newOrderedMsgList.add(new IdMsgPair(pair.getUuid(), newMsg));
                continue;
            }
            newOrderedMsgList.add(pair);
        }
        this.orderedMsgList = newOrderedMsgList;
    }

    @Override
    public void onSuccess(UUID id) {
        if (!this.stopped) {
            this.doOnSuccess(id);
        }
    }

    @Override
    public void stop() {
        this.stopped = true;
    }
}

