/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.profile;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.asset.AssetProfile;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.AssetProfileId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.asset.AssetProfileService;
import org.thingsboard.server.dao.asset.AssetService;
import org.thingsboard.server.service.profile.TbAssetProfileCache;

@Service
public class DefaultTbAssetProfileCache
implements TbAssetProfileCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbAssetProfileCache.class);
    private final Lock assetProfileFetchLock = new ReentrantLock();
    private final AssetProfileService assetProfileService;
    private final AssetService assetService;
    private final ConcurrentMap<AssetProfileId, AssetProfile> assetProfilesMap = new ConcurrentHashMap<AssetProfileId, AssetProfile>();
    private final ConcurrentMap<AssetId, AssetProfileId> assetsMap = new ConcurrentHashMap<AssetId, AssetProfileId>();
    private final ConcurrentMap<TenantId, ConcurrentMap<EntityId, Consumer<AssetProfile>>> profileListeners = new ConcurrentHashMap<TenantId, ConcurrentMap<EntityId, Consumer<AssetProfile>>>();
    private final ConcurrentMap<TenantId, ConcurrentMap<EntityId, BiConsumer<AssetId, AssetProfile>>> assetProfileListeners = new ConcurrentHashMap<TenantId, ConcurrentMap<EntityId, BiConsumer<AssetId, AssetProfile>>>();

    public DefaultTbAssetProfileCache(AssetProfileService assetProfileService, AssetService assetService) {
        this.assetProfileService = assetProfileService;
        this.assetService = assetService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssetProfile get(TenantId tenantId, AssetProfileId assetProfileId) {
        AssetProfile profile = (AssetProfile)this.assetProfilesMap.get(assetProfileId);
        if (profile == null) {
            this.assetProfileFetchLock.lock();
            try {
                profile = (AssetProfile)this.assetProfilesMap.get(assetProfileId);
                if (profile == null && (profile = this.assetProfileService.findAssetProfileById(tenantId, assetProfileId)) != null) {
                    this.assetProfilesMap.put(assetProfileId, profile);
                    log.debug("[{}] Fetch asset profile into cache: {}", (Object)profile.getId(), (Object)profile);
                }
            }
            finally {
                this.assetProfileFetchLock.unlock();
            }
        }
        log.trace("[{}] Found asset profile in cache: {}", (Object)assetProfileId, (Object)profile);
        return profile;
    }

    public AssetProfile get(TenantId tenantId, AssetId assetId) {
        AssetProfileId profileId = (AssetProfileId)this.assetsMap.get(assetId);
        if (profileId == null) {
            Asset asset = this.assetService.findAssetById(tenantId, assetId);
            if (asset != null) {
                profileId = asset.getAssetProfileId();
                this.assetsMap.put(assetId, profileId);
            } else {
                return null;
            }
        }
        return this.get(tenantId, profileId);
    }

    @Override
    public void evict(TenantId tenantId, AssetProfileId profileId) {
        AssetProfile oldProfile = (AssetProfile)this.assetProfilesMap.remove(profileId);
        log.debug("[{}] evict asset profile from cache: {}", (Object)profileId, (Object)oldProfile);
        AssetProfile newProfile = this.get(tenantId, profileId);
        if (newProfile != null) {
            this.notifyProfileListeners(newProfile);
        }
    }

    @Override
    public void evict(TenantId tenantId, AssetId assetId) {
        AssetProfile newProfile;
        AssetProfileId old = (AssetProfileId)this.assetsMap.remove(assetId);
        if (!(old == null || (newProfile = this.get(tenantId, assetId)) != null && old.equals((Object)newProfile.getId()))) {
            this.notifyAssetListeners(tenantId, assetId, newProfile);
        }
    }

    public void addListener(TenantId tenantId, EntityId listenerId, Consumer<AssetProfile> profileListener, BiConsumer<AssetId, AssetProfile> assetListener) {
        if (profileListener != null) {
            this.profileListeners.computeIfAbsent(tenantId, id -> new ConcurrentHashMap()).put(listenerId, profileListener);
        }
        if (assetListener != null) {
            this.assetProfileListeners.computeIfAbsent(tenantId, id -> new ConcurrentHashMap()).put(listenerId, assetListener);
        }
    }

    @Override
    public AssetProfile find(AssetProfileId assetProfileId) {
        return this.assetProfileService.findAssetProfileById(TenantId.SYS_TENANT_ID, assetProfileId);
    }

    @Override
    public AssetProfile findOrCreateAssetProfile(TenantId tenantId, String profileName) {
        return this.assetProfileService.findOrCreateAssetProfile(tenantId, profileName);
    }

    public void removeListener(TenantId tenantId, EntityId listenerId) {
        ConcurrentMap assetListeners;
        ConcurrentMap tenantListeners = (ConcurrentMap)this.profileListeners.get(tenantId);
        if (tenantListeners != null) {
            tenantListeners.remove(listenerId);
        }
        if ((assetListeners = (ConcurrentMap)this.assetProfileListeners.get(tenantId)) != null) {
            assetListeners.remove(listenerId);
        }
    }

    private void notifyProfileListeners(AssetProfile profile) {
        ConcurrentMap tenantListeners = (ConcurrentMap)this.profileListeners.get(profile.getTenantId());
        if (tenantListeners != null) {
            tenantListeners.forEach((id, listener) -> listener.accept(profile));
        }
    }

    private void notifyAssetListeners(TenantId tenantId, AssetId assetId, AssetProfile profile) {
        ConcurrentMap tenantListeners;
        if (profile != null && (tenantListeners = (ConcurrentMap)this.assetProfileListeners.get(tenantId)) != null) {
            tenantListeners.forEach((id, listener) -> listener.accept(assetId, profile));
        }
    }
}

