/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.ota;

import com.google.common.util.concurrent.FutureCallback;
import com.google.protobuf.GeneratedMessageV3;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.thingsboard.rule.engine.api.AttributesDeleteRequest;
import org.thingsboard.rule.engine.api.AttributesSaveRequest;
import org.thingsboard.rule.engine.api.RuleEngineTelemetryService;
import org.thingsboard.rule.engine.api.TimeseriesSaveRequest;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.HasOtaPackage;
import org.thingsboard.server.common.data.OtaPackageInfo;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.LongDataEntry;
import org.thingsboard.server.common.data.kv.StringDataEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.ota.OtaPackageKey;
import org.thingsboard.server.common.data.ota.OtaPackageType;
import org.thingsboard.server.common.data.ota.OtaPackageUpdateStatus;
import org.thingsboard.server.common.data.ota.OtaPackageUtil;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.msg.ToDeviceActorNotificationMsg;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.common.msg.rule.engine.DeviceAttributesEventNotificationMsg;
import org.thingsboard.server.dao.device.DeviceProfileService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.ota.OtaPackageService;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.provider.TbCoreQueueFactory;
import org.thingsboard.server.queue.provider.TbRuleEngineQueueFactory;
import org.thingsboard.server.service.ota.OtaPackageStateService;

@Service
public class DefaultOtaPackageStateService
implements OtaPackageStateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultOtaPackageStateService.class);
    private final TbClusterService tbClusterService;
    private final OtaPackageService otaPackageService;
    private final DeviceService deviceService;
    private final DeviceProfileService deviceProfileService;
    private final RuleEngineTelemetryService telemetryService;
    private final TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToOtaPackageStateServiceMsg>> otaPackageStateMsgProducer;

    public DefaultOtaPackageStateService(@Lazy TbClusterService tbClusterService, OtaPackageService otaPackageService, DeviceService deviceService, DeviceProfileService deviceProfileService, @Lazy RuleEngineTelemetryService telemetryService, Optional<TbCoreQueueFactory> coreQueueFactory, Optional<TbRuleEngineQueueFactory> reQueueFactory) {
        this.tbClusterService = tbClusterService;
        this.otaPackageService = otaPackageService;
        this.deviceService = deviceService;
        this.deviceProfileService = deviceProfileService;
        this.telemetryService = telemetryService;
        this.otaPackageStateMsgProducer = coreQueueFactory.isPresent() ? coreQueueFactory.get().createToOtaPackageStateServiceMsgProducer() : reQueueFactory.get().createToOtaPackageStateServiceMsgProducer();
    }

    @Override
    public void update(Device device, Device oldDevice) {
        this.updateFirmware(device, oldDevice);
        this.updateSoftware(device, oldDevice);
    }

    private void updateFirmware(Device device, Device oldDevice) {
        OtaPackageId newFirmwareId = device.getFirmwareId();
        if (newFirmwareId == null) {
            DeviceProfile newDeviceProfile = this.deviceProfileService.findDeviceProfileById(device.getTenantId(), device.getDeviceProfileId());
            newFirmwareId = newDeviceProfile.getFirmwareId();
        }
        if (oldDevice != null) {
            OtaPackageId oldFirmwareId = oldDevice.getFirmwareId();
            if (oldFirmwareId == null) {
                DeviceProfile oldDeviceProfile = this.deviceProfileService.findDeviceProfileById(oldDevice.getTenantId(), oldDevice.getDeviceProfileId());
                oldFirmwareId = oldDeviceProfile.getFirmwareId();
            }
            if (newFirmwareId != null) {
                if (!newFirmwareId.equals((Object)oldFirmwareId)) {
                    this.send(device.getTenantId(), device.getId(), newFirmwareId, System.currentTimeMillis(), OtaPackageType.FIRMWARE);
                }
            } else if (oldFirmwareId != null) {
                this.remove(device, OtaPackageType.FIRMWARE);
            }
        } else if (newFirmwareId != null) {
            this.send(device.getTenantId(), device.getId(), newFirmwareId, System.currentTimeMillis(), OtaPackageType.FIRMWARE);
        }
    }

    private void updateSoftware(Device device, Device oldDevice) {
        OtaPackageId newSoftwareId = device.getSoftwareId();
        if (newSoftwareId == null) {
            DeviceProfile newDeviceProfile = this.deviceProfileService.findDeviceProfileById(device.getTenantId(), device.getDeviceProfileId());
            newSoftwareId = newDeviceProfile.getSoftwareId();
        }
        if (oldDevice != null) {
            OtaPackageId oldSoftwareId = oldDevice.getSoftwareId();
            if (oldSoftwareId == null) {
                DeviceProfile oldDeviceProfile = this.deviceProfileService.findDeviceProfileById(oldDevice.getTenantId(), oldDevice.getDeviceProfileId());
                oldSoftwareId = oldDeviceProfile.getSoftwareId();
            }
            if (newSoftwareId != null) {
                if (!newSoftwareId.equals((Object)oldSoftwareId)) {
                    this.send(device.getTenantId(), device.getId(), newSoftwareId, System.currentTimeMillis(), OtaPackageType.SOFTWARE);
                }
            } else if (oldSoftwareId != null) {
                this.remove(device, OtaPackageType.SOFTWARE);
            }
        } else if (newSoftwareId != null) {
            this.send(device.getTenantId(), device.getId(), newSoftwareId, System.currentTimeMillis(), OtaPackageType.SOFTWARE);
        }
    }

    @Override
    public void update(DeviceProfile deviceProfile, boolean isFirmwareChanged, boolean isSoftwareChanged) {
        TenantId tenantId = deviceProfile.getTenantId();
        if (isFirmwareChanged) {
            this.update(tenantId, deviceProfile, OtaPackageType.FIRMWARE);
        }
        if (isSoftwareChanged) {
            this.update(tenantId, deviceProfile, OtaPackageType.SOFTWARE);
        }
    }

    private void update(TenantId tenantId, DeviceProfile deviceProfile, OtaPackageType otaPackageType) {
        PageData pageData;
        Consumer<Device> updateConsumer;
        OtaPackageId packageId = OtaPackageUtil.getOtaPackageId((HasOtaPackage)deviceProfile, (OtaPackageType)otaPackageType);
        if (packageId != null) {
            long ts = System.currentTimeMillis();
            updateConsumer = d -> this.send(d.getTenantId(), d.getId(), packageId, ts, otaPackageType);
        } else {
            updateConsumer = d -> this.remove((Device)d, otaPackageType);
        }
        PageLink pageLink = new PageLink(100);
        do {
            pageData = this.deviceService.findDevicesByTenantIdAndTypeAndEmptyOtaPackage(tenantId, deviceProfile.getId(), otaPackageType, pageLink);
            pageData.getData().forEach(updateConsumer);
            if (!pageData.hasNext()) continue;
            pageLink = pageLink.nextPageLink();
        } while (pageData.hasNext());
    }

    @Override
    public boolean process(TransportProtos.ToOtaPackageStateServiceMsg msg) {
        boolean isSuccess = false;
        OtaPackageId targetOtaPackageId = new OtaPackageId(new UUID(msg.getOtaPackageIdMSB(), msg.getOtaPackageIdLSB()));
        DeviceId deviceId = new DeviceId(new UUID(msg.getDeviceIdMSB(), msg.getDeviceIdLSB()));
        TenantId tenantId = TenantId.fromUUID((UUID)new UUID(msg.getTenantIdMSB(), msg.getTenantIdLSB()));
        OtaPackageType firmwareType = OtaPackageType.valueOf((String)msg.getType());
        long ts = msg.getTs();
        Device device = this.deviceService.findDeviceById(tenantId, deviceId);
        if (device == null) {
            log.warn("[{}] [{}] Device was removed during firmware update msg was queued!", (Object)tenantId, (Object)deviceId);
        } else {
            OtaPackageId currentOtaPackageId = OtaPackageUtil.getOtaPackageId((HasOtaPackage)device, (OtaPackageType)firmwareType);
            if (currentOtaPackageId == null) {
                DeviceProfile deviceProfile = this.deviceProfileService.findDeviceProfileById(tenantId, device.getDeviceProfileId());
                currentOtaPackageId = OtaPackageUtil.getOtaPackageId((HasOtaPackage)deviceProfile, (OtaPackageType)firmwareType);
            }
            if (targetOtaPackageId.equals((Object)currentOtaPackageId)) {
                this.update(device, this.otaPackageService.findOtaPackageInfoById(device.getTenantId(), targetOtaPackageId), ts);
                isSuccess = true;
            } else {
                log.warn("[{}] [{}] Can`t update firmware for the device, target firmwareId: [{}], current firmwareId: [{}]!", new Object[]{tenantId, deviceId, targetOtaPackageId, currentOtaPackageId});
            }
        }
        return isSuccess;
    }

    private void send(TenantId tenantId, final DeviceId deviceId, OtaPackageId firmwareId, long ts, OtaPackageType firmwareType) {
        TransportProtos.ToOtaPackageStateServiceMsg msg = TransportProtos.ToOtaPackageStateServiceMsg.newBuilder().setTenantIdMSB(tenantId.getId().getMostSignificantBits()).setTenantIdLSB(tenantId.getId().getLeastSignificantBits()).setDeviceIdMSB(deviceId.getId().getMostSignificantBits()).setDeviceIdLSB(deviceId.getId().getLeastSignificantBits()).setOtaPackageIdMSB(firmwareId.getId().getMostSignificantBits()).setOtaPackageIdLSB(firmwareId.getId().getLeastSignificantBits()).setType(firmwareType.name()).setTs(ts).build();
        OtaPackageInfo firmware = this.otaPackageService.findOtaPackageInfoById(tenantId, firmwareId);
        if (firmware == null) {
            log.warn("[{}] Failed to send firmware update because firmware was already deleted", (Object)firmwareId);
            return;
        }
        TopicPartitionInfo tpi = new TopicPartitionInfo(this.otaPackageStateMsgProducer.getDefaultTopic(), null, null, false);
        this.otaPackageStateMsgProducer.send(tpi, (TbQueueMsg)new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)msg), null);
        ArrayList<BasicTsKvEntry> telemetry = new ArrayList<BasicTsKvEntry>();
        telemetry.add(new BasicTsKvEntry(ts, (KvEntry)new StringDataEntry(OtaPackageUtil.getTargetTelemetryKey((OtaPackageType)firmware.getType(), (OtaPackageKey)OtaPackageKey.TITLE), firmware.getTitle())));
        telemetry.add(new BasicTsKvEntry(ts, (KvEntry)new StringDataEntry(OtaPackageUtil.getTargetTelemetryKey((OtaPackageType)firmware.getType(), (OtaPackageKey)OtaPackageKey.VERSION), firmware.getVersion())));
        if (StringUtils.isNotEmpty((String)firmware.getTag())) {
            telemetry.add(new BasicTsKvEntry(ts, (KvEntry)new StringDataEntry(OtaPackageUtil.getTargetTelemetryKey((OtaPackageType)firmware.getType(), (OtaPackageKey)OtaPackageKey.TAG), firmware.getTag())));
        }
        telemetry.add(new BasicTsKvEntry(ts, (KvEntry)new LongDataEntry(OtaPackageUtil.getTargetTelemetryKey((OtaPackageType)firmware.getType(), (OtaPackageKey)OtaPackageKey.TS), Long.valueOf(ts))));
        telemetry.add(new BasicTsKvEntry(ts, (KvEntry)new StringDataEntry(OtaPackageUtil.getTelemetryKey((OtaPackageType)firmware.getType(), (OtaPackageKey)OtaPackageKey.STATE), OtaPackageUpdateStatus.QUEUED.name())));
        this.telemetryService.saveTimeseries(TimeseriesSaveRequest.builder().tenantId(tenantId).entityId((EntityId)deviceId).entries(telemetry).callback((FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void tmp) {
                log.trace("[{}] Success save firmware status!", (Object)deviceId);
            }

            public void onFailure(Throwable t) {
                log.error("[{}] Failed to save firmware status!", (Object)deviceId, (Object)t);
            }
        }).build());
    }

    private void update(final Device device, final OtaPackageInfo otaPackage, final long ts) {
        final TenantId tenantId = device.getTenantId();
        final DeviceId deviceId = device.getId();
        final OtaPackageType otaPackageType = otaPackage.getType();
        BasicTsKvEntry status = new BasicTsKvEntry(System.currentTimeMillis(), (KvEntry)new StringDataEntry(OtaPackageUtil.getTelemetryKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.STATE), OtaPackageUpdateStatus.INITIATED.name()));
        this.telemetryService.saveTimeseries(TimeseriesSaveRequest.builder().tenantId(tenantId).entityId((EntityId)deviceId).entry((TsKvEntry)status).callback((FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void tmp) {
                log.trace("[{}] Success save telemetry with target {} for device!", (Object)deviceId, (Object)otaPackage);
                DefaultOtaPackageStateService.this.updateAttributes(device, otaPackage, ts, tenantId, deviceId, otaPackageType);
            }

            public void onFailure(Throwable t) {
                log.error("[{}] Failed to save telemetry with target {} for device!", new Object[]{deviceId, otaPackage, t});
                DefaultOtaPackageStateService.this.updateAttributes(device, otaPackage, ts, tenantId, deviceId, otaPackageType);
            }
        }).build());
    }

    private void updateAttributes(Device device, OtaPackageInfo otaPackage, long ts, TenantId tenantId, final DeviceId deviceId, OtaPackageType otaPackageType) {
        ArrayList<BaseAttributeKvEntry> attributes = new ArrayList<BaseAttributeKvEntry>();
        ArrayList<String> attrToRemove = new ArrayList<String>();
        attributes.add(new BaseAttributeKvEntry(ts, (KvEntry)new StringDataEntry(OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.TITLE), otaPackage.getTitle())));
        attributes.add(new BaseAttributeKvEntry(ts, (KvEntry)new StringDataEntry(OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.VERSION), otaPackage.getVersion())));
        if (StringUtils.isNotEmpty((String)otaPackage.getTag())) {
            attributes.add(new BaseAttributeKvEntry(ts, (KvEntry)new StringDataEntry(OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.TAG), otaPackage.getTag())));
        } else {
            attrToRemove.add(OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.TAG));
        }
        if (otaPackage.hasUrl()) {
            attributes.add(new BaseAttributeKvEntry(ts, (KvEntry)new StringDataEntry(OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.URL), otaPackage.getUrl())));
            if (otaPackage.getDataSize() == null) {
                attrToRemove.add(OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.SIZE));
            } else {
                attributes.add(new BaseAttributeKvEntry(ts, (KvEntry)new LongDataEntry(OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.SIZE), otaPackage.getDataSize())));
            }
            if (otaPackage.getChecksumAlgorithm() != null) {
                attrToRemove.add(OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.CHECKSUM_ALGORITHM));
            } else {
                attributes.add(new BaseAttributeKvEntry(ts, (KvEntry)new StringDataEntry(OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.CHECKSUM_ALGORITHM), otaPackage.getChecksumAlgorithm().name())));
            }
            if (StringUtils.isEmpty((String)otaPackage.getChecksum())) {
                attrToRemove.add(OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.CHECKSUM));
            } else {
                attributes.add(new BaseAttributeKvEntry(ts, (KvEntry)new StringDataEntry(OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.CHECKSUM), otaPackage.getChecksum())));
            }
        } else {
            attributes.add(new BaseAttributeKvEntry(ts, (KvEntry)new LongDataEntry(OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.SIZE), otaPackage.getDataSize())));
            attributes.add(new BaseAttributeKvEntry(ts, (KvEntry)new StringDataEntry(OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.CHECKSUM_ALGORITHM), otaPackage.getChecksumAlgorithm().name())));
            attributes.add(new BaseAttributeKvEntry(ts, (KvEntry)new StringDataEntry(OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.CHECKSUM), otaPackage.getChecksum())));
            attrToRemove.add(OtaPackageUtil.getAttributeKey((OtaPackageType)otaPackageType, (OtaPackageKey)OtaPackageKey.URL));
        }
        this.remove(device, otaPackageType, attrToRemove);
        this.telemetryService.saveAttributes(AttributesSaveRequest.builder().tenantId(tenantId).entityId((EntityId)deviceId).scope(AttributeScope.SHARED_SCOPE).entries(attributes).callback((FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void tmp) {
                log.trace("[{}] Success save attributes with target firmware!", (Object)deviceId);
            }

            public void onFailure(Throwable t) {
                log.error("[{}] Failed to save attributes with target firmware!", (Object)deviceId, (Object)t);
            }
        }).build());
    }

    private void remove(Device device, OtaPackageType otaPackageType) {
        this.remove(device, otaPackageType, OtaPackageUtil.getAttributeKeys((OtaPackageType)otaPackageType));
    }

    private void remove(final Device device, final OtaPackageType otaPackageType, final List<String> attributesKeys) {
        this.telemetryService.deleteAttributes(AttributesDeleteRequest.builder().tenantId(device.getTenantId()).entityId((EntityId)device.getId()).scope(AttributeScope.SHARED_SCOPE).keys(attributesKeys).callback((FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void tmp) {
                log.trace("[{}] Success remove target {} attributes!", (Object)device.getId(), (Object)otaPackageType);
                DefaultOtaPackageStateService.this.tbClusterService.pushMsgToCore((ToDeviceActorNotificationMsg)DeviceAttributesEventNotificationMsg.onDelete((TenantId)device.getTenantId(), (DeviceId)device.getId(), (String)"SHARED_SCOPE", (List)attributesKeys), null);
            }

            public void onFailure(Throwable t) {
                log.error("[{}] Failed to remove target {} attributes!", new Object[]{device.getId(), otaPackageType, t});
            }
        }).build());
    }
}

