/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.notification.rule.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import jakarta.annotation.PostConstruct;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.notification.rule.NotificationRule;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerType;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.common.msg.plugin.ComponentLifecycleMsg;
import org.thingsboard.server.dao.notification.NotificationRuleService;
import org.thingsboard.server.service.notification.rule.cache.NotificationRulesCache;

@Service
public class DefaultNotificationRulesCache
implements NotificationRulesCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultNotificationRulesCache.class);
    private final NotificationRuleService notificationRuleService;
    @Value(value="${cache.notificationRules.maxSize:1000}")
    private int cacheMaxSize;
    @Value(value="${cache.notificationRules.timeToLiveInMinutes:30}")
    private int cacheValueTtl;
    private Cache<String, List<NotificationRule>> cache;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    @PostConstruct
    private void init() {
        this.cache = Caffeine.newBuilder().maximumSize((long)this.cacheMaxSize).expireAfterAccess((long)this.cacheValueTtl, TimeUnit.MINUTES).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener(value={ComponentLifecycleMsg.class})
    public void onComponentLifecycleEvent(ComponentLifecycleMsg event) {
        switch (event.getEntityId().getEntityType()) {
            case NOTIFICATION_RULE: {
                this.evict(event.getTenantId());
                break;
            }
            case TENANT: {
                if (event.getEvent() != ComponentLifecycleEvent.DELETED) break;
                this.lock.writeLock().lock();
                try {
                    for (NotificationRuleTriggerType triggerType : NotificationRuleTriggerType.values()) {
                        String key = DefaultNotificationRulesCache.key(event.getTenantId(), triggerType);
                        this.cache.put((Object)key, Collections.emptyList());
                    }
                    break;
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NotificationRule> getEnabled(TenantId tenantId, NotificationRuleTriggerType triggerType) {
        this.lock.readLock().lock();
        try {
            log.trace("Retrieving notification rules of type {} for tenant {} from cache", (Object)triggerType, (Object)tenantId);
            List list = (List)this.cache.get((Object)DefaultNotificationRulesCache.key(tenantId, triggerType), k -> {
                List rules = this.notificationRuleService.findEnabledNotificationRulesByTenantIdAndTriggerType(tenantId, triggerType);
                log.trace("Fetched notification rules of type {} for tenant {} (count: {})", new Object[]{triggerType, tenantId, rules.size()});
                return !rules.isEmpty() ? rules : Collections.emptyList();
            });
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void evict(TenantId tenantId) {
        this.cache.invalidateAll((Iterable)Arrays.stream(NotificationRuleTriggerType.values()).map(triggerType -> DefaultNotificationRulesCache.key(tenantId, triggerType)).collect(Collectors.toList()));
        log.trace("Evicted all notification rules for tenant {} from cache", (Object)tenantId);
    }

    private static String key(TenantId tenantId, NotificationRuleTriggerType triggerType) {
        return String.valueOf(tenantId) + "_" + String.valueOf(triggerType);
    }

    @ConstructorProperties(value={"notificationRuleService"})
    @Generated
    public DefaultNotificationRulesCache(NotificationRuleService notificationRuleService) {
        this.notificationRuleService = notificationRuleService;
    }
}

