/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.notification;

import com.google.common.base.Strings;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.notification.NotificationDeliveryMethod;
import org.thingsboard.server.common.data.notification.NotificationRequest;
import org.thingsboard.server.common.data.notification.NotificationRequestStats;
import org.thingsboard.server.common.data.notification.NotificationType;
import org.thingsboard.server.common.data.notification.settings.NotificationDeliveryMethodConfig;
import org.thingsboard.server.common.data.notification.settings.NotificationSettings;
import org.thingsboard.server.common.data.notification.targets.NotificationRecipient;
import org.thingsboard.server.common.data.notification.template.DeliveryMethodNotificationTemplate;
import org.thingsboard.server.common.data.notification.template.NotificationTemplate;
import org.thingsboard.server.common.data.notification.template.NotificationTemplateConfig;
import org.thingsboard.server.common.data.util.TemplateUtils;

public class NotificationProcessingContext {
    private final TenantId tenantId;
    private final NotificationSettings settings;
    private final NotificationSettings systemSettings;
    private final NotificationRequest request;
    private final Set<NotificationDeliveryMethod> deliveryMethods;
    private final NotificationTemplate notificationTemplate;
    private final NotificationType notificationType;
    private final Map<NotificationDeliveryMethod, DeliveryMethodNotificationTemplate> templates;
    private final NotificationRequestStats stats;

    public NotificationProcessingContext(TenantId tenantId, NotificationRequest request, Set<NotificationDeliveryMethod> deliveryMethods, NotificationTemplate template, NotificationSettings settings, NotificationSettings systemSettings) {
        this.tenantId = tenantId;
        this.request = request;
        this.deliveryMethods = deliveryMethods;
        this.settings = settings;
        this.systemSettings = systemSettings;
        this.notificationTemplate = template;
        this.notificationType = template.getNotificationType();
        this.templates = new EnumMap<NotificationDeliveryMethod, DeliveryMethodNotificationTemplate>(NotificationDeliveryMethod.class);
        this.stats = new NotificationRequestStats();
        this.init();
    }

    private void init() {
        NotificationTemplateConfig templateConfig = this.notificationTemplate.getConfiguration();
        templateConfig.getDeliveryMethodsTemplates().forEach((deliveryMethod, template) -> {
            if (template.isEnabled()) {
                template = this.processTemplate(template, null);
                this.templates.put((NotificationDeliveryMethod)deliveryMethod, (DeliveryMethodNotificationTemplate)template);
            }
        });
    }

    public <C extends NotificationDeliveryMethodConfig> C getDeliveryMethodConfig(NotificationDeliveryMethod deliveryMethod) {
        NotificationSettings settings = deliveryMethod == NotificationDeliveryMethod.MOBILE_APP ? this.systemSettings : this.settings;
        return (C)((NotificationDeliveryMethodConfig)settings.getDeliveryMethodsConfigs().get(deliveryMethod));
    }

    public <T extends DeliveryMethodNotificationTemplate> T getProcessedTemplate(NotificationDeliveryMethod deliveryMethod, NotificationRecipient recipient) {
        DeliveryMethodNotificationTemplate template = this.templates.get(deliveryMethod);
        if (recipient != null) {
            Map<String, String> additionalTemplateContext = this.createTemplateContextForRecipient(recipient);
            if (template.getTemplatableValues().stream().anyMatch(value -> value.containsParams(additionalTemplateContext.keySet()))) {
                template = this.processTemplate(template, additionalTemplateContext);
            }
        }
        return (T)template;
    }

    private <T extends DeliveryMethodNotificationTemplate> T processTemplate(T template, Map<String, String> additionalTemplateContext) {
        HashMap<String, String> templateContext = new HashMap<String, String>();
        if (this.request.getInfo() != null) {
            templateContext.putAll(this.request.getInfo().getTemplateData());
        }
        if (additionalTemplateContext != null) {
            templateContext.putAll(additionalTemplateContext);
        }
        if (templateContext.isEmpty()) {
            return template;
        }
        template = template.copy();
        template.getTemplatableValues().forEach(templatableValue -> {
            String value = templatableValue.get();
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                value = TemplateUtils.processTemplate((String)value, (Map)templateContext);
                templatableValue.set(value);
            }
        });
        return template;
    }

    private Map<String, String> createTemplateContextForRecipient(NotificationRecipient recipient) {
        return Map.of("recipientTitle", recipient.getTitle(), "recipientEmail", Strings.nullToEmpty((String)recipient.getEmail()), "recipientFirstName", Strings.nullToEmpty((String)recipient.getFirstName()), "recipientLastName", Strings.nullToEmpty((String)recipient.getLastName()));
    }

    @Generated
    public static NotificationProcessingContextBuilder builder() {
        return new NotificationProcessingContextBuilder();
    }

    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public NotificationRequest getRequest() {
        return this.request;
    }

    @Generated
    public Set<NotificationDeliveryMethod> getDeliveryMethods() {
        return this.deliveryMethods;
    }

    @Generated
    public NotificationTemplate getNotificationTemplate() {
        return this.notificationTemplate;
    }

    @Generated
    public NotificationType getNotificationType() {
        return this.notificationType;
    }

    @Generated
    public NotificationRequestStats getStats() {
        return this.stats;
    }

    @Generated
    public static class NotificationProcessingContextBuilder {
        @Generated
        private TenantId tenantId;
        @Generated
        private NotificationRequest request;
        @Generated
        private Set<NotificationDeliveryMethod> deliveryMethods;
        @Generated
        private NotificationTemplate template;
        @Generated
        private NotificationSettings settings;
        @Generated
        private NotificationSettings systemSettings;

        @Generated
        NotificationProcessingContextBuilder() {
        }

        @Generated
        public NotificationProcessingContextBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public NotificationProcessingContextBuilder request(NotificationRequest request) {
            this.request = request;
            return this;
        }

        @Generated
        public NotificationProcessingContextBuilder deliveryMethods(Set<NotificationDeliveryMethod> deliveryMethods) {
            this.deliveryMethods = deliveryMethods;
            return this;
        }

        @Generated
        public NotificationProcessingContextBuilder template(NotificationTemplate template) {
            this.template = template;
            return this;
        }

        @Generated
        public NotificationProcessingContextBuilder settings(NotificationSettings settings) {
            this.settings = settings;
            return this;
        }

        @Generated
        public NotificationProcessingContextBuilder systemSettings(NotificationSettings systemSettings) {
            this.systemSettings = systemSettings;
            return this;
        }

        @Generated
        public NotificationProcessingContext build() {
            return new NotificationProcessingContext(this.tenantId, this.request, this.deliveryMethods, this.template, this.settings, this.systemSettings);
        }

        @Generated
        public String toString() {
            return "NotificationProcessingContext.NotificationProcessingContextBuilder(tenantId=" + String.valueOf(this.tenantId) + ", request=" + String.valueOf(this.request) + ", deliveryMethods=" + String.valueOf(this.deliveryMethods) + ", template=" + String.valueOf(this.template) + ", settings=" + String.valueOf(this.settings) + ", systemSettings=" + String.valueOf(this.systemSettings) + ")";
        }
    }
}

