/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.mobile;

import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.id.MobileAppBundleId;
import org.thingsboard.server.common.data.id.OAuth2ClientId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.mobile.bundle.MobileAppBundle;
import org.thingsboard.server.dao.mobile.MobileAppBundleService;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.mobile.TbMobileAppBundleService;

@Service
public class DefaultTbMobileAppBundleService
extends AbstractTbEntityService
implements TbMobileAppBundleService {
    private final MobileAppBundleService mobileAppBundleService;

    @Override
    public MobileAppBundle save(MobileAppBundle mobileAppBundle, List<OAuth2ClientId> oauth2Clients, User user) throws Exception {
        ActionType actionType = mobileAppBundle.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = mobileAppBundle.getTenantId();
        try {
            MobileAppBundle savedMobileAppBundle = this.checkNotNull(this.mobileAppBundleService.saveMobileAppBundle(tenantId, mobileAppBundle));
            if (CollectionUtils.isNotEmpty(oauth2Clients)) {
                this.mobileAppBundleService.updateOauth2Clients(tenantId, (MobileAppBundleId)savedMobileAppBundle.getId(), oauth2Clients);
            }
            this.logEntityActionService.logEntityAction(tenantId, (MobileAppBundleId)savedMobileAppBundle.getId(), savedMobileAppBundle, actionType, user, new Object[0]);
            return savedMobileAppBundle;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.MOBILE_APP), mobileAppBundle, actionType, user, e, new Object[0]);
            throw e;
        }
    }

    @Override
    public void updateOauth2Clients(MobileAppBundle mobileAppBundle, List<OAuth2ClientId> oAuth2ClientIds, User user) {
        ActionType actionType = ActionType.UPDATED;
        TenantId tenantId = mobileAppBundle.getTenantId();
        MobileAppBundleId mobileAppBundleId = (MobileAppBundleId)mobileAppBundle.getId();
        try {
            this.mobileAppBundleService.updateOauth2Clients(tenantId, mobileAppBundleId, oAuth2ClientIds);
            this.logEntityActionService.logEntityAction(tenantId, mobileAppBundleId, mobileAppBundle, actionType, user, oAuth2ClientIds);
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, mobileAppBundleId, mobileAppBundle, actionType, user, e, oAuth2ClientIds);
            throw e;
        }
    }

    @Override
    public void delete(MobileAppBundle mobileAppBundle, User user) {
        ActionType actionType = ActionType.DELETED;
        TenantId tenantId = mobileAppBundle.getTenantId();
        MobileAppBundleId mobileAppBundleId = (MobileAppBundleId)mobileAppBundle.getId();
        try {
            this.mobileAppBundleService.deleteMobileAppBundleById(tenantId, mobileAppBundleId);
            this.logEntityActionService.logEntityAction(tenantId, mobileAppBundleId, mobileAppBundle, actionType, user, new Object[0]);
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, mobileAppBundleId, mobileAppBundle, actionType, user, e, new Object[0]);
            throw e;
        }
    }

    @ConstructorProperties(value={"mobileAppBundleService"})
    @Generated
    public DefaultTbMobileAppBundleService(MobileAppBundleService mobileAppBundleService) {
        this.mobileAppBundleService = mobileAppBundleService;
    }
}

