/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.edge;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.dao.rule.RuleChainService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.edge.TbEdgeService;

@TbCoreComponent
@Service
public class DefaultTbEdgeService
extends AbstractTbEntityService
implements TbEdgeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbEdgeService.class);
    private final RuleChainService ruleChainService;

    @Override
    public Edge save(Edge edge, RuleChain edgeTemplateRootRuleChain, User user) throws Exception {
        ActionType actionType = edge.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = edge.getTenantId();
        try {
            if (ActionType.ADDED.equals((Object)actionType) && edge.getRootRuleChainId() == null) {
                edge.setRootRuleChainId(edgeTemplateRootRuleChain.getId());
            }
            Edge savedEdge = this.checkNotNull(this.edgeService.saveEdge(edge));
            EdgeId edgeId = savedEdge.getId();
            if (ActionType.ADDED.equals((Object)actionType)) {
                this.ruleChainService.assignRuleChainToEdge(tenantId, edgeTemplateRootRuleChain.getId(), edgeId);
                savedEdge = this.edgeService.setEdgeRootRuleChain(tenantId, savedEdge, edgeTemplateRootRuleChain.getId());
                this.edgeService.assignDefaultRuleChainsToEdge(tenantId, edgeId);
            }
            this.logEntityActionService.logEntityAction(tenantId, edgeId, savedEdge, savedEdge.getCustomerId(), actionType, user, new Object[0]);
            return savedEdge;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.EDGE), edge, actionType, user, e, new Object[0]);
            throw e;
        }
    }

    @Override
    public void delete(Edge edge, User user) {
        ActionType actionType = ActionType.DELETED;
        EdgeId edgeId = edge.getId();
        TenantId tenantId = edge.getTenantId();
        try {
            this.edgeService.deleteEdge(tenantId, edgeId);
            this.logEntityActionService.logEntityAction(tenantId, edgeId, edge, edge.getCustomerId(), actionType, user, edgeId.toString());
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.EDGE), actionType, user, e, new Object[]{edgeId.toString()});
            throw e;
        }
    }

    @Override
    public Edge assignEdgeToCustomer(TenantId tenantId, EdgeId edgeId, Customer customer, User user) throws ThingsboardException {
        ActionType actionType = ActionType.ASSIGNED_TO_CUSTOMER;
        CustomerId customerId = customer.getId();
        try {
            Edge savedEdge = this.checkNotNull(this.edgeService.assignEdgeToCustomer(tenantId, edgeId, customerId));
            this.logEntityActionService.logEntityAction(tenantId, edgeId, savedEdge, customerId, actionType, user, (Object)edgeId.toString(), (Object)customerId.toString(), (Object)customer.getName());
            return savedEdge;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.EDGE), ActionType.ASSIGNED_TO_CUSTOMER, user, e, new Object[]{edgeId.toString(), customerId.toString()});
            throw e;
        }
    }

    @Override
    public Edge unassignEdgeFromCustomer(Edge edge, Customer customer, User user) throws ThingsboardException {
        ActionType actionType = ActionType.UNASSIGNED_FROM_CUSTOMER;
        TenantId tenantId = edge.getTenantId();
        EdgeId edgeId = edge.getId();
        CustomerId customerId = customer.getId();
        try {
            Edge savedEdge = this.checkNotNull(this.edgeService.unassignEdgeFromCustomer(tenantId, edgeId));
            this.logEntityActionService.logEntityAction(tenantId, edgeId, savedEdge, customerId, actionType, user, (Object)edgeId.toString(), (Object)customerId.toString(), (Object)customer.getName());
            return savedEdge;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.EDGE), ActionType.UNASSIGNED_FROM_CUSTOMER, user, e, new Object[]{edgeId.toString()});
            throw e;
        }
    }

    @Override
    public Edge assignEdgeToPublicCustomer(TenantId tenantId, EdgeId edgeId, User user) throws ThingsboardException {
        ActionType actionType = ActionType.ASSIGNED_TO_CUSTOMER;
        Customer publicCustomer = this.customerService.findOrCreatePublicCustomer(tenantId);
        CustomerId customerId = publicCustomer.getId();
        try {
            Edge savedEdge = this.checkNotNull(this.edgeService.assignEdgeToCustomer(tenantId, edgeId, customerId));
            this.logEntityActionService.logEntityAction(tenantId, edgeId, savedEdge, customerId, actionType, user, (Object)edgeId.toString(), (Object)customerId.toString(), (Object)publicCustomer.getName());
            return savedEdge;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.EDGE), actionType, user, e, new Object[]{edgeId.toString()});
            throw e;
        }
    }

    @Override
    public Edge setEdgeRootRuleChain(Edge edge, RuleChainId ruleChainId, User user) throws Exception {
        TenantId tenantId = edge.getTenantId();
        EdgeId edgeId = edge.getId();
        try {
            Edge updatedEdge = this.edgeService.setEdgeRootRuleChain(tenantId, edge, ruleChainId);
            this.logEntityActionService.logEntityAction(tenantId, edgeId, edge, null, ActionType.UPDATED, user, new Object[0]);
            return updatedEdge;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.EDGE), ActionType.UPDATED, user, e, new Object[]{edgeId.toString()});
            throw e;
        }
    }

    @ConstructorProperties(value={"ruleChainService"})
    @Generated
    public DefaultTbEdgeService(RuleChainService ruleChainService) {
        this.ruleChainService = ruleChainService;
    }
}

