/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.asset.profile;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.asset.AssetProfile;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.AssetProfileId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.asset.AssetProfileService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.asset.profile.TbAssetProfileService;
import org.thingsboard.server.service.security.model.SecurityUser;

@Service
@TbCoreComponent
public class DefaultTbAssetProfileService
extends AbstractTbEntityService
implements TbAssetProfileService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbAssetProfileService.class);
    private final AssetProfileService assetProfileService;

    @Override
    public AssetProfile save(AssetProfile assetProfile, SecurityUser user) throws Exception {
        ActionType actionType = assetProfile.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = assetProfile.getTenantId();
        try {
            AssetProfile savedAssetProfile = this.checkNotNull(this.assetProfileService.saveAssetProfile(assetProfile));
            this.autoCommit(user, (EntityId)savedAssetProfile.getId());
            this.logEntityActionService.logEntityAction(tenantId, savedAssetProfile.getId(), savedAssetProfile, null, actionType, (User)user, new Object[0]);
            return savedAssetProfile;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.ASSET_PROFILE), assetProfile, actionType, (User)user, e, new Object[0]);
            throw e;
        }
    }

    @Override
    public void delete(AssetProfile assetProfile, User user) {
        ActionType actionType = ActionType.DELETED;
        AssetProfileId assetProfileId = assetProfile.getId();
        TenantId tenantId = assetProfile.getTenantId();
        try {
            this.assetProfileService.deleteAssetProfile(tenantId, assetProfileId);
            this.logEntityActionService.logEntityAction(tenantId, assetProfileId, assetProfile, null, actionType, user, assetProfileId.toString());
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.ASSET_PROFILE), actionType, user, e, new Object[]{assetProfileId.toString()});
            throw e;
        }
    }

    @Override
    public AssetProfile setDefaultAssetProfile(AssetProfile assetProfile, AssetProfile previousDefaultAssetProfile, User user) throws ThingsboardException {
        TenantId tenantId = assetProfile.getTenantId();
        AssetProfileId assetProfileId = assetProfile.getId();
        try {
            if (this.assetProfileService.setDefaultAssetProfile(tenantId, assetProfileId)) {
                if (previousDefaultAssetProfile != null) {
                    previousDefaultAssetProfile = this.assetProfileService.findAssetProfileById(tenantId, previousDefaultAssetProfile.getId());
                    this.logEntityActionService.logEntityAction(tenantId, previousDefaultAssetProfile.getId(), previousDefaultAssetProfile, ActionType.UPDATED, user, new Object[0]);
                }
                assetProfile = this.assetProfileService.findAssetProfileById(tenantId, assetProfileId);
                this.logEntityActionService.logEntityAction(tenantId, assetProfileId, assetProfile, ActionType.UPDATED, user, new Object[0]);
            }
            return assetProfile;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.ASSET_PROFILE), ActionType.UPDATED, user, e, new Object[]{assetProfileId.toString()});
            throw e;
        }
    }

    @ConstructorProperties(value={"assetProfileService"})
    @Generated
    public DefaultTbAssetProfileService(AssetProfileService assetProfileService) {
        this.assetProfileService = assetProfileService;
    }
}

