/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edqs;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.transaction.event.TransactionalEventListener;
import org.thingsboard.server.common.data.ObjectType;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.edqs.EdqsObject;
import org.thingsboard.server.common.msg.edqs.EdqsService;
import org.thingsboard.server.dao.eventsourcing.DeleteEntityEvent;
import org.thingsboard.server.dao.eventsourcing.RelationActionEvent;
import org.thingsboard.server.dao.eventsourcing.SaveEntityEvent;

@Service
@ConditionalOnProperty(value={"queue.edqs.sync.enabled"}, havingValue="true")
public class EdqsListener {
    private final EdqsService edqsService;

    @TransactionalEventListener(fallbackExecution=true)
    public void onUpdate(SaveEntityEvent<?> event) {
        if (event.getEntityId() == null || event.getEntity() == null) {
            return;
        }
        this.edqsService.onUpdate(event.getTenantId(), event.getEntityId(), event.getEntity());
    }

    @TransactionalEventListener(fallbackExecution=true)
    public void onDelete(DeleteEntityEvent<?> event) {
        if (event.getEntityId() == null) {
            return;
        }
        this.edqsService.onDelete(event.getTenantId(), event.getEntityId());
    }

    @TransactionalEventListener(fallbackExecution=true)
    public void handleEvent(RelationActionEvent relationEvent) {
        if (relationEvent.getActionType() == ActionType.RELATION_ADD_OR_UPDATE) {
            this.edqsService.onUpdate(relationEvent.getTenantId(), ObjectType.RELATION, (EdqsObject)relationEvent.getRelation());
        } else if (relationEvent.getActionType() == ActionType.RELATION_DELETED) {
            this.edqsService.onDelete(relationEvent.getTenantId(), ObjectType.RELATION, (EdqsObject)relationEvent.getRelation());
        }
    }

    @ConstructorProperties(value={"edqsService"})
    @Generated
    public EdqsListener(EdqsService edqsService) {
        this.edqsService = edqsService;
    }
}

