/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.rule;

import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.util.Pair;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.data.rule.RuleChainMetaData;
import org.thingsboard.server.common.data.rule.RuleChainType;
import org.thingsboard.server.common.data.rule.RuleNode;
import org.thingsboard.server.dao.service.DataValidator;
import org.thingsboard.server.gen.edge.v1.RuleChainMetadataUpdateMsg;
import org.thingsboard.server.gen.edge.v1.RuleChainUpdateMsg;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

public class BaseRuleChainProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseRuleChainProcessor.class);
    @Autowired
    private DataValidator<RuleChain> ruleChainValidator;

    protected Pair<Boolean, Boolean> saveOrUpdateRuleChain(TenantId tenantId, RuleChainId ruleChainId, RuleChainUpdateMsg ruleChainUpdateMsg, RuleChainType ruleChainType) {
        RuleChain ruleChain;
        boolean created = false;
        RuleChain ruleChainFromDb = this.edgeCtx.getRuleChainService().findRuleChainById(tenantId, ruleChainId);
        if (ruleChainFromDb == null) {
            created = true;
        }
        if ((ruleChain = (RuleChain)JacksonUtil.fromString((String)ruleChainUpdateMsg.getEntity(), RuleChain.class, (boolean)true)) == null) {
            throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] ruleChainUpdateMsg {" + String.valueOf(ruleChainUpdateMsg) + "} cannot be converted to rule chain");
        }
        boolean isRoot = ruleChain.isRoot();
        if (RuleChainType.CORE.equals((Object)ruleChainType)) {
            ruleChain.setRoot(false);
        } else {
            ruleChain.setRoot(ruleChainFromDb == null ? false : ruleChainFromDb.isRoot());
        }
        ruleChain.setType(ruleChainType);
        this.ruleChainValidator.validate((BaseData)ruleChain, RuleChain::getTenantId);
        if (created) {
            ruleChain.setId((UUIDBased)ruleChainId);
        }
        this.edgeCtx.getRuleChainService().saveRuleChain(ruleChain, true, false);
        return Pair.of((Object)created, (Object)isRoot);
    }

    protected void saveOrUpdateRuleChainMetadata(TenantId tenantId, RuleChainMetadataUpdateMsg ruleChainMetadataUpdateMsg) {
        RuleChainMetaData ruleChainMetadata = (RuleChainMetaData)JacksonUtil.fromString((String)ruleChainMetadataUpdateMsg.getEntity(), RuleChainMetaData.class, (boolean)true);
        if (ruleChainMetadata == null) {
            throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] ruleChainMetadataUpdateMsg {" + String.valueOf(ruleChainMetadataUpdateMsg) + "} cannot be converted to rule chain metadata");
        }
        if (!ruleChainMetadata.getNodes().isEmpty()) {
            ruleChainMetadata.setVersion(null);
            for (RuleNode ruleNode : ruleChainMetadata.getNodes()) {
                ruleNode.setRuleChainId(null);
                ruleNode.setId(null);
            }
            this.edgeCtx.getRuleChainService().saveRuleChainMetaData(tenantId, ruleChainMetadata, Function.identity(), true);
        }
    }
}

