/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.edge;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

@Component
@TbCoreComponent
public class EdgeEntityProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdgeEntityProcessor.class);

    @Override
    public ListenableFuture<Void> processEntityNotification(TenantId tenantId, TransportProtos.EdgeNotificationMsgProto edgeNotificationMsg) {
        try {
            EdgeId originatorEdgeId = this.safeGetEdgeId(edgeNotificationMsg.getOriginatorEdgeIdMSB(), edgeNotificationMsg.getOriginatorEdgeIdLSB());
            EdgeEventActionType actionType = EdgeEventActionType.valueOf((String)edgeNotificationMsg.getAction());
            EdgeId edgeId = new EdgeId(new UUID(edgeNotificationMsg.getEntityIdMSB(), edgeNotificationMsg.getEntityIdLSB()));
            if (edgeId.equals((Object)originatorEdgeId)) {
                return Futures.immediateFuture(null);
            }
            switch (actionType) {
                case ASSIGNED_TO_CUSTOMER: {
                    PageData pageData;
                    CustomerId customerId = (CustomerId)JacksonUtil.fromString((String)edgeNotificationMsg.getBody(), CustomerId.class);
                    Edge edge = this.edgeCtx.getEdgeService().findEdgeById(tenantId, edgeId);
                    if (customerId != null && (edge == null || customerId.isNullUid())) {
                        return Futures.immediateFuture(null);
                    }
                    ArrayList<ListenableFuture<Void>> futures = new ArrayList<ListenableFuture<Void>>();
                    futures.add(this.saveEdgeEvent(edge.getTenantId(), edge.getId(), EdgeEventType.CUSTOMER, EdgeEventActionType.ADDED, (EntityId)customerId, null));
                    futures.add(this.saveEdgeEvent(edge.getTenantId(), edge.getId(), EdgeEventType.EDGE, EdgeEventActionType.ASSIGNED_TO_CUSTOMER, (EntityId)edgeId, null));
                    PageLink pageLink = new PageLink(1000);
                    do {
                        if ((pageData = this.edgeCtx.getUserService().findCustomerUsers(tenantId, customerId, pageLink)) == null || pageData.getData() == null || pageData.getData().isEmpty()) continue;
                        log.trace("[{}][{}][{}] user(s) are going to be added to edge.", new Object[]{tenantId, edge.getId(), pageData.getData().size()});
                        for (User user : pageData.getData()) {
                            futures.add(this.saveEdgeEvent(edge.getTenantId(), edge.getId(), EdgeEventType.USER, EdgeEventActionType.ADDED, (EntityId)user.getId(), null));
                        }
                        if (!pageData.hasNext()) continue;
                        pageLink = pageLink.nextPageLink();
                    } while (pageData != null && pageData.hasNext());
                    return Futures.transform((ListenableFuture)Futures.allAsList(futures), voids -> null, (Executor)((Object)this.dbCallbackExecutorService));
                }
                case UNASSIGNED_FROM_CUSTOMER: {
                    CustomerId customerIdToDelete = (CustomerId)JacksonUtil.fromString((String)edgeNotificationMsg.getBody(), CustomerId.class);
                    Edge edge = this.edgeCtx.getEdgeService().findEdgeById(tenantId, edgeId);
                    if (customerIdToDelete != null && (edge == null || customerIdToDelete.isNullUid())) {
                        return Futures.immediateFuture(null);
                    }
                    return Futures.transformAsync(this.saveEdgeEvent(edge.getTenantId(), edge.getId(), EdgeEventType.EDGE, EdgeEventActionType.UNASSIGNED_FROM_CUSTOMER, (EntityId)edgeId, null), voids -> this.saveEdgeEvent(edge.getTenantId(), edge.getId(), EdgeEventType.CUSTOMER, EdgeEventActionType.DELETED, (EntityId)customerIdToDelete, null), (Executor)((Object)this.dbCallbackExecutorService));
                }
            }
            return Futures.immediateFuture(null);
        }
        catch (Exception e) {
            log.error("[{}] Exception during processing edge event", (Object)tenantId, (Object)e);
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    @Override
    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        EdgeId edgeId = new EdgeId(edgeEvent.getEntityId());
        switch (edgeEvent.getAction()) {
            case ASSIGNED_TO_CUSTOMER: 
            case UNASSIGNED_FROM_CUSTOMER: {
                Edge edge = this.edgeCtx.getEdgeService().findEdgeById(edgeEvent.getTenantId(), edgeId);
                if (edge == null) break;
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).setEdgeConfiguration(EdgeMsgConstructorUtils.constructEdgeConfiguration(edge)).build();
            }
        }
        return null;
    }

    @Override
    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.EDGE;
    }
}

