/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.dashboard;

import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.Dashboard;
import org.thingsboard.server.common.data.DashboardInfo;
import org.thingsboard.server.common.data.ShortCustomerInfo;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.dao.service.DataValidator;
import org.thingsboard.server.gen.edge.v1.DashboardUpdateMsg;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

public abstract class BaseDashboardProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseDashboardProcessor.class);
    @Autowired
    private DataValidator<Dashboard> dashboardValidator;

    protected boolean saveOrUpdateDashboard(TenantId tenantId, DashboardId dashboardId, DashboardUpdateMsg dashboardUpdateMsg, CustomerId customerId) {
        Dashboard dashboardById;
        boolean created = false;
        Dashboard dashboard = (Dashboard)JacksonUtil.fromString((String)dashboardUpdateMsg.getEntity(), Dashboard.class, (boolean)true);
        if (dashboard == null) {
            throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] dashboardUpdateMsg {" + String.valueOf(dashboardUpdateMsg) + "} cannot be converted to dashboard");
        }
        HashSet<ShortCustomerInfo> newAssignedCustomers = new HashSet<ShortCustomerInfo>();
        if (dashboard.getAssignedCustomers() != null && !dashboard.getAssignedCustomers().isEmpty()) {
            newAssignedCustomers.addAll(dashboard.getAssignedCustomers());
        }
        if ((dashboardById = this.edgeCtx.getDashboardService().findDashboardById(tenantId, dashboardId)) == null) {
            created = true;
            dashboard.setId(null);
            dashboard.setAssignedCustomers(null);
        } else {
            dashboard.setId((UUIDBased)dashboardId);
            dashboard.setAssignedCustomers(dashboardById.getAssignedCustomers());
        }
        this.dashboardValidator.validate((BaseData)dashboard, DashboardInfo::getTenantId);
        if (created) {
            dashboard.setId((UUIDBased)dashboardId);
        }
        Dashboard savedDashboard = this.edgeCtx.getDashboardService().saveDashboard(dashboard, false);
        this.updateDashboardAssignments(tenantId, dashboardById, savedDashboard, newAssignedCustomers);
        return created;
    }

    private void updateDashboardAssignments(TenantId tenantId, Dashboard dashboardById, Dashboard savedDashboard, Set<ShortCustomerInfo> newAssignedCustomers) {
        HashSet<ShortCustomerInfo> currentAssignedCustomers = new HashSet<ShortCustomerInfo>();
        if (dashboardById != null && dashboardById.getAssignedCustomers() != null) {
            currentAssignedCustomers.addAll(dashboardById.getAssignedCustomers());
        }
        newAssignedCustomers = this.filterNonExistingCustomers(tenantId, currentAssignedCustomers, newAssignedCustomers);
        HashSet<CustomerId> addedCustomerIds = new HashSet<CustomerId>();
        HashSet<CustomerId> removedCustomerIds = new HashSet<CustomerId>();
        for (ShortCustomerInfo newAssignedCustomer : newAssignedCustomers) {
            if (savedDashboard.isAssignedToCustomer(newAssignedCustomer.getCustomerId())) continue;
            addedCustomerIds.add(newAssignedCustomer.getCustomerId());
        }
        for (ShortCustomerInfo currentAssignedCustomer : currentAssignedCustomers) {
            if (newAssignedCustomers.contains(currentAssignedCustomer)) continue;
            removedCustomerIds.add(currentAssignedCustomer.getCustomerId());
        }
        for (CustomerId customerIdToAdd : addedCustomerIds) {
            this.edgeCtx.getDashboardService().assignDashboardToCustomer(tenantId, savedDashboard.getId(), customerIdToAdd);
        }
        for (CustomerId customerIdToRemove : removedCustomerIds) {
            this.edgeCtx.getDashboardService().unassignDashboardFromCustomer(tenantId, savedDashboard.getId(), customerIdToRemove);
        }
    }

    protected abstract Set<ShortCustomerInfo> filterNonExistingCustomers(TenantId var1, Set<ShortCustomerInfo> var2, Set<ShortCustomerInfo> var3);
}

