/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.asset;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.util.Pair;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.dao.service.DataValidator;
import org.thingsboard.server.gen.edge.v1.AssetUpdateMsg;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

public abstract class BaseAssetProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseAssetProcessor.class);
    @Autowired
    private DataValidator<Asset> assetValidator;

    protected Pair<Boolean, Boolean> saveOrUpdateAsset(TenantId tenantId, AssetId assetId, AssetUpdateMsg assetUpdateMsg) {
        boolean created = false;
        boolean assetNameUpdated = false;
        assetCreationLock.lock();
        try {
            Asset asset = (Asset)JacksonUtil.fromString((String)assetUpdateMsg.getEntity(), Asset.class, (boolean)true);
            if (asset == null) {
                throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] assetUpdateMsg {" + String.valueOf(assetUpdateMsg) + " } cannot be converted to asset");
            }
            Asset assetById = this.edgeCtx.getAssetService().findAssetById(tenantId, assetId);
            if (assetById == null) {
                created = true;
                asset.setId(null);
            } else {
                asset.setId((UUIDBased)assetId);
            }
            Object assetName = asset.getName();
            Asset assetByName = this.edgeCtx.getAssetService().findAssetByTenantIdAndName(tenantId, (String)assetName);
            if (assetByName != null && !assetByName.getId().equals((Object)assetId)) {
                assetName = (String)assetName + "_" + StringUtils.randomAlphanumeric((int)15);
                log.warn("[{}] Asset with name {} already exists. Renaming asset name to {}", new Object[]{tenantId, asset.getName(), assetName});
                assetNameUpdated = true;
            }
            asset.setName((String)assetName);
            this.setCustomerId(tenantId, created ? null : assetById.getCustomerId(), asset, assetUpdateMsg);
            this.assetValidator.validate((BaseData)asset, Asset::getTenantId);
            if (created) {
                asset.setId((UUIDBased)assetId);
            }
            this.edgeCtx.getAssetService().saveAsset(asset, false);
        }
        catch (Exception e) {
            log.error("[{}] Failed to process asset update msg [{}]", new Object[]{tenantId, assetUpdateMsg, e});
            throw e;
        }
        finally {
            assetCreationLock.unlock();
        }
        return Pair.of((Object)created, (Object)assetNameUpdated);
    }

    protected abstract void setCustomerId(TenantId var1, CustomerId var2, Asset var3, AssetUpdateMsg var4);
}

