/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.asset;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.asset.AssetProfile;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.dao.exception.DataValidationException;
import org.thingsboard.server.gen.edge.v1.AssetUpdateMsg;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.asset.AssetProcessor;
import org.thingsboard.server.service.edge.rpc.processor.asset.BaseAssetProcessor;

@Component
@TbCoreComponent
public class AssetEdgeProcessor
extends BaseAssetProcessor
implements AssetProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetEdgeProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<Void> processAssetMsgFromEdge(TenantId tenantId, Edge edge, AssetUpdateMsg assetUpdateMsg) {
        log.trace("[{}] executing processAssetMsgFromEdge [{}] from edge [{}]", new Object[]{tenantId, assetUpdateMsg, edge.getId()});
        AssetId assetId = new AssetId(new UUID(assetUpdateMsg.getIdMSB(), assetUpdateMsg.getIdLSB()));
        try {
            this.edgeSynchronizationManager.getEdgeId().set(edge.getId());
            switch (assetUpdateMsg.getMsgType()) {
                case ENTITY_CREATED_RPC_MESSAGE: 
                case ENTITY_UPDATED_RPC_MESSAGE: {
                    this.saveOrUpdateAsset(tenantId, assetId, assetUpdateMsg, edge);
                    ListenableFuture listenableFuture = Futures.immediateFuture(null);
                    return listenableFuture;
                }
                case ENTITY_DELETED_RPC_MESSAGE: {
                    Asset assetToDelete = this.edgeCtx.getAssetService().findAssetById(tenantId, assetId);
                    if (assetToDelete != null) {
                        this.edgeCtx.getAssetService().unassignAssetFromEdge(tenantId, assetId, edge.getId());
                    }
                    ListenableFuture listenableFuture = Futures.immediateFuture(null);
                    return listenableFuture;
                }
            }
            ListenableFuture<Void> listenableFuture = this.handleUnsupportedMsgType(assetUpdateMsg.getMsgType());
            return listenableFuture;
        }
        catch (DataValidationException e) {
            if (e.getMessage().contains("limit reached")) {
                log.warn("[{}] Number of allowed asset violated {}", new Object[]{tenantId, assetUpdateMsg, e});
                ListenableFuture listenableFuture = Futures.immediateFuture(null);
                return listenableFuture;
            }
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)e);
            return listenableFuture;
        }
        finally {
            this.edgeSynchronizationManager.getEdgeId().remove();
        }
    }

    private void saveOrUpdateAsset(TenantId tenantId, AssetId assetId, AssetUpdateMsg assetUpdateMsg, Edge edge) {
        Boolean assetNameUpdated;
        Pair<Boolean, Boolean> resultPair = super.saveOrUpdateAsset(tenantId, assetId, assetUpdateMsg);
        Boolean created = (Boolean)resultPair.getFirst();
        if (created.booleanValue()) {
            this.createRelationFromEdge(tenantId, edge.getId(), (EntityId)assetId);
            this.pushAssetCreatedEventToRuleEngine(tenantId, edge, assetId);
            this.edgeCtx.getAssetService().assignAssetToEdge(tenantId, assetId, edge.getId());
        }
        if ((assetNameUpdated = (Boolean)resultPair.getSecond()).booleanValue()) {
            this.saveEdgeEvent(tenantId, edge.getId(), EdgeEventType.ASSET, EdgeEventActionType.UPDATED, (EntityId)assetId, null);
        }
    }

    private void pushAssetCreatedEventToRuleEngine(TenantId tenantId, Edge edge, AssetId assetId) {
        try {
            Asset asset = this.edgeCtx.getAssetService().findAssetById(tenantId, assetId);
            String assetAsString = JacksonUtil.toString((Object)asset);
            TbMsgMetaData msgMetaData = this.getEdgeActionTbMsgMetaData(edge, asset.getCustomerId());
            this.pushEntityEventToRuleEngine(tenantId, (EntityId)assetId, asset.getCustomerId(), TbMsgType.ENTITY_CREATED, assetAsString, msgMetaData);
        }
        catch (Exception e) {
            log.warn("[{}][{}] Failed to push asset action to rule engine: {}", new Object[]{tenantId, assetId, TbMsgType.ENTITY_CREATED.name(), e});
        }
    }

    @Override
    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        AssetId assetId = new AssetId(edgeEvent.getEntityId());
        switch (edgeEvent.getAction()) {
            case ADDED: 
            case UPDATED: 
            case ASSIGNED_TO_EDGE: 
            case ASSIGNED_TO_CUSTOMER: 
            case UNASSIGNED_FROM_CUSTOMER: {
                Asset asset = this.edgeCtx.getAssetService().findAssetById(edgeEvent.getTenantId(), assetId);
                if (asset == null) break;
                UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
                AssetUpdateMsg assetUpdateMsg = EdgeMsgConstructorUtils.constructAssetUpdatedMsg(msgType, asset);
                DownlinkMsg.Builder builder = DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addAssetUpdateMsg(assetUpdateMsg);
                if (UpdateMsgType.ENTITY_CREATED_RPC_MESSAGE.equals((Object)msgType)) {
                    AssetProfile assetProfile = this.edgeCtx.getAssetProfileService().findAssetProfileById(edgeEvent.getTenantId(), asset.getAssetProfileId());
                    builder.addAssetProfileUpdateMsg(EdgeMsgConstructorUtils.constructAssetProfileUpdatedMsg(msgType, assetProfile));
                }
                return builder.build();
            }
            case DELETED: 
            case UNASSIGNED_FROM_EDGE: {
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addAssetUpdateMsg(EdgeMsgConstructorUtils.constructAssetDeleteMsg(assetId)).build();
            }
        }
        return null;
    }

    @Override
    protected void setCustomerId(TenantId tenantId, CustomerId customerId, Asset asset, AssetUpdateMsg assetUpdateMsg) {
        CustomerId customerUUID = asset.getCustomerId() != null ? asset.getCustomerId() : customerId;
        asset.setCustomerId(customerUUID);
    }

    @Override
    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.ASSET;
    }
}

