/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.alarm;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmComment;
import org.thingsboard.server.common.data.alarm.AlarmCreateOrUpdateActiveRequest;
import org.thingsboard.server.common.data.alarm.AlarmUpdateRequest;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageDataIterableByTenantIdEntityId;
import org.thingsboard.server.dao.alarm.AlarmCommentDao;
import org.thingsboard.server.dao.edge.EdgeService;
import org.thingsboard.server.gen.edge.v1.AlarmCommentUpdateMsg;
import org.thingsboard.server.gen.edge.v1.AlarmUpdateMsg;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

public abstract class BaseAlarmProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseAlarmProcessor.class);
    @Autowired
    protected AlarmCommentDao alarmCommentDao;

    public ListenableFuture<Void> processAlarmMsg(TenantId tenantId, AlarmUpdateMsg alarmUpdateMsg) {
        log.trace("[{}] processAlarmMsg [{}]", (Object)tenantId, (Object)alarmUpdateMsg);
        AlarmId alarmId = new AlarmId(new UUID(alarmUpdateMsg.getIdMSB(), alarmUpdateMsg.getIdLSB()));
        Alarm alarm = (Alarm)JacksonUtil.fromString((String)alarmUpdateMsg.getEntity(), Alarm.class, (boolean)true);
        if (alarm == null) {
            throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] alarmUpdateMsg {" + String.valueOf(alarmUpdateMsg) + "} cannot be converted to alarm");
        }
        if (alarm.getOriginator() == null) {
            log.warn("[{}] Originator not found for the alarm msg {}", (Object)tenantId, (Object)alarmUpdateMsg);
            return Futures.immediateFuture(null);
        }
        try {
            switch (alarmUpdateMsg.getMsgType()) {
                case ENTITY_CREATED_RPC_MESSAGE: {
                    this.edgeCtx.getAlarmService().createAlarm(AlarmCreateOrUpdateActiveRequest.fromAlarm((Alarm)alarm, null, (AlarmId)alarmId));
                    break;
                }
                case ENTITY_UPDATED_RPC_MESSAGE: {
                    this.edgeCtx.getAlarmService().updateAlarm(AlarmUpdateRequest.fromAlarm((Alarm)alarm));
                    break;
                }
                case ALARM_ACK_RPC_MESSAGE: {
                    Alarm alarmToAck = this.edgeCtx.getAlarmService().findAlarmById(tenantId, alarmId);
                    if (alarmToAck != null) {
                        this.edgeCtx.getAlarmService().acknowledgeAlarm(tenantId, alarmId, alarm.getAckTs());
                    }
                    break;
                }
                case ALARM_CLEAR_RPC_MESSAGE: {
                    Alarm alarmToClear = this.edgeCtx.getAlarmService().findAlarmById(tenantId, alarmId);
                    if (alarmToClear != null) {
                        this.edgeCtx.getAlarmService().clearAlarm(tenantId, alarmId, alarm.getClearTs(), alarm.getDetails());
                    }
                    break;
                }
                case ENTITY_DELETED_RPC_MESSAGE: {
                    Alarm alarmToDelete = this.edgeCtx.getAlarmService().findAlarmById(tenantId, alarmId);
                    if (alarmToDelete != null) {
                        this.edgeCtx.getAlarmService().delAlarm(tenantId, alarmId);
                    }
                    break;
                }
                default: {
                    return this.handleUnsupportedMsgType(alarmUpdateMsg.getMsgType());
                }
            }
        }
        catch (Exception e) {
            log.error("[{}] Failed to process alarm update msg [{}]", new Object[]{tenantId, alarmUpdateMsg, e});
            return Futures.immediateFailedFuture((Throwable)e);
        }
        return Futures.immediateFuture(null);
    }

    public ListenableFuture<Void> processAlarmCommentMsg(TenantId tenantId, AlarmCommentUpdateMsg alarmCommentUpdateMsg) {
        log.trace("[{}] processAlarmCommentMsg [{}]", (Object)tenantId, (Object)alarmCommentUpdateMsg);
        AlarmComment alarmComment = (AlarmComment)JacksonUtil.fromString((String)alarmCommentUpdateMsg.getEntity(), AlarmComment.class, (boolean)true);
        if (alarmComment == null) {
            throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] alarmCommentUpdateMsg {" + String.valueOf(alarmCommentUpdateMsg) + "} cannot be converted to alarm comment");
        }
        try {
            Alarm alarm = this.edgeCtx.getAlarmService().findAlarmById(tenantId, new AlarmId(alarmComment.getAlarmId().getId()));
            if (alarm == null) {
                return Futures.immediateFuture(null);
            }
            switch (alarmCommentUpdateMsg.getMsgType()) {
                case ENTITY_CREATED_RPC_MESSAGE: {
                    this.alarmCommentDao.save(tenantId, (Object)alarmComment);
                    break;
                }
                case ENTITY_UPDATED_RPC_MESSAGE: {
                    this.edgeCtx.getAlarmCommentService().createOrUpdateAlarmComment(tenantId, alarmComment);
                    break;
                }
                case ENTITY_DELETED_RPC_MESSAGE: {
                    AlarmComment alarmCommentToDelete = this.edgeCtx.getAlarmCommentService().findAlarmCommentById(tenantId, alarmComment.getId());
                    if (alarmCommentToDelete != null) {
                        this.edgeCtx.getAlarmCommentService().saveAlarmComment(tenantId, alarmCommentToDelete);
                    }
                    break;
                }
                default: {
                    return this.handleUnsupportedMsgType(alarmCommentUpdateMsg.getMsgType());
                }
            }
        }
        catch (Exception e) {
            log.error("[{}] Failed to process alarm comment update msg [{}]", new Object[]{tenantId, alarmCommentUpdateMsg, e});
            return Futures.immediateFailedFuture((Throwable)e);
        }
        return Futures.immediateFuture(null);
    }

    protected List<ListenableFuture<Void>> pushEventToAllRelatedEdges(TenantId tenantId, EntityId originatorId, AlarmId alarmId, EdgeEventActionType actionType, JsonNode body, EdgeId sourceEdgeId, EdgeEventType edgeEventType) {
        ArrayList<ListenableFuture<Void>> futures = new ArrayList<ListenableFuture<Void>>();
        PageDataIterableByTenantIdEntityId edgeIds = new PageDataIterableByTenantIdEntityId((arg_0, arg_1, arg_2) -> ((EdgeService)this.edgeCtx.getEdgeService()).findRelatedEdgeIdsByEntityId(arg_0, arg_1, arg_2), tenantId, originatorId, 1000);
        for (EdgeId relatedEdgeId : edgeIds) {
            if (relatedEdgeId.equals((Object)sourceEdgeId)) continue;
            futures.add(this.saveEdgeEvent(tenantId, relatedEdgeId, edgeEventType, actionType, (EntityId)alarmId, body));
        }
        return futures;
    }
}

