/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.instructions;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.thingsboard.server.service.install.InstallScripts;

public abstract class BaseEdgeInstallUpgradeInstructionsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseEdgeInstallUpgradeInstructionsService.class);
    private static final String EDGE_DIR = "edge";
    private static final String INSTRUCTIONS_DIR = "instructions";
    private final InstallScripts installScripts;
    @Value(value="${app.version:unknown}")
    protected String appVersion;

    protected String readFile(Path file) {
        try {
            return Files.readString(file);
        }
        catch (IOException e) {
            log.warn("Failed to read file: {}", (Object)file, (Object)e);
            throw new RuntimeException(e);
        }
    }

    protected String getTagVersion(String version) {
        return version.endsWith(".0") ? version.substring(0, version.length() - 2) : version;
    }

    protected Path resolveFile(String subDir, String ... subDirs) {
        return this.getEdgeInstructionsDir().resolve(Paths.get(subDir, subDirs));
    }

    protected Path getEdgeInstructionsDir() {
        return Paths.get(this.installScripts.getDataDir(), "json", EDGE_DIR, INSTRUCTIONS_DIR, this.getBaseDirName());
    }

    protected abstract String getBaseDirName();

    @ConstructorProperties(value={"installScripts"})
    @Generated
    public BaseEdgeInstallUpgradeInstructionsService(InstallScripts installScripts) {
        this.installScripts = installScripts;
    }

    @Generated
    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }
}

