/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.device;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.GeneratedMessageV3;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.DeviceProfileProvisionType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.device.profile.X509CertificateChainProvisionConfiguration;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.AttributesSaveResult;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.StringDataEntry;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.security.DeviceCredentials;
import org.thingsboard.server.common.data.security.DeviceCredentialsType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.common.transport.util.SslUtil;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.audit.AuditLogService;
import org.thingsboard.server.dao.device.DeviceCredentialsService;
import org.thingsboard.server.dao.device.DeviceProfileService;
import org.thingsboard.server.dao.device.DeviceProvisionService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.device.provision.ProvisionFailedException;
import org.thingsboard.server.dao.device.provision.ProvisionRequest;
import org.thingsboard.server.dao.device.provision.ProvisionResponse;
import org.thingsboard.server.dao.device.provision.ProvisionResponseStatus;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.provider.TbQueueProducerProvider;
import org.thingsboard.server.queue.util.TbCoreComponent;

@Service
@TbCoreComponent
public class DeviceProvisionServiceImpl
implements DeviceProvisionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceProvisionServiceImpl.class);
    protected TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> ruleEngineMsgProducer;
    private static final String DEVICE_PROVISION_STATE = "provisionState";
    private static final String PROVISIONED_STATE = "provisioned";
    private final DeviceProfileService deviceProfileService;
    private final DeviceService deviceService;
    private final DeviceCredentialsService deviceCredentialsService;
    private final AttributesService attributesService;
    private final AuditLogService auditLogService;
    private final PartitionService partitionService;

    public DeviceProvisionServiceImpl(TbQueueProducerProvider producerProvider, DeviceProfileService deviceProfileService, DeviceService deviceService, DeviceCredentialsService deviceCredentialsService, AttributesService attributesService, AuditLogService auditLogService, PartitionService partitionService) {
        this.ruleEngineMsgProducer = producerProvider.getRuleEngineMsgProducer();
        this.deviceProfileService = deviceProfileService;
        this.deviceService = deviceService;
        this.deviceCredentialsService = deviceCredentialsService;
        this.attributesService = attributesService;
        this.auditLogService = auditLogService;
        this.partitionService = partitionService;
    }

    public ProvisionResponse provisionDeviceViaX509Chain(DeviceProfile targetProfile, ProvisionRequest provisionRequest) throws ProvisionFailedException {
        if (targetProfile == null) {
            throw new ProvisionFailedException("Device profile is not specified!");
        }
        if (!DeviceProfileProvisionType.X509_CERTIFICATE_CHAIN.equals((Object)targetProfile.getProfileData().getProvisionConfiguration().getType())) {
            throw new ProvisionFailedException("Device profile provision strategy is not X509_CERTIFICATE_CHAIN!");
        }
        X509CertificateChainProvisionConfiguration configuration = (X509CertificateChainProvisionConfiguration)targetProfile.getProfileData().getProvisionConfiguration();
        String certificateValue = provisionRequest.getCredentialsData().getX509CertHash();
        String certificateRegEx = configuration.getCertificateRegExPattern();
        String commonName = this.getCNFromX509Certificate(targetProfile, certificateValue);
        String deviceName = this.extractDeviceNameFromCNByRegEx(targetProfile, commonName, certificateRegEx);
        provisionRequest.setDeviceName(deviceName);
        Device targetDevice = this.deviceService.findDeviceByTenantIdAndName(targetProfile.getTenantId(), provisionRequest.getDeviceName());
        X509CertificateChainProvisionConfiguration x509Configuration = (X509CertificateChainProvisionConfiguration)targetProfile.getProfileData().getProvisionConfiguration();
        if (targetDevice != null && targetDevice.getDeviceProfileId().equals((Object)targetProfile.getId())) {
            DeviceCredentials deviceCredentials = this.deviceCredentialsService.findDeviceCredentialsByDeviceId(targetDevice.getTenantId(), targetDevice.getId());
            if (DeviceCredentialsType.X509_CERTIFICATE.equals((Object)deviceCredentials.getCredentialsType())) {
                String updatedDeviceCertificateValue = provisionRequest.getCredentialsData().getX509CertHash();
                deviceCredentials = this.updateDeviceCredentials(targetDevice.getTenantId(), deviceCredentials, updatedDeviceCertificateValue, DeviceCredentialsType.X509_CERTIFICATE);
            }
            return new ProvisionResponse(deviceCredentials, ProvisionResponseStatus.SUCCESS);
        }
        if (x509Configuration.isAllowCreateNewDevicesByX509Certificate()) {
            return this.createDevice(provisionRequest, targetProfile);
        }
        log.warn("[{}][{}] Device with name {} doesn't exist and cannot be created due incorrect configuration for X509CertificateChainProvisionConfiguration", new Object[]{targetProfile.getTenantId(), targetProfile.getId(), provisionRequest.getDeviceName()});
        throw new ProvisionFailedException(ProvisionResponseStatus.FAILURE.name());
    }

    public ProvisionResponse provisionDevice(ProvisionRequest provisionRequest) {
        String provisionRequestKey = provisionRequest.getCredentials().getProvisionDeviceKey();
        String provisionRequestSecret = provisionRequest.getCredentials().getProvisionDeviceSecret();
        if (!StringUtils.isEmpty((String)provisionRequest.getDeviceName())) {
            provisionRequest.setDeviceName(provisionRequest.getDeviceName().trim());
            if (StringUtils.isEmpty((String)provisionRequest.getDeviceName())) {
                log.warn("Provision request contains empty device name!");
                throw new ProvisionFailedException(ProvisionResponseStatus.FAILURE.name());
            }
        }
        if (StringUtils.isEmpty((String)provisionRequestKey) || StringUtils.isEmpty((String)provisionRequestSecret)) {
            throw new ProvisionFailedException(ProvisionResponseStatus.NOT_FOUND.name());
        }
        DeviceProfile targetProfile = this.deviceProfileService.findDeviceProfileByProvisionDeviceKey(provisionRequestKey);
        if (targetProfile == null || targetProfile.getProfileData().getProvisionConfiguration() == null || targetProfile.getProfileData().getProvisionConfiguration().getProvisionDeviceSecret() == null) {
            throw new ProvisionFailedException(ProvisionResponseStatus.NOT_FOUND.name());
        }
        Device targetDevice = this.deviceService.findDeviceByTenantIdAndName(targetProfile.getTenantId(), provisionRequest.getDeviceName());
        switch (targetProfile.getProvisionType()) {
            case ALLOW_CREATE_NEW_DEVICES: {
                if (!targetProfile.getProfileData().getProvisionConfiguration().getProvisionDeviceSecret().equals(provisionRequestSecret)) break;
                if (targetDevice != null) {
                    log.warn("[{}] The device is present and could not be provisioned once more!", (Object)targetDevice.getName());
                    this.notify(targetDevice, provisionRequest, TbMsgType.PROVISION_FAILURE, false);
                    throw new ProvisionFailedException(ProvisionResponseStatus.FAILURE.name());
                }
                return this.createDevice(provisionRequest, targetProfile);
            }
            case CHECK_PRE_PROVISIONED_DEVICES: {
                if (!targetProfile.getProfileData().getProvisionConfiguration().getProvisionDeviceSecret().equals(provisionRequestSecret)) break;
                if (targetDevice != null && targetDevice.getDeviceProfileId().equals((Object)targetProfile.getId())) {
                    return this.processProvision(targetDevice, provisionRequest);
                }
                log.warn("[{}] Failed to find pre provisioned device!", (Object)provisionRequest.getDeviceName());
                throw new ProvisionFailedException(ProvisionResponseStatus.FAILURE.name());
            }
            case X509_CERTIFICATE_CHAIN: {
                throw new ProvisionFailedException("Invalid provision strategy type!");
            }
        }
        throw new ProvisionFailedException(ProvisionResponseStatus.NOT_FOUND.name());
    }

    private ProvisionResponse processProvision(Device device, ProvisionRequest provisionRequest) {
        try {
            Optional provisionState = (Optional)this.attributesService.find(device.getTenantId(), (EntityId)device.getId(), AttributeScope.SERVER_SCOPE, DEVICE_PROVISION_STATE).get();
            if (provisionState != null && provisionState.isPresent() && !((AttributeKvEntry)provisionState.get()).getValueAsString().equals(PROVISIONED_STATE)) {
                this.notify(device, provisionRequest, TbMsgType.PROVISION_FAILURE, false);
                throw new ProvisionFailedException(ProvisionResponseStatus.FAILURE.name());
            }
            this.saveProvisionStateAttribute(device).get();
            this.notify(device, provisionRequest, TbMsgType.PROVISION_SUCCESS, true);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ProvisionFailedException(ProvisionResponseStatus.FAILURE.name());
        }
        return new ProvisionResponse(this.deviceCredentialsService.findDeviceCredentialsByDeviceId(device.getTenantId(), device.getId()), ProvisionResponseStatus.SUCCESS);
    }

    private ProvisionResponse createDevice(ProvisionRequest provisionRequest, DeviceProfile profile) {
        return this.processCreateDevice(provisionRequest, profile);
    }

    private void notify(Device device, ProvisionRequest provisionRequest, TbMsgType type, boolean success) {
        this.pushProvisionEventToRuleEngine(provisionRequest, device, type);
        this.logAction(device.getTenantId(), device.getCustomerId(), device, success, provisionRequest);
    }

    private ProvisionResponse processCreateDevice(ProvisionRequest provisionRequest, DeviceProfile profile) {
        try {
            if (StringUtils.isEmpty((String)provisionRequest.getDeviceName())) {
                String newDeviceName = StringUtils.randomAlphanumeric((int)20);
                log.info("Device name not found in provision request. Generated name is: {}", (Object)newDeviceName);
                provisionRequest.setDeviceName(newDeviceName);
            }
            Device savedDevice = this.deviceService.saveDevice(provisionRequest, profile);
            this.saveProvisionStateAttribute(savedDevice).get();
            this.pushDeviceCreatedEventToRuleEngine(savedDevice);
            this.notify(savedDevice, provisionRequest, TbMsgType.PROVISION_SUCCESS, true);
            return new ProvisionResponse(this.getDeviceCredentials(savedDevice), ProvisionResponseStatus.SUCCESS);
        }
        catch (Exception e) {
            log.warn("[{}] Error during device creation from provision request: [{}]", new Object[]{provisionRequest.getDeviceName(), provisionRequest, e});
            Device device = this.deviceService.findDeviceByTenantIdAndName(profile.getTenantId(), provisionRequest.getDeviceName());
            if (device != null) {
                this.notify(device, provisionRequest, TbMsgType.PROVISION_FAILURE, false);
            }
            throw new ProvisionFailedException(ProvisionResponseStatus.FAILURE.name());
        }
    }

    private DeviceCredentials updateDeviceCredentials(TenantId tenantId, DeviceCredentials deviceCredentials, String certificateValue, DeviceCredentialsType credentialsType) {
        log.trace("Updating device credentials [{}] with certificate value [{}]", (Object)deviceCredentials, (Object)certificateValue);
        deviceCredentials.setCredentialsValue(certificateValue);
        deviceCredentials.setCredentialsType(credentialsType);
        return this.deviceCredentialsService.updateDeviceCredentials(tenantId, deviceCredentials);
    }

    private ListenableFuture<AttributesSaveResult> saveProvisionStateAttribute(Device device) {
        return this.attributesService.save(device.getTenantId(), (EntityId)device.getId(), AttributeScope.SERVER_SCOPE, (AttributeKvEntry)new BaseAttributeKvEntry((KvEntry)new StringDataEntry(DEVICE_PROVISION_STATE, PROVISIONED_STATE), System.currentTimeMillis()));
    }

    private DeviceCredentials getDeviceCredentials(Device device) {
        return this.deviceCredentialsService.findDeviceCredentialsByDeviceId(device.getTenantId(), device.getId());
    }

    private void pushProvisionEventToRuleEngine(ProvisionRequest request, Device device, TbMsgType type) {
        try {
            JsonNode entityNode = JacksonUtil.valueToTree((Object)request);
            TbMsg msg = TbMsg.newMsg().type(type).originator((EntityId)device.getId()).customerId(device.getCustomerId()).copyMetaData(this.createTbMsgMetaData(device)).data(JacksonUtil.toString((Object)entityNode)).build();
            this.sendToRuleEngine(device.getTenantId(), msg, null);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Failed to push device action to rule engine: {}", new Object[]{device.getId(), type, e});
        }
    }

    private void pushDeviceCreatedEventToRuleEngine(Device device) {
        try {
            ObjectNode entityNode = (ObjectNode)JacksonUtil.OBJECT_MAPPER.valueToTree((Object)device);
            TbMsg msg = TbMsg.newMsg().type(TbMsgType.ENTITY_CREATED).originator((EntityId)device.getId()).customerId(device.getCustomerId()).copyMetaData(this.createTbMsgMetaData(device)).data(JacksonUtil.OBJECT_MAPPER.writeValueAsString((Object)entityNode)).build();
            this.sendToRuleEngine(device.getTenantId(), msg, null);
        }
        catch (JsonProcessingException | IllegalArgumentException e) {
            log.warn("[{}] Failed to push device action to rule engine: {}", new Object[]{device.getId(), TbMsgType.ENTITY_CREATED.name(), e});
        }
    }

    protected void sendToRuleEngine(TenantId tenantId, TbMsg tbMsg, TbQueueCallback callback) {
        TopicPartitionInfo tpi = this.partitionService.resolve(ServiceType.TB_RULE_ENGINE, tenantId, tbMsg.getOriginator());
        TransportProtos.ToRuleEngineMsg msg = TransportProtos.ToRuleEngineMsg.newBuilder().setTbMsgProto(TbMsg.toProto((TbMsg)tbMsg)).setTenantIdMSB(tenantId.getId().getMostSignificantBits()).setTenantIdLSB(tenantId.getId().getLeastSignificantBits()).build();
        this.ruleEngineMsgProducer.send(tpi, (TbQueueMsg)new TbProtoQueueMsg(tbMsg.getId(), (GeneratedMessageV3)msg), callback);
    }

    private TbMsgMetaData createTbMsgMetaData(Device device) {
        TbMsgMetaData metaData = new TbMsgMetaData();
        metaData.putValue("tenantId", device.getTenantId().toString());
        return metaData;
    }

    private void logAction(TenantId tenantId, CustomerId customerId, Device device, boolean success, ProvisionRequest provisionRequest) {
        ActionType actionType = success ? ActionType.PROVISION_SUCCESS : ActionType.PROVISION_FAILURE;
        this.auditLogService.logEntityAction(tenantId, customerId, new UserId(UserId.NULL_UUID), device.getName(), (EntityId)device.getId(), (HasName)device, actionType, null, new Object[]{provisionRequest});
    }

    private String getCNFromX509Certificate(DeviceProfile profile, String x509Value) {
        try {
            return SslUtil.parseCommonName((X509Certificate)SslUtil.readCertFile((String)x509Value));
        }
        catch (Exception e) {
            log.trace("[{}][{}] Failed to parse CN from X509 certificate {}", new Object[]{profile.getTenantId(), profile.getId(), x509Value});
            return null;
        }
    }

    public String extractDeviceNameFromCNByRegEx(DeviceProfile profile, String commonName, String regex) throws ProvisionFailedException {
        try {
            log.trace("Extract device name from CN [{}] by regex pattern [{}]", (Object)commonName, (Object)regex);
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(commonName);
            if (matcher.find()) {
                return matcher.group(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.trace("[{}][{}] Failed to match device name using [{}] from CN: [{}]", new Object[]{profile.getTenantId(), profile.getId(), regex, commonName});
        throw new ProvisionFailedException(ProvisionResponseStatus.FAILURE.name());
    }
}

