/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.script.api.tbel.TbelCfArg;
import org.thingsboard.script.api.tbel.TbelCfTsDoubleVal;
import org.thingsboard.script.api.tbel.TbelCfTsRollingArg;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntryType;
import org.thingsboard.server.service.cf.ctx.state.SingleValueArgumentEntry;

public class TsRollingArgumentEntry
implements ArgumentEntry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TsRollingArgumentEntry.class);
    private Integer limit;
    private Long timeWindow;
    private TreeMap<Long, Double> tsRecords = new TreeMap();
    private boolean forceResetPrevious;

    public TsRollingArgumentEntry(List<TsKvEntry> kvEntries, int limit, long timeWindow) {
        this.limit = limit;
        this.timeWindow = timeWindow;
        kvEntries.forEach(tsKvEntry -> this.addTsRecord((Long)tsKvEntry.getTs(), (KvEntry)tsKvEntry));
    }

    public TsRollingArgumentEntry(TreeMap<Long, Double> tsRecords, int limit, long timeWindow) {
        this.tsRecords = tsRecords;
        this.limit = limit;
        this.timeWindow = timeWindow;
    }

    public TsRollingArgumentEntry(int limit, long timeWindow) {
        this.tsRecords = new TreeMap();
        this.limit = limit;
        this.timeWindow = timeWindow;
    }

    public TsRollingArgumentEntry(Integer limit, Long timeWindow, TreeMap<Long, Double> tsRecords) {
        this.limit = limit;
        this.timeWindow = timeWindow;
        this.tsRecords = tsRecords;
    }

    @Override
    public ArgumentEntryType getType() {
        return ArgumentEntryType.TS_ROLLING;
    }

    @Override
    public boolean isEmpty() {
        return this.tsRecords.isEmpty();
    }

    @Override
    @JsonIgnore
    public Object getValue() {
        return this.tsRecords;
    }

    @Override
    public TbelCfArg toTbelCfArg() {
        ArrayList<TbelCfTsDoubleVal> values = new ArrayList<TbelCfTsDoubleVal>(this.tsRecords.size());
        for (Map.Entry<Long, Double> e : this.tsRecords.entrySet()) {
            values.add(new TbelCfTsDoubleVal(e.getKey().longValue(), e.getValue().doubleValue()));
        }
        return new TbelCfTsRollingArg(this.timeWindow.longValue(), values);
    }

    @Override
    public boolean updateEntry(ArgumentEntry entry) {
        if (entry instanceof TsRollingArgumentEntry) {
            TsRollingArgumentEntry tsRollingEntry = (TsRollingArgumentEntry)entry;
            this.updateTsRollingEntry(tsRollingEntry);
        } else if (entry instanceof SingleValueArgumentEntry) {
            SingleValueArgumentEntry singleValueEntry = (SingleValueArgumentEntry)entry;
            this.updateSingleValueEntry(singleValueEntry);
        } else {
            throw new IllegalArgumentException("Unsupported argument entry type for rolling argument entry: " + String.valueOf((Object)entry.getType()));
        }
        return true;
    }

    private void updateTsRollingEntry(TsRollingArgumentEntry tsRollingEntry) {
        for (Map.Entry<Long, Double> tsRecordEntry : tsRollingEntry.getTsRecords().entrySet()) {
            this.addTsRecord(tsRecordEntry.getKey(), tsRecordEntry.getValue());
        }
    }

    private void updateSingleValueEntry(SingleValueArgumentEntry singleValueEntry) {
        this.addTsRecord((Long)singleValueEntry.getTs(), (KvEntry)singleValueEntry.getKvEntryValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addTsRecord(Long ts, KvEntry value) {
        try {
            switch (value.getDataType()) {
                case LONG: {
                    value.getLongValue().ifPresent(aLong -> this.tsRecords.put(ts, aLong.doubleValue()));
                    return;
                }
                case DOUBLE: {
                    value.getDoubleValue().ifPresent(aDouble -> this.tsRecords.put(ts, (Double)aDouble));
                    return;
                }
                case BOOLEAN: {
                    value.getBooleanValue().ifPresent(aBoolean -> this.tsRecords.put(ts, aBoolean != false ? 1.0 : 0.0));
                    return;
                }
                case STRING: {
                    value.getStrValue().ifPresent(aString -> this.tsRecords.put(ts, Double.parseDouble(aString)));
                    return;
                }
                case JSON: {
                    value.getJsonValue().ifPresent(aString -> this.tsRecords.put(ts, Double.parseDouble(aString)));
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            this.tsRecords.put(ts, Double.NaN);
            log.debug("Invalid value '{}' for time series rolling arguments. Only numeric values are supported.", value.getValue());
            return;
        }
        finally {
            this.cleanupExpiredRecords();
        }
    }

    private void addTsRecord(Long ts, double value) {
        this.tsRecords.put(ts, value);
        this.cleanupExpiredRecords();
    }

    private void cleanupExpiredRecords() {
        if (this.tsRecords.size() > this.limit) {
            this.tsRecords.pollFirstEntry();
        }
        this.tsRecords.entrySet().removeIf(tsRecord -> (Long)tsRecord.getKey() < System.currentTimeMillis() - this.timeWindow);
    }

    @Generated
    public Integer getLimit() {
        return this.limit;
    }

    @Generated
    public Long getTimeWindow() {
        return this.timeWindow;
    }

    @Generated
    public TreeMap<Long, Double> getTsRecords() {
        return this.tsRecords;
    }

    @Override
    @Generated
    public boolean isForceResetPrevious() {
        return this.forceResetPrevious;
    }

    @Generated
    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    @Generated
    public void setTimeWindow(Long timeWindow) {
        this.timeWindow = timeWindow;
    }

    @Generated
    public void setTsRecords(TreeMap<Long, Double> tsRecords) {
        this.tsRecords = tsRecords;
    }

    @Override
    @Generated
    public void setForceResetPrevious(boolean forceResetPrevious) {
        this.forceResetPrevious = forceResetPrevious;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TsRollingArgumentEntry)) {
            return false;
        }
        TsRollingArgumentEntry other = (TsRollingArgumentEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isForceResetPrevious() != other.isForceResetPrevious()) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Long this$timeWindow = this.getTimeWindow();
        Long other$timeWindow = other.getTimeWindow();
        if (this$timeWindow == null ? other$timeWindow != null : !((Object)this$timeWindow).equals(other$timeWindow)) {
            return false;
        }
        TreeMap<Long, Double> this$tsRecords = this.getTsRecords();
        TreeMap<Long, Double> other$tsRecords = other.getTsRecords();
        return !(this$tsRecords == null ? other$tsRecords != null : !((Object)this$tsRecords).equals(other$tsRecords));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TsRollingArgumentEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isForceResetPrevious() ? 79 : 97);
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Long $timeWindow = this.getTimeWindow();
        result = result * 59 + ($timeWindow == null ? 43 : ((Object)$timeWindow).hashCode());
        TreeMap<Long, Double> $tsRecords = this.getTsRecords();
        result = result * 59 + ($tsRecords == null ? 43 : ((Object)$tsRecords).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TsRollingArgumentEntry(limit=" + this.getLimit() + ", timeWindow=" + this.getTimeWindow() + ", tsRecords=" + String.valueOf(this.getTsRecords()) + ", forceResetPrevious=" + this.isForceResetPrevious() + ")";
    }

    @Generated
    public TsRollingArgumentEntry() {
    }

    @ConstructorProperties(value={"limit", "timeWindow", "tsRecords", "forceResetPrevious"})
    @Generated
    public TsRollingArgumentEntry(Integer limit, Long timeWindow, TreeMap<Long, Double> tsRecords, boolean forceResetPrevious) {
        this.limit = limit;
        this.timeWindow = timeWindow;
        this.tsRecords = tsRecords;
        this.forceResetPrevious = forceResetPrevious;
    }
}

