/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.objecthunter.exp4j.Expression;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.script.api.tbel.TbUtils;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.cf.configuration.Output;
import org.thingsboard.server.common.data.kv.BasicKvEntry;
import org.thingsboard.server.common.data.kv.DataType;
import org.thingsboard.server.service.cf.CalculatedFieldResult;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.BaseCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.cf.ctx.state.SingleValueArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.TsRollingArgumentEntry;

public class SimpleCalculatedFieldState
extends BaseCalculatedFieldState {
    public SimpleCalculatedFieldState(List<String> requiredArguments) {
        super(requiredArguments);
    }

    @Override
    public CalculatedFieldType getType() {
        return CalculatedFieldType.SIMPLE;
    }

    @Override
    protected void validateNewEntry(ArgumentEntry newEntry) {
        if (newEntry instanceof TsRollingArgumentEntry) {
            throw new IllegalArgumentException("Rolling argument entry is not supported for simple calculated fields.");
        }
    }

    @Override
    public ListenableFuture<CalculatedFieldResult> performCalculation(CalculatedFieldCtx ctx) {
        Expression expr = ctx.getCustomExpression().get();
        for (Map.Entry entry : this.arguments.entrySet()) {
            try {
                BasicKvEntry kvEntry = ((SingleValueArgumentEntry)entry.getValue()).getKvEntryValue();
                double value = switch (kvEntry.getDataType()) {
                    default -> throw new IncompatibleClassChangeError();
                    case DataType.LONG -> kvEntry.getLongValue().map(Long::doubleValue).orElseThrow();
                    case DataType.DOUBLE -> (Double)kvEntry.getDoubleValue().orElseThrow();
                    case DataType.BOOLEAN -> kvEntry.getBooleanValue().map(b -> b != false ? 1.0 : 0.0).orElseThrow();
                    case DataType.STRING, DataType.JSON -> Double.parseDouble(kvEntry.getValueAsString());
                };
                expr.setVariable((String)entry.getKey(), value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Argument '" + (String)entry.getKey() + "' is not a number.");
            }
        }
        double expressionResult = expr.evaluate();
        Output output = ctx.getOutput();
        Object result = this.formatResult(expressionResult, output.getDecimalsByDefault());
        JsonNode outputResult = this.createResultJson(ctx.isUseLatestTs(), output.getName(), result);
        return Futures.immediateFuture((Object)new CalculatedFieldResult(output.getType(), output.getScope(), outputResult));
    }

    private Object formatResult(double expressionResult, Integer decimals) {
        if (decimals == null) {
            return expressionResult;
        }
        if (decimals.equals(0)) {
            return TbUtils.toInt((double)expressionResult);
        }
        return TbUtils.toFixed((double)expressionResult, (int)decimals);
    }

    private JsonNode createResultJson(boolean useLatestTs, String outputName, Object result) {
        ObjectNode valuesNode = JacksonUtil.newObjectNode();
        if (result instanceof Double) {
            Double doubleValue = (Double)result;
            valuesNode.put(outputName, doubleValue);
        } else if (result instanceof Integer) {
            Integer integerValue = (Integer)result;
            valuesNode.put(outputName, integerValue);
        } else {
            valuesNode.set(outputName, JacksonUtil.valueToTree((Object)result));
        }
        long latestTs = this.getLatestTimestamp();
        if (useLatestTs && latestTs != -1L) {
            ObjectNode resultNode = JacksonUtil.newObjectNode();
            resultNode.put("ts", latestTs);
            resultNode.set("values", (JsonNode)valuesNode);
            return resultNode;
        }
        return valuesNode;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleCalculatedFieldState)) {
            return false;
        }
        SimpleCalculatedFieldState other = (SimpleCalculatedFieldState)o;
        return other.canEqual(this);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SimpleCalculatedFieldState;
    }

    @Override
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Override
    @Generated
    public String toString() {
        return "SimpleCalculatedFieldState()";
    }

    @Generated
    public SimpleCalculatedFieldState() {
    }
}

