/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state;

import com.google.protobuf.InvalidProtocolBufferException;
import java.beans.ConstructorProperties;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.msg.queue.TbCallback;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.common.consumer.PartitionedQueueConsumerManager;
import org.thingsboard.server.queue.common.state.DefaultQueueStateService;
import org.thingsboard.server.queue.discovery.QueueKey;
import org.thingsboard.server.service.cf.AbstractCalculatedFieldStateService;
import org.thingsboard.server.service.cf.CfRocksDb;
import org.thingsboard.server.service.cf.ctx.CalculatedFieldEntityCtxId;

@Service
@ConditionalOnExpression(value="'${queue.type:null}'=='in-memory'")
public class RocksDBCalculatedFieldStateService
extends AbstractCalculatedFieldStateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RocksDBCalculatedFieldStateService.class);
    private final CfRocksDb cfRocksDb;

    @Override
    public void init(PartitionedQueueConsumerManager<TbProtoQueueMsg<TransportProtos.ToCalculatedFieldMsg>> eventConsumer) {
        this.stateService = new DefaultQueueStateService(eventConsumer);
    }

    @Override
    protected void doPersist(CalculatedFieldEntityCtxId stateId, TransportProtos.CalculatedFieldStateProto stateMsgProto, TbCallback callback) {
        this.cfRocksDb.put(stateId.toKey(), stateMsgProto.toByteArray());
        callback.onSuccess();
    }

    @Override
    protected void doRemove(CalculatedFieldEntityCtxId stateId, TbCallback callback) {
        this.cfRocksDb.delete(stateId.toKey());
        callback.onSuccess();
    }

    @Override
    public void restore(QueueKey queueKey, Set<TopicPartitionInfo> partitions) {
        if (this.stateService.getPartitions().isEmpty()) {
            this.cfRocksDb.forEach((key, value) -> {
                try {
                    this.processRestoredState(TransportProtos.CalculatedFieldStateProto.parseFrom((byte[])value));
                }
                catch (InvalidProtocolBufferException e) {
                    log.error("[{}] Failed to process restored state", key, (Object)e);
                }
            });
        }
        super.restore(queueKey, partitions);
    }

    @ConstructorProperties(value={"cfRocksDb"})
    @Generated
    public RocksDBCalculatedFieldStateService(CfRocksDb cfRocksDb) {
        this.cfRocksDb = cfRocksDb;
    }
}

