/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf;

import com.google.common.util.concurrent.FutureCallback;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.rule.engine.api.AttributesDeleteRequest;
import org.thingsboard.rule.engine.api.AttributesSaveRequest;
import org.thingsboard.rule.engine.api.TimeseriesDeleteRequest;
import org.thingsboard.rule.engine.api.TimeseriesSaveRequest;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.cf.CalculatedFieldLink;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.AttributesSaveResult;
import org.thingsboard.server.common.data.kv.TimeseriesSaveResult;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.util.ProtoUtils;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.TbQueueMsgMetadata;
import org.thingsboard.server.service.cf.CalculatedFieldCache;
import org.thingsboard.server.service.cf.CalculatedFieldQueueService;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.profile.TbAssetProfileCache;
import org.thingsboard.server.service.profile.TbDeviceProfileCache;
import org.thingsboard.server.utils.CalculatedFieldUtils;

@Service
public class DefaultCalculatedFieldQueueService
implements CalculatedFieldQueueService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultCalculatedFieldQueueService.class);
    public static final TbQueueCallback DUMMY_TB_QUEUE_CALLBACK = new TbQueueCallback(){

        public void onSuccess(TbQueueMsgMetadata metadata) {
        }

        public void onFailure(Throwable t) {
        }
    };
    private final TbAssetProfileCache assetProfileCache;
    private final TbDeviceProfileCache deviceProfileCache;
    private final CalculatedFieldCache calculatedFieldCache;
    private final TbClusterService clusterService;
    private static final Set<EntityType> supportedReferencedEntities = EnumSet.of(EntityType.DEVICE, EntityType.ASSET, EntityType.CUSTOMER, EntityType.TENANT);

    @Override
    public void pushRequestToQueue(TimeseriesSaveRequest request, TimeseriesSaveResult result, FutureCallback<Void> callback) {
        TenantId tenantId = request.getTenantId();
        EntityId entityId = request.getEntityId();
        List entries = request.getEntries();
        this.checkEntityAndPushToQueue(tenantId, entityId, cf -> cf.matches(entries), cf -> cf.linkMatches(entityId, entries), () -> this.toCalculatedFieldTelemetryMsgProto(request, result), callback);
    }

    public void pushRequestToQueue(TimeseriesSaveRequest request, FutureCallback<Void> callback) {
        this.pushRequestToQueue(request, null, callback);
    }

    @Override
    public void pushRequestToQueue(AttributesSaveRequest request, AttributesSaveResult result, FutureCallback<Void> callback) {
        TenantId tenantId = request.getTenantId();
        EntityId entityId = request.getEntityId();
        List entries = request.getEntries();
        AttributeScope scope = request.getScope();
        this.checkEntityAndPushToQueue(tenantId, entityId, cf -> cf.matches(entries, scope), cf -> cf.linkMatches(entityId, entries, scope), () -> this.toCalculatedFieldTelemetryMsgProto(request, result), callback);
    }

    public void pushRequestToQueue(AttributesSaveRequest request, FutureCallback<Void> callback) {
        this.pushRequestToQueue(request, null, callback);
    }

    @Override
    public void pushRequestToQueue(AttributesDeleteRequest request, List<String> result, FutureCallback<Void> callback) {
        TenantId tenantId = request.getTenantId();
        EntityId entityId = request.getEntityId();
        AttributeScope scope = request.getScope();
        this.checkEntityAndPushToQueue(tenantId, entityId, cf -> cf.matchesKeys(result, scope), cf -> cf.linkMatchesAttrKeys(entityId, result, scope), () -> this.toCalculatedFieldTelemetryMsgProto(request, result), callback);
    }

    @Override
    public void pushRequestToQueue(TimeseriesDeleteRequest request, List<String> result, FutureCallback<Void> callback) {
        TenantId tenantId = request.getTenantId();
        EntityId entityId = request.getEntityId();
        this.checkEntityAndPushToQueue(tenantId, entityId, cf -> cf.matchesKeys(result), cf -> cf.linkMatchesTsKeys(entityId, result), () -> this.toCalculatedFieldTelemetryMsgProto(request, result), callback);
    }

    private void checkEntityAndPushToQueue(TenantId tenantId, EntityId entityId, Predicate<CalculatedFieldCtx> mainEntityFilter, Predicate<CalculatedFieldCtx> linkedEntityFilter, Supplier<TransportProtos.ToCalculatedFieldMsg> msg, FutureCallback<Void> callback) {
        boolean send;
        if (EntityType.TENANT.equals((Object)entityId.getEntityType())) {
            tenantId = (TenantId)entityId;
        }
        if (send = this.checkEntityForCalculatedFields(tenantId, entityId, mainEntityFilter, linkedEntityFilter)) {
            TransportProtos.ToCalculatedFieldMsg calculatedFieldMsg = msg.get();
            this.clusterService.pushMsgToCalculatedFields(tenantId, entityId, calculatedFieldMsg, DefaultCalculatedFieldQueueService.wrap(callback));
        } else if (callback != null) {
            callback.onSuccess(null);
        }
    }

    private boolean checkEntityForCalculatedFields(TenantId tenantId, EntityId entityId, Predicate<CalculatedFieldCtx> filter, Predicate<CalculatedFieldCtx> linkedEntityFilter) {
        if (!supportedReferencedEntities.contains(entityId.getEntityType())) {
            return false;
        }
        List<CalculatedFieldCtx> entityCfs = this.calculatedFieldCache.getCalculatedFieldCtxsByEntityId(entityId);
        for (CalculatedFieldCtx ctx : entityCfs) {
            if (!filter.test(ctx)) continue;
            return true;
        }
        EntityId profileId = this.getProfileId(tenantId, entityId);
        if (profileId != null) {
            List<CalculatedFieldCtx> profileCfs = this.calculatedFieldCache.getCalculatedFieldCtxsByEntityId(profileId);
            for (CalculatedFieldCtx ctx : profileCfs) {
                if (!filter.test(ctx)) continue;
                return true;
            }
        }
        List<CalculatedFieldLink> links = this.calculatedFieldCache.getCalculatedFieldLinksByEntityId(entityId);
        for (CalculatedFieldLink link : links) {
            CalculatedFieldCtx ctx = this.calculatedFieldCache.getCalculatedFieldCtx(link.getCalculatedFieldId());
            if (ctx == null || !linkedEntityFilter.test(ctx)) continue;
            return true;
        }
        return false;
    }

    private EntityId getProfileId(TenantId tenantId, EntityId entityId) {
        return switch (entityId.getEntityType()) {
            case EntityType.ASSET -> this.assetProfileCache.get(tenantId, (AssetId)entityId).getId();
            case EntityType.DEVICE -> this.deviceProfileCache.get(tenantId, (DeviceId)entityId).getId();
            default -> null;
        };
    }

    private TransportProtos.ToCalculatedFieldMsg toCalculatedFieldTelemetryMsgProto(TimeseriesSaveRequest request, TimeseriesSaveResult result) {
        TransportProtos.CalculatedFieldTelemetryMsgProto.Builder telemetryMsg = this.buildTelemetryMsgProto(request.getTenantId(), request.getEntityId(), request.getPreviousCalculatedFieldIds(), request.getTbMsgId(), request.getTbMsgType());
        List entries = request.getEntries();
        List versions = result != null ? result.getVersions() : Collections.emptyList();
        for (int i = 0; i < entries.size(); ++i) {
            TransportProtos.TsKvProto.Builder tsProtoBuilder = ProtoUtils.toTsKvProto((TsKvEntry)((TsKvEntry)entries.get(i))).toBuilder();
            if (versions != null && !versions.isEmpty() && versions.get(i) != null) {
                tsProtoBuilder.setVersion(((Long)versions.get(i)).longValue());
            }
            telemetryMsg.addTsData(tsProtoBuilder.build());
        }
        return TransportProtos.ToCalculatedFieldMsg.newBuilder().setTelemetryMsg(telemetryMsg).build();
    }

    private TransportProtos.ToCalculatedFieldMsg toCalculatedFieldTelemetryMsgProto(AttributesSaveRequest request, AttributesSaveResult result) {
        TransportProtos.ToCalculatedFieldMsg.Builder msg = TransportProtos.ToCalculatedFieldMsg.newBuilder();
        TransportProtos.CalculatedFieldTelemetryMsgProto.Builder telemetryMsg = this.buildTelemetryMsgProto(request.getTenantId(), request.getEntityId(), request.getPreviousCalculatedFieldIds(), request.getTbMsgId(), request.getTbMsgType());
        telemetryMsg.setScope(TransportProtos.AttributeScopeProto.valueOf((String)request.getScope().name()));
        List entries = request.getEntries();
        List versions = result.versions();
        for (int i = 0; i < entries.size(); ++i) {
            TransportProtos.AttributeValueProto.Builder attrProtoBuilder = ProtoUtils.toProto((AttributeKvEntry)((AttributeKvEntry)entries.get(i))).toBuilder();
            if (versions != null && !versions.isEmpty() && versions.get(i) != null) {
                attrProtoBuilder.setVersion(((Long)versions.get(i)).longValue());
            }
            telemetryMsg.addAttrData(attrProtoBuilder.build());
        }
        msg.setTelemetryMsg(telemetryMsg.build());
        return msg.build();
    }

    private TransportProtos.ToCalculatedFieldMsg toCalculatedFieldTelemetryMsgProto(AttributesDeleteRequest request, List<String> removedKeys) {
        TransportProtos.CalculatedFieldTelemetryMsgProto telemetryMsg = this.buildTelemetryMsgProto(request.getTenantId(), request.getEntityId(), request.getPreviousCalculatedFieldIds(), request.getTbMsgId(), request.getTbMsgType()).setScope(TransportProtos.AttributeScopeProto.valueOf((String)request.getScope().name())).addAllRemovedAttrKeys(removedKeys).build();
        return TransportProtos.ToCalculatedFieldMsg.newBuilder().setTelemetryMsg(telemetryMsg).build();
    }

    private TransportProtos.ToCalculatedFieldMsg toCalculatedFieldTelemetryMsgProto(TimeseriesDeleteRequest request, List<String> removedKeys) {
        TransportProtos.CalculatedFieldTelemetryMsgProto telemetryMsg = this.buildTelemetryMsgProto(request.getTenantId(), request.getEntityId(), request.getPreviousCalculatedFieldIds(), request.getTbMsgId(), request.getTbMsgType()).addAllRemovedTsKeys(removedKeys).build();
        return TransportProtos.ToCalculatedFieldMsg.newBuilder().setTelemetryMsg(telemetryMsg).build();
    }

    private TransportProtos.CalculatedFieldTelemetryMsgProto.Builder buildTelemetryMsgProto(TenantId tenantId, EntityId entityId, List<CalculatedFieldId> calculatedFieldIds, UUID tbMsgId, TbMsgType tbMsgType) {
        TransportProtos.CalculatedFieldTelemetryMsgProto.Builder telemetryMsg = TransportProtos.CalculatedFieldTelemetryMsgProto.newBuilder();
        if (EntityType.TENANT.equals((Object)entityId.getEntityType())) {
            tenantId = (TenantId)entityId;
        }
        telemetryMsg.setTenantIdMSB(tenantId.getId().getMostSignificantBits());
        telemetryMsg.setTenantIdLSB(tenantId.getId().getLeastSignificantBits());
        telemetryMsg.setEntityType(entityId.getEntityType().name());
        telemetryMsg.setEntityIdMSB(entityId.getId().getMostSignificantBits());
        telemetryMsg.setEntityIdLSB(entityId.getId().getLeastSignificantBits());
        if (calculatedFieldIds != null) {
            for (CalculatedFieldId cfId : calculatedFieldIds) {
                telemetryMsg.addPreviousCalculatedFields(CalculatedFieldUtils.toProto(cfId));
            }
        }
        if (tbMsgId != null) {
            telemetryMsg.setTbMsgIdMSB(tbMsgId.getMostSignificantBits());
            telemetryMsg.setTbMsgIdLSB(tbMsgId.getLeastSignificantBits());
        }
        if (tbMsgType != null) {
            telemetryMsg.setTbMsgType(tbMsgType.name());
        }
        return telemetryMsg;
    }

    private static TbQueueCallback wrap(FutureCallback<Void> callback) {
        if (callback != null) {
            return new FutureCallbackWrapper(callback);
        }
        return DUMMY_TB_QUEUE_CALLBACK;
    }

    @ConstructorProperties(value={"assetProfileCache", "deviceProfileCache", "calculatedFieldCache", "clusterService"})
    @Generated
    public DefaultCalculatedFieldQueueService(TbAssetProfileCache assetProfileCache, TbDeviceProfileCache deviceProfileCache, CalculatedFieldCache calculatedFieldCache, TbClusterService clusterService) {
        this.assetProfileCache = assetProfileCache;
        this.deviceProfileCache = deviceProfileCache;
        this.calculatedFieldCache = calculatedFieldCache;
        this.clusterService = clusterService;
    }

    private static class FutureCallbackWrapper
    implements TbQueueCallback {
        private final FutureCallback<Void> callback;

        public FutureCallbackWrapper(FutureCallback<Void> callback) {
            this.callback = callback;
        }

        public void onSuccess(TbQueueMsgMetadata metadata) {
            this.callback.onSuccess(null);
        }

        public void onFailure(Throwable t) {
            this.callback.onFailure(t);
        }
    }
}

