/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldStateRestoreMsg;
import org.thingsboard.server.common.msg.TbActorMsg;
import org.thingsboard.server.common.msg.queue.TbCallback;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.exception.CalculatedFieldStateException;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.common.state.QueueStateService;
import org.thingsboard.server.queue.discovery.QueueKey;
import org.thingsboard.server.service.cf.CalculatedFieldStateService;
import org.thingsboard.server.service.cf.ctx.CalculatedFieldEntityCtxId;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldState;
import org.thingsboard.server.utils.CalculatedFieldUtils;

public abstract class AbstractCalculatedFieldStateService
implements CalculatedFieldStateService {
    @Autowired
    @Lazy
    private ActorSystemContext actorSystemContext;
    protected QueueStateService<TbProtoQueueMsg<TransportProtos.ToCalculatedFieldMsg>, TbProtoQueueMsg<TransportProtos.CalculatedFieldStateProto>> stateService;

    @Override
    public final void persistState(CalculatedFieldEntityCtxId stateId, CalculatedFieldState state, TbCallback callback) {
        if (state.isSizeExceedsLimit()) {
            throw new CalculatedFieldStateException("State size exceeds the maximum allowed limit. The state will not be persisted to RocksDB.");
        }
        this.doPersist(stateId, CalculatedFieldUtils.toProto(stateId, state), callback);
    }

    protected abstract void doPersist(CalculatedFieldEntityCtxId var1, TransportProtos.CalculatedFieldStateProto var2, TbCallback var3);

    @Override
    public final void removeState(CalculatedFieldEntityCtxId stateId, TbCallback callback) {
        this.doRemove(stateId, callback);
    }

    protected abstract void doRemove(CalculatedFieldEntityCtxId var1, TbCallback var2);

    protected void processRestoredState(TransportProtos.CalculatedFieldStateProto stateMsg) {
        CalculatedFieldEntityCtxId id = CalculatedFieldUtils.fromProto(stateMsg.getId());
        CalculatedFieldState state = CalculatedFieldUtils.fromProto(stateMsg);
        this.processRestoredState(id, state);
    }

    protected void processRestoredState(CalculatedFieldEntityCtxId id, CalculatedFieldState state) {
        this.actorSystemContext.tell((TbActorMsg)new CalculatedFieldStateRestoreMsg(id, state));
    }

    @Override
    public void restore(QueueKey queueKey, Set<TopicPartitionInfo> partitions) {
        this.stateService.update(queueKey, partitions, null);
    }

    @Override
    public void delete(Set<TopicPartitionInfo> partitions) {
        this.stateService.delete(partitions);
    }

    @Override
    public Set<TopicPartitionInfo> getPartitions() {
        return this.stateService.getPartitions().values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public void stop() {
        this.stateService.stop();
    }
}

