/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.apiusage;

import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.thingsboard.server.common.data.ApiFeature;
import org.thingsboard.server.common.data.ApiUsageRecordKey;
import org.thingsboard.server.common.data.ApiUsageState;
import org.thingsboard.server.common.data.ApiUsageStateValue;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.tools.SchedulerUtils;

public abstract class BaseApiUsageState {
    private final Map<ApiUsageRecordKey, Long> currentCycleValues = new ConcurrentHashMap<ApiUsageRecordKey, Long>();
    private final Map<ApiUsageRecordKey, Long> currentHourValues = new ConcurrentHashMap<ApiUsageRecordKey, Long>();
    private final Map<ApiUsageRecordKey, Map<String, Long>> lastGaugesByServiceId = new HashMap<ApiUsageRecordKey, Map<String, Long>>();
    private final Map<ApiUsageRecordKey, Long> gaugesReportCycles = new HashMap<ApiUsageRecordKey, Long>();
    private ApiUsageState apiUsageState;
    private volatile long currentCycleTs;
    private volatile long nextCycleTs;
    private volatile long currentHourTs;
    private long gaugeReportInterval;

    public BaseApiUsageState(ApiUsageState apiUsageState) {
        this.apiUsageState = apiUsageState;
        this.currentCycleTs = SchedulerUtils.getStartOfCurrentMonth();
        this.nextCycleTs = SchedulerUtils.getStartOfNextMonth();
        this.currentHourTs = SchedulerUtils.getStartOfCurrentHour();
    }

    public StatsCalculationResult calculate(ApiUsageRecordKey key, long value, String serviceId) {
        StatsCalculationResult result;
        long currentValue = this.get(key);
        long currentHourlyValue = this.getHourly(key);
        if (key.isCounter()) {
            result = StatsCalculationResult.builder().newValue(currentValue + value).valueChanged(true).newHourlyValue(currentHourlyValue + value).hourlyValueChanged(true).build();
        } else {
            Long newGaugeValue = this.calculateGauge(key, value, serviceId);
            long newValue = newGaugeValue != null ? newGaugeValue : currentValue;
            long newHourlyValue = newGaugeValue != null ? Math.max(newGaugeValue, currentHourlyValue) : currentHourlyValue;
            result = StatsCalculationResult.builder().newValue(newValue).valueChanged(newValue != currentValue || !this.currentCycleValues.containsKey(key)).newHourlyValue(newHourlyValue).hourlyValueChanged(newHourlyValue != currentHourlyValue || !this.currentHourValues.containsKey(key)).build();
        }
        this.set(key, result.getNewValue());
        this.setHourly(key, result.getNewHourlyValue());
        return result;
    }

    private Long calculateGauge(ApiUsageRecordKey key, long value, String serviceId) {
        Map lastByServiceId = this.lastGaugesByServiceId.computeIfAbsent(key, k -> {
            this.gaugesReportCycles.put(key, System.currentTimeMillis());
            return new HashMap();
        });
        lastByServiceId.put(serviceId, value);
        Long gaugeReportCycle = this.gaugesReportCycles.get(key);
        if (gaugeReportCycle <= System.currentTimeMillis() - this.gaugeReportInterval) {
            long newValue = lastByServiceId.values().stream().mapToLong(Long::longValue).sum();
            this.lastGaugesByServiceId.remove(key);
            this.gaugesReportCycles.remove(key);
            return newValue;
        }
        return null;
    }

    public void set(ApiUsageRecordKey key, Long value) {
        this.currentCycleValues.put(key, value);
    }

    public long get(ApiUsageRecordKey key) {
        return this.currentCycleValues.getOrDefault(key, 0L);
    }

    public void setHourly(ApiUsageRecordKey key, Long value) {
        this.currentHourValues.put(key, value);
    }

    public long getHourly(ApiUsageRecordKey key) {
        return this.currentHourValues.getOrDefault(key, 0L);
    }

    public void setHour(long currentHourTs) {
        this.currentHourTs = currentHourTs;
        this.currentHourValues.clear();
        this.lastGaugesByServiceId.clear();
        this.gaugesReportCycles.clear();
    }

    public void setCycles(long currentCycleTs, long nextCycleTs) {
        this.currentCycleTs = currentCycleTs;
        this.nextCycleTs = nextCycleTs;
        this.currentCycleValues.clear();
    }

    public void onRepartitionEvent() {
        this.lastGaugesByServiceId.clear();
        this.gaugesReportCycles.clear();
    }

    public ApiUsageStateValue getFeatureValue(ApiFeature feature) {
        switch (feature) {
            case TRANSPORT: {
                return this.apiUsageState.getTransportState();
            }
            case RE: {
                return this.apiUsageState.getReExecState();
            }
            case DB: {
                return this.apiUsageState.getDbStorageState();
            }
            case JS: {
                return this.apiUsageState.getJsExecState();
            }
            case TBEL: {
                return this.apiUsageState.getTbelExecState();
            }
            case EMAIL: {
                return this.apiUsageState.getEmailExecState();
            }
            case SMS: {
                return this.apiUsageState.getSmsExecState();
            }
            case ALARM: {
                return this.apiUsageState.getAlarmExecState();
            }
        }
        return ApiUsageStateValue.ENABLED;
    }

    public boolean setFeatureValue(ApiFeature feature, ApiUsageStateValue value) {
        ApiUsageStateValue currentValue = this.getFeatureValue(feature);
        switch (feature) {
            case TRANSPORT: {
                this.apiUsageState.setTransportState(value);
                break;
            }
            case RE: {
                this.apiUsageState.setReExecState(value);
                break;
            }
            case DB: {
                this.apiUsageState.setDbStorageState(value);
                break;
            }
            case JS: {
                this.apiUsageState.setJsExecState(value);
                break;
            }
            case TBEL: {
                this.apiUsageState.setTbelExecState(value);
                break;
            }
            case EMAIL: {
                this.apiUsageState.setEmailExecState(value);
                break;
            }
            case SMS: {
                this.apiUsageState.setSmsExecState(value);
                break;
            }
            case ALARM: {
                this.apiUsageState.setAlarmExecState(value);
            }
        }
        return !currentValue.equals((Object)value);
    }

    public abstract EntityType getEntityType();

    public TenantId getTenantId() {
        return this.getApiUsageState().getTenantId();
    }

    public EntityId getEntityId() {
        return this.getApiUsageState().getEntityId();
    }

    public String toString() {
        return "BaseApiUsageState{apiUsageState=" + String.valueOf(this.apiUsageState) + ", currentCycleTs=" + this.currentCycleTs + ", nextCycleTs=" + this.nextCycleTs + ", currentHourTs=" + this.currentHourTs + "}";
    }

    @Generated
    public ApiUsageState getApiUsageState() {
        return this.apiUsageState;
    }

    @Generated
    public void setApiUsageState(ApiUsageState apiUsageState) {
        this.apiUsageState = apiUsageState;
    }

    @Generated
    public long getCurrentCycleTs() {
        return this.currentCycleTs;
    }

    @Generated
    public long getNextCycleTs() {
        return this.nextCycleTs;
    }

    @Generated
    public long getCurrentHourTs() {
        return this.currentHourTs;
    }

    @Generated
    public void setGaugeReportInterval(long gaugeReportInterval) {
        this.gaugeReportInterval = gaugeReportInterval;
    }

    public static class StatsCalculationResult {
        private final long newValue;
        private final boolean valueChanged;
        private final long newHourlyValue;
        private final boolean hourlyValueChanged;

        @ConstructorProperties(value={"newValue", "valueChanged", "newHourlyValue", "hourlyValueChanged"})
        @Generated
        StatsCalculationResult(long newValue, boolean valueChanged, long newHourlyValue, boolean hourlyValueChanged) {
            this.newValue = newValue;
            this.valueChanged = valueChanged;
            this.newHourlyValue = newHourlyValue;
            this.hourlyValueChanged = hourlyValueChanged;
        }

        @Generated
        public static StatsCalculationResultBuilder builder() {
            return new StatsCalculationResultBuilder();
        }

        @Generated
        public long getNewValue() {
            return this.newValue;
        }

        @Generated
        public boolean isValueChanged() {
            return this.valueChanged;
        }

        @Generated
        public long getNewHourlyValue() {
            return this.newHourlyValue;
        }

        @Generated
        public boolean isHourlyValueChanged() {
            return this.hourlyValueChanged;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatsCalculationResult)) {
                return false;
            }
            StatsCalculationResult other = (StatsCalculationResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getNewValue() != other.getNewValue()) {
                return false;
            }
            if (this.isValueChanged() != other.isValueChanged()) {
                return false;
            }
            if (this.getNewHourlyValue() != other.getNewHourlyValue()) {
                return false;
            }
            return this.isHourlyValueChanged() == other.isHourlyValueChanged();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof StatsCalculationResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $newValue = this.getNewValue();
            result = result * 59 + (int)($newValue >>> 32 ^ $newValue);
            result = result * 59 + (this.isValueChanged() ? 79 : 97);
            long $newHourlyValue = this.getNewHourlyValue();
            result = result * 59 + (int)($newHourlyValue >>> 32 ^ $newHourlyValue);
            result = result * 59 + (this.isHourlyValueChanged() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "BaseApiUsageState.StatsCalculationResult(newValue=" + this.getNewValue() + ", valueChanged=" + this.isValueChanged() + ", newHourlyValue=" + this.getNewHourlyValue() + ", hourlyValueChanged=" + this.isHourlyValueChanged() + ")";
        }

        @Generated
        public static class StatsCalculationResultBuilder {
            @Generated
            private long newValue;
            @Generated
            private boolean valueChanged;
            @Generated
            private long newHourlyValue;
            @Generated
            private boolean hourlyValueChanged;

            @Generated
            StatsCalculationResultBuilder() {
            }

            @Generated
            public StatsCalculationResultBuilder newValue(long newValue) {
                this.newValue = newValue;
                return this;
            }

            @Generated
            public StatsCalculationResultBuilder valueChanged(boolean valueChanged) {
                this.valueChanged = valueChanged;
                return this;
            }

            @Generated
            public StatsCalculationResultBuilder newHourlyValue(long newHourlyValue) {
                this.newHourlyValue = newHourlyValue;
                return this;
            }

            @Generated
            public StatsCalculationResultBuilder hourlyValueChanged(boolean hourlyValueChanged) {
                this.hourlyValueChanged = hourlyValueChanged;
                return this;
            }

            @Generated
            public StatsCalculationResult build() {
                return new StatsCalculationResult(this.newValue, this.valueChanged, this.newHourlyValue, this.hourlyValueChanged);
            }

            @Generated
            public String toString() {
                return "BaseApiUsageState.StatsCalculationResult.StatsCalculationResultBuilder(newValue=" + this.newValue + ", valueChanged=" + this.valueChanged + ", newHourlyValue=" + this.newHourlyValue + ", hourlyValueChanged=" + this.hourlyValueChanged + ")";
            }
        }
    }
}

