/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.ai;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.vertexai.Transport;
import com.google.cloud.vertexai.VertexAI;
import com.google.cloud.vertexai.api.GenerationConfig;
import com.google.cloud.vertexai.api.PredictionServiceClient;
import com.google.cloud.vertexai.api.PredictionServiceSettings;
import com.google.cloud.vertexai.generativeai.GenerativeModel;
import dev.langchain4j.model.anthropic.AnthropicChatModel;
import dev.langchain4j.model.azure.AzureOpenAiChatModel;
import dev.langchain4j.model.bedrock.BedrockChatModel;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.github.GitHubModelsChatModel;
import dev.langchain4j.model.googleai.GoogleAiGeminiChatModel;
import dev.langchain4j.model.mistralai.MistralAiChatModel;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.model.vertexai.gemini.VertexAiGeminiChatModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.ai.model.chat.AmazonBedrockChatModelConfig;
import org.thingsboard.server.common.data.ai.model.chat.AnthropicChatModelConfig;
import org.thingsboard.server.common.data.ai.model.chat.AzureOpenAiChatModelConfig;
import org.thingsboard.server.common.data.ai.model.chat.GitHubModelsChatModelConfig;
import org.thingsboard.server.common.data.ai.model.chat.GoogleAiGeminiChatModelConfig;
import org.thingsboard.server.common.data.ai.model.chat.GoogleVertexAiGeminiChatModelConfig;
import org.thingsboard.server.common.data.ai.model.chat.Langchain4jChatModelConfigurer;
import org.thingsboard.server.common.data.ai.model.chat.MistralAiChatModelConfig;
import org.thingsboard.server.common.data.ai.model.chat.OpenAiChatModelConfig;
import org.thingsboard.server.common.data.ai.provider.AmazonBedrockProviderConfig;
import org.thingsboard.server.common.data.ai.provider.AzureOpenAiProviderConfig;
import org.thingsboard.server.common.data.ai.provider.GoogleVertexAiGeminiProviderConfig;
import org.threeten.bp.Duration;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClientBuilder;

@Component
class Langchain4jChatModelConfigurerImpl
implements Langchain4jChatModelConfigurer {
    Langchain4jChatModelConfigurerImpl() {
    }

    public ChatModel configureChatModel(OpenAiChatModelConfig chatModelConfig) {
        return OpenAiChatModel.builder().apiKey(chatModelConfig.providerConfig().apiKey()).modelName(chatModelConfig.modelId()).temperature(chatModelConfig.temperature()).topP(chatModelConfig.topP()).frequencyPenalty(chatModelConfig.frequencyPenalty()).presencePenalty(chatModelConfig.presencePenalty()).maxTokens(chatModelConfig.maxOutputTokens()).timeout(Langchain4jChatModelConfigurerImpl.toDuration(chatModelConfig.timeoutSeconds())).maxRetries(chatModelConfig.maxRetries()).build();
    }

    public ChatModel configureChatModel(AzureOpenAiChatModelConfig chatModelConfig) {
        AzureOpenAiProviderConfig providerConfig = chatModelConfig.providerConfig();
        return AzureOpenAiChatModel.builder().endpoint(providerConfig.endpoint()).serviceVersion(providerConfig.serviceVersion()).apiKey(providerConfig.apiKey()).deploymentName(chatModelConfig.modelId()).temperature(chatModelConfig.temperature()).topP(chatModelConfig.topP()).frequencyPenalty(chatModelConfig.frequencyPenalty()).presencePenalty(chatModelConfig.presencePenalty()).maxTokens(chatModelConfig.maxOutputTokens()).timeout(Langchain4jChatModelConfigurerImpl.toDuration(chatModelConfig.timeoutSeconds())).maxRetries(chatModelConfig.maxRetries()).build();
    }

    public ChatModel configureChatModel(GoogleAiGeminiChatModelConfig chatModelConfig) {
        return GoogleAiGeminiChatModel.builder().apiKey(chatModelConfig.providerConfig().apiKey()).modelName(chatModelConfig.modelId()).temperature(chatModelConfig.temperature()).topP(chatModelConfig.topP()).topK(chatModelConfig.topK()).frequencyPenalty(chatModelConfig.frequencyPenalty()).presencePenalty(chatModelConfig.presencePenalty()).maxOutputTokens(chatModelConfig.maxOutputTokens()).timeout(Langchain4jChatModelConfigurerImpl.toDuration(chatModelConfig.timeoutSeconds())).maxRetries(chatModelConfig.maxRetries()).build();
    }

    public ChatModel configureChatModel(GoogleVertexAiGeminiChatModelConfig chatModelConfig) {
        PredictionServiceSettings predictionServiceClientSettings;
        ServiceAccountCredentials serviceAccountCredentials;
        GoogleVertexAiGeminiProviderConfig providerConfig = chatModelConfig.providerConfig();
        try {
            serviceAccountCredentials = ServiceAccountCredentials.fromStream((InputStream)new ByteArrayInputStream(providerConfig.serviceAccountKey().getBytes()));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse service account key JSON", e);
        }
        try {
            PredictionServiceSettings.Builder settingsBuilder = (PredictionServiceSettings.Builder)PredictionServiceSettings.newHttpJsonBuilder().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)serviceAccountCredentials));
            RetrySettings.Builder retrySettings = settingsBuilder.generateContentSettings().getRetrySettings().toBuilder();
            if (chatModelConfig.timeoutSeconds() != null) {
                retrySettings.setTotalTimeout(Duration.ofSeconds((long)chatModelConfig.timeoutSeconds().intValue()));
            }
            settingsBuilder.generateContentSettings().setRetrySettings(retrySettings.build());
            predictionServiceClientSettings = settingsBuilder.build();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create prediction service client settings", e);
        }
        VertexAI vertexAI = new VertexAI.Builder().setProjectId(providerConfig.projectId()).setLocation(providerConfig.location()).setPredictionClientSupplier(() -> Langchain4jChatModelConfigurerImpl.createPredictionServiceClient(predictionServiceClientSettings)).setTransport(Transport.REST).build();
        GenerationConfig.Builder generationConfigBuilder = GenerationConfig.newBuilder();
        if (chatModelConfig.temperature() != null) {
            generationConfigBuilder.setTemperature(chatModelConfig.temperature().floatValue());
        }
        if (chatModelConfig.topP() != null) {
            generationConfigBuilder.setTopP(chatModelConfig.topP().floatValue());
        }
        if (chatModelConfig.topK() != null) {
            generationConfigBuilder.setTopK((float)chatModelConfig.topK().intValue());
        }
        if (chatModelConfig.frequencyPenalty() != null) {
            generationConfigBuilder.setFrequencyPenalty(chatModelConfig.frequencyPenalty().floatValue());
        }
        if (chatModelConfig.frequencyPenalty() != null) {
            generationConfigBuilder.setPresencePenalty(chatModelConfig.frequencyPenalty().floatValue());
        }
        if (chatModelConfig.maxOutputTokens() != null) {
            generationConfigBuilder.setMaxOutputTokens(chatModelConfig.maxOutputTokens().intValue());
        }
        GenerationConfig generationConfig = generationConfigBuilder.build();
        GenerativeModel generativeModel = new GenerativeModel(chatModelConfig.modelId(), vertexAI).withGenerationConfig(generationConfig);
        return new VertexAiGeminiChatModel(generativeModel, generationConfig, chatModelConfig.maxRetries());
    }

    private static PredictionServiceClient createPredictionServiceClient(PredictionServiceSettings settings) {
        try {
            return PredictionServiceClient.create((PredictionServiceSettings)settings);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create prediction service client", e);
        }
    }

    public ChatModel configureChatModel(MistralAiChatModelConfig chatModelConfig) {
        return MistralAiChatModel.builder().apiKey(chatModelConfig.providerConfig().apiKey()).modelName(chatModelConfig.modelId()).temperature(chatModelConfig.temperature()).topP(chatModelConfig.topP()).frequencyPenalty(chatModelConfig.frequencyPenalty()).presencePenalty(chatModelConfig.presencePenalty()).maxTokens(chatModelConfig.maxOutputTokens()).timeout(Langchain4jChatModelConfigurerImpl.toDuration(chatModelConfig.timeoutSeconds())).maxRetries(chatModelConfig.maxRetries()).build();
    }

    public ChatModel configureChatModel(AnthropicChatModelConfig chatModelConfig) {
        return AnthropicChatModel.builder().apiKey(chatModelConfig.providerConfig().apiKey()).modelName(chatModelConfig.modelId()).temperature(chatModelConfig.temperature()).topP(chatModelConfig.topP()).topK(chatModelConfig.topK()).maxTokens(chatModelConfig.maxOutputTokens()).timeout(Langchain4jChatModelConfigurerImpl.toDuration(chatModelConfig.timeoutSeconds())).maxRetries(chatModelConfig.maxRetries()).build();
    }

    public ChatModel configureChatModel(AmazonBedrockChatModelConfig chatModelConfig) {
        AmazonBedrockProviderConfig providerConfig = chatModelConfig.providerConfig();
        StaticCredentialsProvider credentialsProvider = StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)providerConfig.accessKeyId(), (String)providerConfig.secretAccessKey()));
        BedrockRuntimeClient bedrockClient = (BedrockRuntimeClient)((BedrockRuntimeClientBuilder)((BedrockRuntimeClientBuilder)BedrockRuntimeClient.builder().region(Region.of((String)providerConfig.region()))).credentialsProvider((AwsCredentialsProvider)credentialsProvider)).build();
        ChatRequestParameters defaultChatRequestParams = ChatRequestParameters.builder().temperature(chatModelConfig.temperature()).topP(chatModelConfig.topP()).maxOutputTokens(chatModelConfig.maxOutputTokens()).build();
        return ((BedrockChatModel.Builder)((BedrockChatModel.Builder)((BedrockChatModel.Builder)BedrockChatModel.builder().client(bedrockClient).modelId(chatModelConfig.modelId())).defaultRequestParameters(defaultChatRequestParams)).timeout(Langchain4jChatModelConfigurerImpl.toDuration(chatModelConfig.timeoutSeconds()))).maxRetries(chatModelConfig.maxRetries()).build();
    }

    public ChatModel configureChatModel(GitHubModelsChatModelConfig chatModelConfig) {
        return GitHubModelsChatModel.builder().gitHubToken(chatModelConfig.providerConfig().personalAccessToken()).modelName(chatModelConfig.modelId()).temperature(chatModelConfig.temperature()).topP(chatModelConfig.topP()).frequencyPenalty(chatModelConfig.frequencyPenalty()).presencePenalty(chatModelConfig.presencePenalty()).maxTokens(chatModelConfig.maxOutputTokens()).timeout(Langchain4jChatModelConfigurerImpl.toDuration(chatModelConfig.timeoutSeconds())).maxRetries(chatModelConfig.maxRetries()).build();
    }

    private static java.time.Duration toDuration(Integer timeoutSeconds) {
        return timeoutSeconds != null ? java.time.Duration.ofSeconds(timeoutSeconds.intValue()) : null;
    }
}

