/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.ai;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.service.ai.AiRequestsExecutor;

@Lazy
@Component
class DefaultAiRequestsExecutor
implements AiRequestsExecutor {
    private final AiRequestsExecutorProperties properties;
    private ListeningExecutorService executorService;

    @PostConstruct
    private void init() {
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(this.properties.getPoolSize(), (ThreadFactory)ThingsBoardThreadFactory.forName((String)this.properties.getPoolName())));
    }

    @Override
    public FluentFuture<ChatResponse> sendChatRequestAsync(ChatModel chatModel, ChatRequest chatRequest) {
        return FluentFuture.from((ListenableFuture)this.executorService.submit(() -> chatModel.chat(chatRequest)));
    }

    @PreDestroy
    private void destroy() {
        if (this.executorService != null) {
            MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.executorService, (Duration)Duration.ofSeconds(this.properties.getTerminationTimeoutSeconds()));
            this.executorService = null;
        }
    }

    @ConstructorProperties(value={"properties"})
    @Generated
    public DefaultAiRequestsExecutor(AiRequestsExecutorProperties properties) {
        this.properties = properties;
    }

    @Validated
    @Configuration
    @ConfigurationProperties(prefix="actors.rule.ai-requests-thread-pool")
    private static class AiRequestsExecutorProperties {
        @NotBlank(message="Pool name must be not blank")
        private @NotBlank(message="Pool name must be not blank") String poolName = "ai-requests";
        @Min(value=1L, message="Pool size must be at least 1")
        private @Min(value=1L, message="Pool size must be at least 1") int poolSize = 50;
        @Min(value=1L, message="Termination timeout must be at least 1 second")
        private @Min(value=1L, message="Termination timeout must be at least 1 second") int terminationTimeoutSeconds = 60;

        @Generated
        public AiRequestsExecutorProperties() {
        }

        @Generated
        public String getPoolName() {
            return this.poolName;
        }

        @Generated
        public int getPoolSize() {
            return this.poolSize;
        }

        @Generated
        public int getTerminationTimeoutSeconds() {
            return this.terminationTimeoutSeconds;
        }

        @Generated
        public void setPoolName(String poolName) {
            this.poolName = poolName;
        }

        @Generated
        public void setPoolSize(int poolSize) {
            this.poolSize = poolSize;
        }

        @Generated
        public void setTerminationTimeoutSeconds(int terminationTimeoutSeconds) {
            this.terminationTimeoutSeconds = terminationTimeoutSeconds;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AiRequestsExecutorProperties)) {
                return false;
            }
            AiRequestsExecutorProperties other = (AiRequestsExecutorProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPoolSize() != other.getPoolSize()) {
                return false;
            }
            if (this.getTerminationTimeoutSeconds() != other.getTerminationTimeoutSeconds()) {
                return false;
            }
            String this$poolName = this.getPoolName();
            String other$poolName = other.getPoolName();
            return !(this$poolName == null ? other$poolName != null : !this$poolName.equals(other$poolName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AiRequestsExecutorProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPoolSize();
            result = result * 59 + this.getTerminationTimeoutSeconds();
            String $poolName = this.getPoolName();
            result = result * 59 + ($poolName == null ? 43 : $poolName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DefaultAiRequestsExecutor.AiRequestsExecutorProperties(poolName=" + this.getPoolName() + ", poolSize=" + this.getPoolSize() + ", terminationTimeoutSeconds=" + this.getTerminationTimeoutSeconds() + ")";
        }
    }
}

