/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.ai;

import com.google.common.util.concurrent.FluentFuture;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.ai.model.chat.AiChatModelConfig;
import org.thingsboard.server.common.data.ai.model.chat.Langchain4jChatModelConfigurer;
import org.thingsboard.server.service.ai.AiChatModelService;
import org.thingsboard.server.service.ai.AiRequestsExecutor;

@Service
class AiChatModelServiceImpl
implements AiChatModelService {
    private final Langchain4jChatModelConfigurer chatModelConfigurer;
    private final AiRequestsExecutor aiRequestsExecutor;

    public <C extends AiChatModelConfig<C>> FluentFuture<ChatResponse> sendChatRequestAsync(AiChatModelConfig<C> chatModelConfig, ChatRequest chatRequest) {
        ChatModel langChainChatModel = chatModelConfig.configure(this.chatModelConfigurer);
        return this.aiRequestsExecutor.sendChatRequestAsync(langChainChatModel, chatRequest);
    }

    @ConstructorProperties(value={"chatModelConfigurer", "aiRequestsExecutor"})
    @Generated
    public AiChatModelServiceImpl(Langchain4jChatModelConfigurer chatModelConfigurer, AiRequestsExecutor aiRequestsExecutor) {
        this.chatModelConfigurer = chatModelConfigurer;
        this.aiRequestsExecutor = aiRequestsExecutor;
    }
}

