/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.google.common.util.concurrent.FutureCallback;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.controller.HttpValidationCallback;
import org.thingsboard.server.exception.ToErrorResponseEntity;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.ruleengine.RuleEngineCallService;
import org.thingsboard.server.service.security.AccessValidator;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.Operation;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api/rule-engine/"})
public class RuleEngineController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleEngineController.class);
    public static final int DEFAULT_TIMEOUT = 10000;
    private static final String MSG_DESCRIPTION_PREFIX = "Creates the Message with type 'REST_API_REQUEST' and payload taken from the request body. ";
    private static final String MSG_DESCRIPTION = "This method allows you to extend the regular platform API with the power of Rule Engine. You may use default and custom rule nodes to handle the message. The generated message contains two important metadata fields:\n\n * **'serviceId'** to identify the platform server that received the request;\n * **'requestUUID'** to identify the request and route possible response from the Rule Engine;\n\nUse **'rest call reply'** rule node to push the reply from rule engine back as a REST API call response. ";
    @Autowired
    private RuleEngineCallService ruleEngineCallService;
    @Autowired
    private AccessValidator accessValidator;

    @ApiOperation(value="Push user message to the rule engine (handleRuleEngineRequest)", notes="Creates the Message with type 'REST_API_REQUEST' and payload taken from the request body. Uses current User Id ( the one which credentials is used to perform the request) as the Rule Engine message originator. This method allows you to extend the regular platform API with the power of Rule Engine. You may use default and custom rule nodes to handle the message. The generated message contains two important metadata fields:\n\n * **'serviceId'** to identify the platform server that received the request;\n * **'requestUUID'** to identify the request and route possible response from the Rule Engine;\n\nUse **'rest call reply'** rule node to push the reply from rule engine back as a REST API call response. The default timeout of the request processing is 10 seconds.\n\n Security check is performed to verify that the user has 'WRITE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    @ResponseBody
    public DeferredResult<ResponseEntity> handleRuleEngineRequest(@Parameter(description="A JSON value representing the message.", required=true) @RequestBody String requestBody) throws ThingsboardException {
        return this.handleRuleEngineRequest(null, null, null, 10000, requestBody);
    }

    @ApiOperation(value="Push entity message to the rule engine (handleRuleEngineRequest)", notes="Creates the Message with type 'REST_API_REQUEST' and payload taken from the request body. Uses specified Entity Id as the Rule Engine message originator. This method allows you to extend the regular platform API with the power of Rule Engine. You may use default and custom rule nodes to handle the message. The generated message contains two important metadata fields:\n\n * **'serviceId'** to identify the platform server that received the request;\n * **'requestUUID'** to identify the request and route possible response from the Rule Engine;\n\nUse **'rest call reply'** rule node to push the reply from rule engine back as a REST API call response. The default timeout of the request processing is 10 seconds.\n\n Security check is performed to verify that the user has 'WRITE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{entityType}/{entityId}"}, method={RequestMethod.POST})
    @ResponseBody
    public DeferredResult<ResponseEntity> handleRuleEngineRequest(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @PathVariable(value="entityType") String entityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityId") String entityIdStr, @Parameter(description="A JSON value representing the message.", required=true) @RequestBody String requestBody) throws ThingsboardException {
        return this.handleRuleEngineRequest(entityType, entityIdStr, null, 10000, requestBody);
    }

    @ApiOperation(value="Push entity message with timeout to the rule engine (handleRuleEngineRequest)", notes="Creates the Message with type 'REST_API_REQUEST' and payload taken from the request body. Uses specified Entity Id as the Rule Engine message originator. This method allows you to extend the regular platform API with the power of Rule Engine. You may use default and custom rule nodes to handle the message. The generated message contains two important metadata fields:\n\n * **'serviceId'** to identify the platform server that received the request;\n * **'requestUUID'** to identify the request and route possible response from the Rule Engine;\n\nUse **'rest call reply'** rule node to push the reply from rule engine back as a REST API call response. The platform expects the timeout value in milliseconds.\n\n Security check is performed to verify that the user has 'WRITE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{entityType}/{entityId}/{timeout}"}, method={RequestMethod.POST})
    @ResponseBody
    public DeferredResult<ResponseEntity> handleRuleEngineRequest(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @PathVariable(value="entityType") String entityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityId") String entityIdStr, @Parameter(description="Timeout to process the request in milliseconds", required=true) @PathVariable(value="timeout") int timeout, @Parameter(description="A JSON value representing the message.", required=true) @RequestBody String requestBody) throws ThingsboardException {
        return this.handleRuleEngineRequest(entityType, entityIdStr, null, timeout, requestBody);
    }

    @ApiOperation(value="Push entity message with timeout and specified queue to the rule engine (handleRuleEngineRequest)", notes="Creates the Message with type 'REST_API_REQUEST' and payload taken from the request body. Uses specified Entity Id as the Rule Engine message originator. This method allows you to extend the regular platform API with the power of Rule Engine. You may use default and custom rule nodes to handle the message. The generated message contains two important metadata fields:\n\n * **'serviceId'** to identify the platform server that received the request;\n * **'requestUUID'** to identify the request and route possible response from the Rule Engine;\n\nUse **'rest call reply'** rule node to push the reply from rule engine back as a REST API call response. If request sent for Device/Device Profile or Asset/Asset Profile entity, specified queue will be used instead of the queue selected in the device or asset profile. The platform expects the timeout value in milliseconds.\n\n Security check is performed to verify that the user has 'WRITE' permission for the entity (entities).")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{entityType}/{entityId}/{queueName}/{timeout}"}, method={RequestMethod.POST})
    @ResponseBody
    public DeferredResult<ResponseEntity> handleRuleEngineRequest(@Parameter(description="A string value representing the entity type. For example, 'DEVICE'", required=true) @PathVariable(value="entityType") String entityType, @Parameter(description="A string value representing the entity id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="entityId") String entityIdStr, final @Parameter(description="Queue name to process the request in the rule engine", required=true) @PathVariable(value="queueName") String queueName, final @Parameter(description="Timeout to process the request in milliseconds", required=true) @PathVariable(value="timeout") int timeout, @Parameter(description="A JSON value representing the message.", required=true) @RequestBody String requestBody) throws ThingsboardException {
        try {
            SecurityUser currentUser = this.getCurrentUser();
            Object entityId = StringUtils.isEmpty((String)entityType) || StringUtils.isEmpty((String)entityIdStr) ? currentUser.getId() : EntityIdFactory.getByTypeAndId((String)entityType, (String)entityIdStr);
            JacksonUtil.toJsonNode((String)requestBody);
            DeferredResult response = new DeferredResult();
            this.accessValidator.validate(currentUser, Operation.WRITE, (EntityId)entityId, new HttpValidationCallback((DeferredResult<ResponseEntity>)response, new FutureCallback<DeferredResult<ResponseEntity>>(){
                final /* synthetic */ EntityId val$entityId;
                final /* synthetic */ SecurityUser val$currentUser;
                final /* synthetic */ String val$requestBody;
                final /* synthetic */ DeferredResult val$response;
                {
                    this.val$entityId = entityId;
                    this.val$currentUser = securityUser;
                    this.val$requestBody = string2;
                    this.val$response = deferredResult;
                }

                public void onSuccess(@Nullable DeferredResult<ResponseEntity> result) {
                    long expTime = System.currentTimeMillis() + (long)timeout;
                    HashMap<String, String> metaData = new HashMap<String, String>();
                    UUID requestId = UUID.randomUUID();
                    metaData.put("serviceId", RuleEngineController.this.serviceInfoProvider.getServiceId());
                    metaData.put("requestUUID", requestId.toString());
                    metaData.put("expirationTime", Long.toString(expTime));
                    TbMsg msg = TbMsg.newMsg().queueName(queueName).type(TbMsgType.REST_API_REQUEST).originator(this.val$entityId).customerId(this.val$currentUser.getCustomerId()).copyMetaData(new TbMsgMetaData(metaData)).data(this.val$requestBody).build();
                    RuleEngineController.this.ruleEngineCallService.processRestApiCallToRuleEngine(this.val$currentUser.getTenantId(), requestId, msg, queueName != null, reply -> RuleEngineController.this.reply(new LocalRequestMetaData(msg, this.val$currentUser, result), (TbMsg)reply));
                }

                public void onFailure(Throwable e) {
                    ResponseEntity entity = e instanceof ToErrorResponseEntity ? ((ToErrorResponseEntity)((Object)e)).toErrorResponseEntity() : new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
                    RuleEngineController.this.logRuleEngineCall(this.val$currentUser, this.val$entityId, this.val$requestBody, null, e);
                    this.val$response.setResult((Object)entity);
                }
            }));
            return response;
        }
        catch (IllegalArgumentException iae) {
            throw new ThingsboardException("Invalid request body", (Throwable)iae, ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
    }

    private void reply(LocalRequestMetaData rpcRequest, TbMsg response) {
        DeferredResult<ResponseEntity> responseWriter = rpcRequest.responseWriter();
        if (response == null) {
            this.logRuleEngineCall(rpcRequest, null, new TimeoutException("Processing timeout detected!"));
            responseWriter.setResult((Object)new ResponseEntity((HttpStatusCode)HttpStatus.REQUEST_TIMEOUT));
        } else {
            String responseData = response.getData();
            if (!StringUtils.isEmpty((String)responseData)) {
                try {
                    this.logRuleEngineCall(rpcRequest, response, null);
                    responseWriter.setResult((Object)new ResponseEntity((Object)JacksonUtil.toJsonNode((String)responseData), (HttpStatusCode)HttpStatus.OK));
                }
                catch (IllegalArgumentException e) {
                    log.debug("Failed to decode device response: {}", (Object)responseData, (Object)e);
                    this.logRuleEngineCall(rpcRequest, response, e);
                    responseWriter.setResult((Object)new ResponseEntity((HttpStatusCode)HttpStatus.NOT_ACCEPTABLE));
                }
            } else {
                this.logRuleEngineCall(rpcRequest, response, null);
                responseWriter.setResult((Object)new ResponseEntity((HttpStatusCode)HttpStatus.OK));
            }
        }
    }

    private void logRuleEngineCall(LocalRequestMetaData rpcRequest, TbMsg response, Throwable e) {
        this.logRuleEngineCall(rpcRequest.user(), rpcRequest.request().getOriginator(), rpcRequest.request().getData(), response, e);
    }

    private void logRuleEngineCall(SecurityUser user, EntityId entityId, String request, TbMsg response, Throwable e) {
        this.auditLogService.logEntityAction(user.getTenantId(), user.getCustomerId(), user.getId(), user.getName(), entityId, null, ActionType.REST_API_RULE_ENGINE_CALL, BaseController.toException(e), new Object[]{request, response != null ? response.getData() : ""});
    }

    private record LocalRequestMetaData(TbMsg request, SecurityUser user, DeferredResult<ResponseEntity> responseWriter) {
    }
}

