/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.google.common.util.concurrent.FutureCallback;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.annotation.Nullable;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.server.ResponseStatusException;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RpcId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.rpc.Rpc;
import org.thingsboard.server.common.data.rpc.RpcStatus;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.common.msg.ToDeviceActorNotificationMsg;
import org.thingsboard.server.common.msg.rpc.RemoveRpcActorMsg;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.AbstractRpcController;
import org.thingsboard.server.controller.HttpValidationCallback;
import org.thingsboard.server.exception.ToErrorResponseEntity;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.permission.Operation;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api/rpc"})
public class RpcV2Controller
extends AbstractRpcController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RpcV2Controller.class);
    private static final String RPC_REQUEST_DESCRIPTION = "Sends the one-way remote-procedure call (RPC) request to device. The RPC call is A JSON that contains the method name ('method'), parameters ('params') and multiple optional fields. See example below. We will review the properties of the RPC call one-by-one below. \n\n```json\n{\n  \"method\": \"setGpio\",\n  \"params\": {\n    \"pin\": 7,\n    \"value\": 1\n  },\n  \"persistent\": false,\n  \"timeout\": 5000\n}\n```\n\n### Server-side RPC structure\n\nThe body of server-side RPC request consists of multiple fields:\n\n* **method** - mandatory, name of the method to distinct the RPC calls.\n  For example, \"getCurrentTime\" or \"getWeatherForecast\". The value of the parameter is a string.\n* **params** - mandatory, parameters used for processing of the request. The value is a JSON. Leave empty JSON \"{}\" if no parameters needed.\n* **timeout** - optional, value of the processing timeout in milliseconds. The default value is 10000 (10 seconds). The minimum value is 5000 (5 seconds).\n* **expirationTime** - optional, value of the epoch time (in milliseconds, UTC timezone). Overrides **timeout** if present.\n* **persistent** - optional, indicates persistent RPC. The default value is \"false\".\n* **retries** - optional, defines how many times persistent RPC will be re-sent in case of failures on the network and/or device side.\n* **additionalInfo** - optional, defines metadata for the persistent RPC that will be added to the persistent RPC events.";
    private static final String ONE_WAY_RPC_RESULT = "\n\n### RPC Result\nIn case of persistent RPC, the result of this call is 'rpcId' UUID. In case of lightweight RPC, the result of this call is either 200 OK if the message was sent to device, or 504 Gateway Timeout if device is offline.";
    private static final String TWO_WAY_RPC_RESULT = "\n\n### RPC Result\nIn case of persistent RPC, the result of this call is 'rpcId' UUID. In case of lightweight RPC, the result of this call is the response from device, or 504 Gateway Timeout if device is offline.";
    private static final String ONE_WAY_RPC_REQUEST_DESCRIPTION = "Sends the one-way remote-procedure call (RPC) request to device. Sends the one-way remote-procedure call (RPC) request to device. The RPC call is A JSON that contains the method name ('method'), parameters ('params') and multiple optional fields. See example below. We will review the properties of the RPC call one-by-one below. \n\n```json\n{\n  \"method\": \"setGpio\",\n  \"params\": {\n    \"pin\": 7,\n    \"value\": 1\n  },\n  \"persistent\": false,\n  \"timeout\": 5000\n}\n```\n\n### Server-side RPC structure\n\nThe body of server-side RPC request consists of multiple fields:\n\n* **method** - mandatory, name of the method to distinct the RPC calls.\n  For example, \"getCurrentTime\" or \"getWeatherForecast\". The value of the parameter is a string.\n* **params** - mandatory, parameters used for processing of the request. The value is a JSON. Leave empty JSON \"{}\" if no parameters needed.\n* **timeout** - optional, value of the processing timeout in milliseconds. The default value is 10000 (10 seconds). The minimum value is 5000 (5 seconds).\n* **expirationTime** - optional, value of the epoch time (in milliseconds, UTC timezone). Overrides **timeout** if present.\n* **persistent** - optional, indicates persistent RPC. The default value is \"false\".\n* **retries** - optional, defines how many times persistent RPC will be re-sent in case of failures on the network and/or device side.\n* **additionalInfo** - optional, defines metadata for the persistent RPC that will be added to the persistent RPC events.\n\n### RPC Result\nIn case of persistent RPC, the result of this call is 'rpcId' UUID. In case of lightweight RPC, the result of this call is either 200 OK if the message was sent to device, or 504 Gateway Timeout if device is offline.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.";
    private static final String TWO_WAY_RPC_REQUEST_DESCRIPTION = "Sends the two-way remote-procedure call (RPC) request to device. Sends the one-way remote-procedure call (RPC) request to device. The RPC call is A JSON that contains the method name ('method'), parameters ('params') and multiple optional fields. See example below. We will review the properties of the RPC call one-by-one below. \n\n```json\n{\n  \"method\": \"setGpio\",\n  \"params\": {\n    \"pin\": 7,\n    \"value\": 1\n  },\n  \"persistent\": false,\n  \"timeout\": 5000\n}\n```\n\n### Server-side RPC structure\n\nThe body of server-side RPC request consists of multiple fields:\n\n* **method** - mandatory, name of the method to distinct the RPC calls.\n  For example, \"getCurrentTime\" or \"getWeatherForecast\". The value of the parameter is a string.\n* **params** - mandatory, parameters used for processing of the request. The value is a JSON. Leave empty JSON \"{}\" if no parameters needed.\n* **timeout** - optional, value of the processing timeout in milliseconds. The default value is 10000 (10 seconds). The minimum value is 5000 (5 seconds).\n* **expirationTime** - optional, value of the epoch time (in milliseconds, UTC timezone). Overrides **timeout** if present.\n* **persistent** - optional, indicates persistent RPC. The default value is \"false\".\n* **retries** - optional, defines how many times persistent RPC will be re-sent in case of failures on the network and/or device side.\n* **additionalInfo** - optional, defines metadata for the persistent RPC that will be added to the persistent RPC events.\n\n### RPC Result\nIn case of persistent RPC, the result of this call is 'rpcId' UUID. In case of lightweight RPC, the result of this call is the response from device, or 504 Gateway Timeout if device is offline.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.";

    @ApiOperation(value="Send one-way RPC request", notes="Sends the one-way remote-procedure call (RPC) request to device. Sends the one-way remote-procedure call (RPC) request to device. The RPC call is A JSON that contains the method name ('method'), parameters ('params') and multiple optional fields. See example below. We will review the properties of the RPC call one-by-one below. \n\n```json\n{\n  \"method\": \"setGpio\",\n  \"params\": {\n    \"pin\": 7,\n    \"value\": 1\n  },\n  \"persistent\": false,\n  \"timeout\": 5000\n}\n```\n\n### Server-side RPC structure\n\nThe body of server-side RPC request consists of multiple fields:\n\n* **method** - mandatory, name of the method to distinct the RPC calls.\n  For example, \"getCurrentTime\" or \"getWeatherForecast\". The value of the parameter is a string.\n* **params** - mandatory, parameters used for processing of the request. The value is a JSON. Leave empty JSON \"{}\" if no parameters needed.\n* **timeout** - optional, value of the processing timeout in milliseconds. The default value is 10000 (10 seconds). The minimum value is 5000 (5 seconds).\n* **expirationTime** - optional, value of the epoch time (in milliseconds, UTC timezone). Overrides **timeout** if present.\n* **persistent** - optional, indicates persistent RPC. The default value is \"false\".\n* **retries** - optional, defines how many times persistent RPC will be re-sent in case of failures on the network and/or device side.\n* **additionalInfo** - optional, defines metadata for the persistent RPC that will be added to the persistent RPC events.\n\n### RPC Result\nIn case of persistent RPC, the result of this call is 'rpcId' UUID. In case of lightweight RPC, the result of this call is either 200 OK if the message was sent to device, or 504 Gateway Timeout if device is offline.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Persistent RPC request was saved to the database or lightweight RPC request was sent to the device."), @ApiResponse(responseCode="400", description="Invalid structure of the request."), @ApiResponse(responseCode="401", description="User is not authorized to send the RPC request. Most likely, User belongs to different Customer or Tenant."), @ApiResponse(responseCode="413", description="Request payload is too large"), @ApiResponse(responseCode="504", description="Timeout to process the RPC call. Most likely, device is offline.")})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/oneway/{deviceId}"}, method={RequestMethod.POST})
    @ResponseBody
    public DeferredResult<ResponseEntity> handleOneWayDeviceRPCRequest(@Parameter(description="A string value representing the device id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="deviceId") String deviceIdStr, @Parameter(description="A JSON value representing the RPC request.") @RequestBody String requestBody) throws ThingsboardException {
        return this.handleDeviceRPCRequest(true, new DeviceId(UUID.fromString(deviceIdStr)), requestBody, HttpStatus.GATEWAY_TIMEOUT, HttpStatus.GATEWAY_TIMEOUT);
    }

    @ApiOperation(value="Send two-way RPC request", notes="Sends the two-way remote-procedure call (RPC) request to device. Sends the one-way remote-procedure call (RPC) request to device. The RPC call is A JSON that contains the method name ('method'), parameters ('params') and multiple optional fields. See example below. We will review the properties of the RPC call one-by-one below. \n\n```json\n{\n  \"method\": \"setGpio\",\n  \"params\": {\n    \"pin\": 7,\n    \"value\": 1\n  },\n  \"persistent\": false,\n  \"timeout\": 5000\n}\n```\n\n### Server-side RPC structure\n\nThe body of server-side RPC request consists of multiple fields:\n\n* **method** - mandatory, name of the method to distinct the RPC calls.\n  For example, \"getCurrentTime\" or \"getWeatherForecast\". The value of the parameter is a string.\n* **params** - mandatory, parameters used for processing of the request. The value is a JSON. Leave empty JSON \"{}\" if no parameters needed.\n* **timeout** - optional, value of the processing timeout in milliseconds. The default value is 10000 (10 seconds). The minimum value is 5000 (5 seconds).\n* **expirationTime** - optional, value of the epoch time (in milliseconds, UTC timezone). Overrides **timeout** if present.\n* **persistent** - optional, indicates persistent RPC. The default value is \"false\".\n* **retries** - optional, defines how many times persistent RPC will be re-sent in case of failures on the network and/or device side.\n* **additionalInfo** - optional, defines metadata for the persistent RPC that will be added to the persistent RPC events.\n\n### RPC Result\nIn case of persistent RPC, the result of this call is 'rpcId' UUID. In case of lightweight RPC, the result of this call is the response from device, or 504 Gateway Timeout if device is offline.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Persistent RPC request was saved to the database or lightweight RPC response received."), @ApiResponse(responseCode="400", description="Invalid structure of the request."), @ApiResponse(responseCode="401", description="User is not authorized to send the RPC request. Most likely, User belongs to different Customer or Tenant."), @ApiResponse(responseCode="413", description="Request payload is too large"), @ApiResponse(responseCode="504", description="Timeout to process the RPC call. Most likely, device is offline.")})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/twoway/{deviceId}"}, method={RequestMethod.POST})
    @ResponseBody
    public DeferredResult<ResponseEntity> handleTwoWayDeviceRPCRequest(@Parameter(description="A string value representing the device id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'") @PathVariable(value="deviceId") String deviceIdStr, @Parameter(description="A JSON value representing the RPC request.") @RequestBody String requestBody) throws ThingsboardException {
        return this.handleDeviceRPCRequest(false, new DeviceId(UUID.fromString(deviceIdStr)), requestBody, HttpStatus.GATEWAY_TIMEOUT, HttpStatus.GATEWAY_TIMEOUT);
    }

    @ApiOperation(value="Get persistent RPC request", notes="Get information about the status of the RPC call.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/persistent/{rpcId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Rpc getPersistedRpc(@Parameter(description="A string value representing the rpc id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="rpcId") String strRpc) throws ThingsboardException {
        this.checkParameter("RpcId", strRpc);
        RpcId rpcId = new RpcId(UUID.fromString(strRpc));
        return this.checkRpcId(rpcId, Operation.READ);
    }

    @ApiOperation(value="Get persistent RPC requests", notes="Allows to query RPC calls for specific device using pagination.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/persistent/device/{deviceId}"}, method={RequestMethod.GET})
    @ResponseBody
    public DeferredResult<ResponseEntity> getPersistedRpcByDevice(@Parameter(description="A string value representing the device id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="deviceId") String strDeviceId, @Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, final @Parameter(description="Status of the RPC", schema=@Schema(allowableValues={"QUEUED", "SENT", "DELIVERED", "SUCCESSFUL", "TIMEOUT", "EXPIRED", "FAILED"})) @RequestParam(required=false) RpcStatus rpcStatus, @Parameter(description="Not implemented. Leave empty.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "expirationTime", "request", "response"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        this.checkParameter("DeviceId", strDeviceId);
        if (rpcStatus != null && rpcStatus.equals((Object)RpcStatus.DELETED)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "RpcStatus: DELETED");
        }
        final TenantId tenantId = this.getCurrentUser().getTenantId();
        final PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        final DeviceId deviceId = new DeviceId(UUID.fromString(strDeviceId));
        final DeferredResult response = new DeferredResult();
        this.accessValidator.validate(this.getCurrentUser(), Operation.RPC_CALL, (EntityId)deviceId, new HttpValidationCallback((DeferredResult<ResponseEntity>)response, new FutureCallback<DeferredResult<ResponseEntity>>(){

            public void onSuccess(@Nullable DeferredResult<ResponseEntity> result) {
                PageData rpcCalls = rpcStatus != null ? RpcV2Controller.this.rpcService.findAllByDeviceIdAndStatus(tenantId, deviceId, rpcStatus, pageLink) : RpcV2Controller.this.rpcService.findAllByDeviceId(tenantId, deviceId, pageLink);
                response.setResult((Object)new ResponseEntity((Object)rpcCalls, (HttpStatusCode)HttpStatus.OK));
            }

            public void onFailure(Throwable e) {
                ResponseEntity entity = e instanceof ToErrorResponseEntity ? ((ToErrorResponseEntity)((Object)e)).toErrorResponseEntity() : new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
                response.setResult((Object)entity);
            }
        }));
        return response;
    }

    @ApiOperation(value="Delete persistent RPC", notes="Deletes the persistent RPC request.\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/persistent/{rpcId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteRpc(@Parameter(description="A string value representing the rpc id. For example, '784f394c-42b6-435a-983c-b7beff2784f9'", required=true) @PathVariable(value="rpcId") String strRpc) throws ThingsboardException {
        this.checkParameter("RpcId", strRpc);
        RpcId rpcId = new RpcId(UUID.fromString(strRpc));
        Rpc rpc = this.checkRpcId(rpcId, Operation.DELETE);
        if (rpc != null) {
            if (rpc.getStatus().isPushDeleteNotificationToCore()) {
                RemoveRpcActorMsg removeMsg = new RemoveRpcActorMsg(this.getTenantId(), rpc.getDeviceId(), rpc.getUuidId());
                log.trace("[{}] Forwarding msg {} to queue actor!", (Object)rpc.getDeviceId(), (Object)rpc);
                this.tbClusterService.pushMsgToCore((ToDeviceActorNotificationMsg)removeMsg, null);
            }
            this.rpcService.deleteRpc(this.getTenantId(), rpcId);
            rpc.setStatus(RpcStatus.DELETED);
            TbMsg msg = TbMsg.newMsg().type(TbMsgType.RPC_DELETED).originator((EntityId)rpc.getDeviceId()).copyMetaData(TbMsgMetaData.EMPTY).data(JacksonUtil.toString((Object)rpc)).build();
            this.tbClusterService.pushMsgToRuleEngine(this.getTenantId(), (EntityId)rpc.getDeviceId(), msg, null);
        }
    }
}

