/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.net.URISyntaxException;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.mobile.app.MobileApp;
import org.thingsboard.server.common.data.mobile.app.StoreInfo;
import org.thingsboard.server.common.data.mobile.qrCodeSettings.QrCodeSettings;
import org.thingsboard.server.common.data.oauth2.PlatformType;
import org.thingsboard.server.common.data.security.model.JwtPair;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.mobile.QrCodeSettingService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.mobile.secret.MobileAppSecretService;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.Operation;
import org.thingsboard.server.service.security.permission.Resource;
import org.thingsboard.server.service.security.system.SystemSecurityService;

@RestController
@TbCoreComponent
public class QrCodeSettingsController
extends BaseController {
    @Value(value="${cache.specs.mobileSecretKey.timeToLiveInMinutes:2}")
    private int mobileSecretKeyTtl;
    @Value(value="${mobileApp.domain:demo.thingsboard.io}")
    private String defaultAppDomain;
    public static final String ASSET_LINKS_PATTERN = "[{\n  \"relation\": [\"delegate_permission/common.handle_all_urls\"],\n  \"target\": {\n    \"namespace\": \"android_app\",\n    \"package_name\": \"%s\",\n    \"sha256_cert_fingerprints\":\n    [\"%s\"]\n  }\n}]";
    public static final String APPLE_APP_SITE_ASSOCIATION_PATTERN = "{\n    \"applinks\": {\n        \"apps\": [],\n        \"details\": [\n            {\n                \"appID\": \"%s\",\n                \"paths\": [ \"/api/noauth/qr\" ]\n            }\n        ]\n    }\n}";
    public static final String SECRET = "secret";
    public static final String SECRET_PARAM_DESCRIPTION = "A string value representing short-lived secret key";
    public static final String DEEP_LINK_PATTERN = "https://%s/api/noauth/qr?secret=%s&ttl=%s";
    private final SystemSecurityService systemSecurityService;
    private final MobileAppSecretService mobileAppSecretService;
    private final QrCodeSettingService qrCodeSettingService;

    @ApiOperation(value="Get associated android applications (getAssetLinks)")
    @GetMapping(value={"/.well-known/assetlinks.json"})
    public ResponseEntity<JsonNode> getAssetLinks() {
        StoreInfo storeInfo;
        MobileApp mobileApp = this.qrCodeSettingService.findAppFromQrCodeSettings(TenantId.SYS_TENANT_ID, PlatformType.ANDROID);
        StoreInfo storeInfo2 = storeInfo = mobileApp != null ? mobileApp.getStoreInfo() : null;
        if (storeInfo != null && storeInfo.getSha256CertFingerprints() != null) {
            return ResponseEntity.ok((Object)JacksonUtil.toJsonNode((String)String.format(ASSET_LINKS_PATTERN, mobileApp.getPkgName(), storeInfo.getSha256CertFingerprints())));
        }
        return ResponseEntity.notFound().build();
    }

    @ApiOperation(value="Get associated ios applications (getAppleAppSiteAssociation)")
    @GetMapping(value={"/.well-known/apple-app-site-association"})
    public ResponseEntity<JsonNode> getAppleAppSiteAssociation() {
        StoreInfo storeInfo;
        MobileApp mobileApp = this.qrCodeSettingService.findAppFromQrCodeSettings(TenantId.SYS_TENANT_ID, PlatformType.IOS);
        StoreInfo storeInfo2 = storeInfo = mobileApp != null ? mobileApp.getStoreInfo() : null;
        if (storeInfo != null && storeInfo.getAppId() != null) {
            return ResponseEntity.ok((Object)JacksonUtil.toJsonNode((String)String.format(APPLE_APP_SITE_ASSOCIATION_PATTERN, storeInfo.getAppId())));
        }
        return ResponseEntity.notFound().build();
    }

    @ApiOperation(value="Create Or Update the Mobile application settings (saveMobileAppSettings)", notes="The request payload contains configuration for android/iOS applications and platform qr code widget settings.\n\nAvailable for users with 'SYS_ADMIN' authority.")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN')")
    @PostMapping(value={"/api/mobile/qr/settings"})
    public QrCodeSettings saveQrCodeSettings(@Parameter(description="A JSON value representing the mobile apps configuration") @RequestBody QrCodeSettings qrCodeSettings) throws ThingsboardException {
        SecurityUser currentUser = this.getCurrentUser();
        this.accessControlService.checkPermission(currentUser, Resource.MOBILE_APP_SETTINGS, Operation.WRITE);
        qrCodeSettings.setTenantId(this.getTenantId());
        return this.qrCodeSettingService.saveQrCodeSettings(currentUser.getTenantId(), qrCodeSettings);
    }

    @ApiOperation(value="Get Mobile application settings (getMobileAppSettings)", notes="The response payload contains configuration for android/iOS applications and platform qr code widget settings.\n\nAvailable for any authorized user. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/api/mobile/qr/settings"})
    public QrCodeSettings getQrCodeSettings() throws ThingsboardException {
        SecurityUser currentUser = this.getCurrentUser();
        this.accessControlService.checkPermission(currentUser, Resource.MOBILE_APP_SETTINGS, Operation.READ);
        return this.qrCodeSettingService.findQrCodeSettings(TenantId.SYS_TENANT_ID);
    }

    @ApiOperation(value="Get the deep link to the associated mobile application (getMobileAppDeepLink)", notes="Fetch the url that takes user to linked mobile application \n\nAvailable for any authorized user. ")
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/api/mobile/qr/deepLink"}, produces={"text/plain"})
    public String getMobileAppDeepLink(HttpServletRequest request) throws ThingsboardException, URISyntaxException {
        String secret = this.mobileAppSecretService.generateMobileAppSecret(this.getCurrentUser());
        String baseUrl = this.systemSecurityService.getBaseUrl(TenantId.SYS_TENANT_ID, null, request);
        String platformDomain = new URI(baseUrl).getHost();
        QrCodeSettings qrCodeSettings = this.qrCodeSettingService.findQrCodeSettings(TenantId.SYS_TENANT_ID);
        String appDomain = qrCodeSettings.isUseDefaultApp() ? this.defaultAppDomain : platformDomain;
        Object deepLink = String.format(DEEP_LINK_PATTERN, appDomain, secret, this.mobileSecretKeyTtl);
        if (!appDomain.equals(platformDomain)) {
            deepLink = (String)deepLink + "&host=" + baseUrl;
        }
        return "\"" + (String)deepLink + "\"";
    }

    @ApiOperation(value="Get User Token (getUserTokenByMobileSecret)", notes="Returns the token of the User based on the provided secret key.")
    @GetMapping(value={"/api/noauth/qr/{secret}"})
    public JwtPair getUserTokenByMobileSecret(@Parameter(description="A string value representing short-lived secret key") @PathVariable(value="secret") String secret) throws ThingsboardException {
        this.checkParameter(SECRET, secret);
        return this.mobileAppSecretService.getJwtPair(secret);
    }

    @GetMapping(value={"/api/noauth/qr"})
    public ResponseEntity<?> getApplicationRedirect(@RequestHeader(value="User-Agent") String userAgent) {
        QrCodeSettings qrCodeSettings = this.qrCodeSettingService.findQrCodeSettings(TenantId.SYS_TENANT_ID);
        if (userAgent.contains("Android") && qrCodeSettings.isAndroidEnabled()) {
            String googlePlayLink = qrCodeSettings.getGooglePlayLink();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.FOUND).header("Location", new String[]{googlePlayLink})).build();
        }
        if ((userAgent.contains("iPhone") || userAgent.contains("iPad")) && qrCodeSettings.isIosEnabled()) {
            String appStoreLink = qrCodeSettings.getAppStoreLink();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.FOUND).header("Location", new String[]{appStoreLink})).build();
        }
        return this.response(HttpStatus.NOT_FOUND);
    }

    @ConstructorProperties(value={"systemSecurityService", "mobileAppSecretService", "qrCodeSettingService"})
    @Generated
    public QrCodeSettingsController(SystemSecurityService systemSecurityService, MobileAppSecretService mobileAppSecretService, QrCodeSettingService qrCodeSettingService) {
        this.systemSecurityService = systemSecurityService;
        this.mobileAppSecretService = mobileAppSecretService;
        this.qrCodeSettingService = qrCodeSettingService;
    }
}

