/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.io.ByteArrayOutputStream;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.thingsboard.server.common.data.ImageDescriptor;
import org.thingsboard.server.common.data.ResourceExportData;
import org.thingsboard.server.common.data.ResourceSubType;
import org.thingsboard.server.common.data.ResourceType;
import org.thingsboard.server.common.data.TbImageDeleteResult;
import org.thingsboard.server.common.data.TbResource;
import org.thingsboard.server.common.data.TbResourceInfo;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.common.data.util.ThrowingSupplier;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.resource.ImageCacheKey;
import org.thingsboard.server.dao.resource.ImageService;
import org.thingsboard.server.dao.service.validator.ResourceDataValidator;
import org.thingsboard.server.dao.util.ImageUtils;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.resource.TbImageService;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.Operation;
import org.thingsboard.server.service.security.permission.Resource;

@RestController
@TbCoreComponent
public class ImageController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImageController.class);
    private final ImageService imageService;
    private final TbImageService tbImageService;
    private final ResourceDataValidator resourceValidator;
    @Value(value="${cache.image.systemImagesBrowserTtlInMinutes:0}")
    private int systemImagesBrowserTtlInMinutes;
    @Value(value="${cache.image.tenantImagesBrowserTtlInMinutes:0}")
    private int tenantImagesBrowserTtlInMinutes;
    private static final String IMAGE_URL = "/api/images/{type}/{key}";
    private static final String SYSTEM_IMAGE = "system";
    private static final String TENANT_IMAGE = "tenant";
    private static final String IMAGE_TYPE_PARAM_DESCRIPTION = "Type of the image: tenant or system";
    private static final String IMAGE_TYPE_PARAM_ALLOWABLE_VALUES = "tenant, system";
    private static final String IMAGE_KEY_PARAM_DESCRIPTION = "Image resource key, for example thermostats_dashboard_background.jpeg";

    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @PostMapping(value={"/api/image"}, consumes={"multipart/form-data"})
    public TbResourceInfo uploadImage(@RequestPart MultipartFile file, @RequestPart(required=false) String title, @RequestPart(required=false) String imageSubType) throws Exception {
        SecurityUser user = this.getCurrentUser();
        TbResource image = new TbResource();
        image.setTenantId(user.getTenantId());
        this.accessControlService.checkPermission(user, Resource.TB_RESOURCE, Operation.CREATE, null, image);
        this.resourceValidator.validateResourceSize(user.getTenantId(), null, file.getSize());
        image.setFileName(file.getOriginalFilename());
        if (StringUtils.isNotEmpty((CharSequence)title)) {
            image.setTitle(title);
        } else {
            image.setTitle(file.getOriginalFilename());
        }
        ResourceSubType subType = ResourceSubType.IMAGE;
        if (StringUtils.isNotEmpty((CharSequence)imageSubType)) {
            subType = ResourceSubType.valueOf((String)imageSubType);
        }
        image.setResourceType(ResourceType.IMAGE);
        image.setResourceSubType(subType);
        ImageDescriptor descriptor = new ImageDescriptor();
        descriptor.setMediaType(file.getContentType());
        image.setDescriptorValue((Object)descriptor);
        image.setData(file.getBytes());
        image.setPublic(true);
        return this.tbImageService.save(image, user);
    }

    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @PutMapping(value={"/api/images/{type}/{key}"}, consumes={"multipart/form-data"})
    public TbResourceInfo updateImage(@Parameter(description="Type of the image: tenant or system", schema=@Schema(allowableValues={"tenant", "system"}), required=true) @PathVariable String type, @Parameter(description="Image resource key, for example thermostats_dashboard_background.jpeg", required=true) @PathVariable String key, @RequestPart MultipartFile file) throws Exception {
        TbResourceInfo imageInfo = this.checkImageInfo(type, key, Operation.WRITE);
        this.resourceValidator.validateResourceSize(this.getTenantId(), imageInfo.getId(), file.getSize());
        TbResource image = new TbResource(imageInfo);
        image.setData(file.getBytes());
        image.setFileName(file.getOriginalFilename());
        image.updateDescriptor(ImageDescriptor.class, descriptor -> {
            descriptor.setMediaType(file.getContentType());
            return descriptor;
        });
        return this.tbImageService.save(image, this.getCurrentUser());
    }

    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @PutMapping(value={"/api/images/{type}/{key}/info"})
    public TbResourceInfo updateImageInfo(@Parameter(description="Type of the image: tenant or system", schema=@Schema(allowableValues={"tenant", "system"}), required=true) @PathVariable String type, @Parameter(description="Image resource key, for example thermostats_dashboard_background.jpeg", required=true) @PathVariable String key, @RequestBody TbResourceInfo request) throws ThingsboardException {
        TbResourceInfo imageInfo = this.checkImageInfo(type, key, Operation.WRITE);
        TbResourceInfo newImageInfo = new TbResourceInfo(imageInfo);
        newImageInfo.setTitle(request.getTitle());
        return this.tbImageService.save(newImageInfo, imageInfo, this.getCurrentUser());
    }

    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @PutMapping(value={"/api/images/{type}/{key}/public/{isPublic}"})
    public TbResourceInfo updateImagePublicStatus(@Parameter(description="Type of the image: tenant or system", schema=@Schema(allowableValues={"tenant", "system"}), required=true) @PathVariable String type, @Parameter(description="Image resource key, for example thermostats_dashboard_background.jpeg", required=true) @PathVariable String key, @PathVariable boolean isPublic) throws ThingsboardException {
        TbResourceInfo imageInfo = this.checkImageInfo(type, key, Operation.WRITE);
        TbResourceInfo newImageInfo = new TbResourceInfo(imageInfo);
        newImageInfo.setPublic(isPublic);
        return this.tbImageService.save(newImageInfo, imageInfo, this.getCurrentUser());
    }

    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/api/images/{type}/{key}"}, produces={"image/*"})
    public ResponseEntity<ByteArrayResource> downloadImage(@Parameter(description="Type of the image: tenant or system", schema=@Schema(allowableValues={"tenant", "system"}), required=true) @PathVariable String type, @Parameter(description="Image resource key, for example thermostats_dashboard_background.jpeg", required=true) @PathVariable String key, @RequestHeader(name="If-None-Match", required=false) String etag, @RequestHeader(name="Accept-Encoding", required=false) String acceptEncodingHeader) throws Exception {
        return this.downloadIfChanged(type, key, etag, acceptEncodingHeader, false);
    }

    @GetMapping(value={"/api/images/public/{publicResourceKey}"}, produces={"image/*"})
    public ResponseEntity<ByteArrayResource> downloadPublicImage(@PathVariable String publicResourceKey, @RequestHeader(name="If-None-Match", required=false) String etag, @RequestHeader(name="Accept-Encoding", required=false) String acceptEncodingHeader) throws Exception {
        ImageCacheKey cacheKey = ImageCacheKey.forPublicImage((String)publicResourceKey);
        return this.downloadIfChanged(cacheKey, etag, acceptEncodingHeader, (ThrowingSupplier<TbResourceInfo>)((ThrowingSupplier)() -> this.imageService.getPublicImageInfoByKey(publicResourceKey)));
    }

    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @GetMapping(value={"/api/images/{type}/{key}/export"})
    public ResourceExportData exportImage(@Parameter(description="Type of the image: tenant or system", schema=@Schema(allowableValues={"tenant", "system"}), required=true) @PathVariable String type, @Parameter(description="Image resource key, for example thermostats_dashboard_background.jpeg", required=true) @PathVariable String key) throws Exception {
        TbResourceInfo imageInfo = this.checkImageInfo(type, key, Operation.READ);
        return this.imageService.exportImage(imageInfo);
    }

    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @PutMapping(value={"/api/image/import"})
    public TbResourceInfo importImage(@RequestBody ResourceExportData imageData) throws Exception {
        SecurityUser user = this.getCurrentUser();
        return this.tbImageService.importImage(imageData, false, user);
    }

    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN', 'CUSTOMER_USER')")
    @GetMapping(value={"/api/images/{type}/{key}/preview"}, produces={"image/png"})
    public ResponseEntity<ByteArrayResource> downloadImagePreview(@Parameter(description="Type of the image: tenant or system", schema=@Schema(allowableValues={"tenant", "system"}), required=true) @PathVariable String type, @Parameter(description="Image resource key, for example thermostats_dashboard_background.jpeg", required=true) @PathVariable String key, @RequestHeader(name="If-None-Match", required=false) String etag, @RequestHeader(name="Accept-Encoding", required=false) String acceptEncodingHeader) throws Exception {
        return this.downloadIfChanged(type, key, etag, acceptEncodingHeader, true);
    }

    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @GetMapping(value={"/api/images/{type}/{key}/info"})
    public TbResourceInfo getImageInfo(@Parameter(description="Type of the image: tenant or system", schema=@Schema(allowableValues={"tenant", "system"}), required=true) @PathVariable String type, @Parameter(description="Image resource key, for example thermostats_dashboard_background.jpeg", required=true) @PathVariable String key) throws ThingsboardException {
        return this.checkImageInfo(type, key, Operation.READ);
    }

    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @GetMapping(value={"/api/images"})
    public PageData<TbResourceInfo> getImages(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="A string value representing resource sub-type.", schema=@Schema(allowableValues={"IMAGE", "SCADA_SYMBOL"})) @RequestParam(required=false) String imageSubType, @Parameter(description="Use 'true' to include system images. Disabled by default. Ignored for requests by users with system administrator authority.") @RequestParam(required=false) boolean includeSystemImages, @Parameter(description="The case insensitive 'substring' filter based on the resource title.") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by", schema=@Schema(allowableValues={"createdTime", "title", "resourceType", "tenantId"})) @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)", schema=@Schema(allowableValues={"ASC", "DESC"})) @RequestParam(required=false) String sortOrder) throws ThingsboardException {
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        TenantId tenantId = this.getTenantId();
        ResourceSubType subType = ResourceSubType.IMAGE;
        if (StringUtils.isNotEmpty((CharSequence)imageSubType)) {
            subType = ResourceSubType.valueOf((String)imageSubType);
        }
        if (this.getCurrentUser().getAuthority() == Authority.SYS_ADMIN || !includeSystemImages) {
            return this.checkNotNull(this.imageService.getImagesByTenantId(tenantId, subType, pageLink));
        }
        return this.checkNotNull(this.imageService.getAllImagesByTenantId(tenantId, subType, pageLink));
    }

    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    @DeleteMapping(value={"/api/images/{type}/{key}"})
    public ResponseEntity<TbImageDeleteResult> deleteImage(@Parameter(description="Type of the image: tenant or system", schema=@Schema(allowableValues={"tenant", "system"}), required=true) @PathVariable String type, @Parameter(description="Image resource key, for example thermostats_dashboard_background.jpeg", required=true) @PathVariable String key, @RequestParam(name="force", required=false) boolean force) throws ThingsboardException {
        TbResourceInfo imageInfo = this.checkImageInfo(type, key, Operation.DELETE);
        TbImageDeleteResult result = this.tbImageService.delete(imageInfo, this.getCurrentUser(), force);
        return (result.isSuccess() ? ResponseEntity.ok() : ResponseEntity.badRequest()).body((Object)result);
    }

    private ResponseEntity<ByteArrayResource> downloadIfChanged(String type, String key, String etag, String acceptEncodingHeader, boolean preview) throws Exception {
        ImageCacheKey cacheKey = ImageCacheKey.forImage((TenantId)this.getTenantId(type), (String)key, (boolean)preview);
        return this.downloadIfChanged(cacheKey, etag, acceptEncodingHeader, (ThrowingSupplier<TbResourceInfo>)((ThrowingSupplier)() -> this.checkImageInfo(type, key, Operation.READ)));
    }

    private ResponseEntity<ByteArrayResource> downloadIfChanged(ImageCacheKey cacheKey, String etag, String acceptEncodingHeader, ThrowingSupplier<TbResourceInfo> imageInfoSupplier) throws Exception {
        byte[] data;
        if (StringUtils.isNotEmpty((CharSequence)etag) && (etag = StringUtils.remove((String)etag, (char)'\"')).equals(this.tbImageService.getETag(cacheKey))) {
            return this.response(HttpStatus.NOT_MODIFIED);
        }
        TbResourceInfo imageInfo = this.checkNotNull((TbResourceInfo)imageInfoSupplier.get());
        String fileName = imageInfo.getFileName();
        ImageDescriptor descriptor = (ImageDescriptor)imageInfo.getDescriptor(ImageDescriptor.class);
        if (cacheKey.isPreview()) {
            descriptor = descriptor.getPreviewDescriptor();
            data = this.imageService.getImagePreview(imageInfo.getTenantId(), imageInfo.getId());
        } else {
            data = this.imageService.getImageData(imageInfo.getTenantId(), imageInfo.getId());
        }
        this.tbImageService.putETag(cacheKey, descriptor.getEtag());
        ResponseEntity.BodyBuilder result = (ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", new String[]{descriptor.getMediaType()})).eTag(descriptor.getEtag());
        if (!cacheKey.isPublic()) {
            ((ResponseEntity.BodyBuilder)result.header("Content-Disposition", new String[]{"attachment;filename=" + fileName})).header("x-filename", new String[]{fileName});
        }
        if (this.systemImagesBrowserTtlInMinutes > 0 && imageInfo.getTenantId().isSysTenantId()) {
            result.cacheControl(CacheControl.maxAge((long)this.systemImagesBrowserTtlInMinutes, (TimeUnit)TimeUnit.MINUTES));
        } else if (this.tenantImagesBrowserTtlInMinutes > 0 && !imageInfo.getTenantId().isSysTenantId()) {
            result.cacheControl(CacheControl.maxAge((long)this.tenantImagesBrowserTtlInMinutes, (TimeUnit)TimeUnit.MINUTES));
        } else {
            result.cacheControl(CacheControl.noCache());
        }
        byte[] responseData = data;
        if (ImageUtils.mediaTypeToFileExtension((String)descriptor.getMediaType()).equals("svg") && StringUtils.isNotEmpty((CharSequence)acceptEncodingHeader) && acceptEncodingHeader.contains("gzip")) {
            result.header("Content-Encoding", new String[]{"gzip"});
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream);){
                gzipOutputStream.write(data);
                gzipOutputStream.finish();
            }
            responseData = outputStream.toByteArray();
        }
        result.contentLength((long)responseData.length);
        return result.body((Object)new ByteArrayResource(responseData));
    }

    private TbResourceInfo checkImageInfo(String imageType, String key, Operation operation) throws ThingsboardException {
        TenantId tenantId = this.getTenantId(imageType);
        TbResourceInfo imageInfo = this.imageService.getImageInfoByTenantIdAndKey(tenantId, key);
        this.checkEntity(this.getCurrentUser(), this.checkNotNull(imageInfo), operation);
        return imageInfo;
    }

    private TenantId getTenantId(String imageType) throws ThingsboardException {
        TenantId tenantId;
        if (imageType.equals(TENANT_IMAGE)) {
            tenantId = this.getTenantId();
        } else if (imageType.equals(SYSTEM_IMAGE)) {
            tenantId = TenantId.SYS_TENANT_ID;
        } else {
            throw new IllegalArgumentException("Invalid image URL");
        }
        return tenantId;
    }

    @ConstructorProperties(value={"imageService", "tbImageService", "resourceValidator"})
    @Generated
    public ImageController(ImageService imageService, TbImageService tbImageService, ResourceDataValidator resourceValidator) {
        this.imageService = imageService;
        this.tbImageService = tbImageService;
        this.resourceValidator = resourceValidator;
    }
}

