/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.FutureCallback;
import jakarta.annotation.Nullable;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.context.request.async.DeferredResult;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.rpc.RpcError;
import org.thingsboard.server.common.data.rpc.ToDeviceRpcRequestBody;
import org.thingsboard.server.common.msg.rpc.FromDeviceRpcResponse;
import org.thingsboard.server.common.msg.rpc.ToDeviceRpcRequest;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.controller.HttpValidationCallback;
import org.thingsboard.server.exception.ToErrorResponseEntity;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.rpc.LocalRequestMetaData;
import org.thingsboard.server.service.rpc.TbCoreDeviceRpcService;
import org.thingsboard.server.service.security.AccessValidator;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.Operation;

@TbCoreComponent
public abstract class AbstractRpcController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractRpcController.class);
    @Autowired
    protected TbCoreDeviceRpcService deviceRpcService;
    @Autowired
    protected AccessValidator accessValidator;
    @Value(value="${server.rest.server_side_rpc.min_timeout:5000}")
    protected long minTimeout;
    @Value(value="${server.rest.server_side_rpc.default_timeout:10000}")
    protected long defaultTimeout;

    protected DeferredResult<ResponseEntity> handleDeviceRPCRequest(final boolean oneWay, final DeviceId deviceId, String requestBody, final HttpStatus timeoutStatus, final HttpStatus noActiveConnectionStatus) throws ThingsboardException {
        try {
            JsonNode rpcRequestBody = JacksonUtil.toJsonNode((String)requestBody);
            final ToDeviceRpcRequestBody body = new ToDeviceRpcRequestBody(rpcRequestBody.get("method").asText(), JacksonUtil.toString((Object)rpcRequestBody.get("params")));
            final SecurityUser currentUser = this.getCurrentUser();
            final TenantId tenantId = currentUser.getTenantId();
            final DeferredResult response = new DeferredResult();
            long timeout = rpcRequestBody.has("timeout") ? rpcRequestBody.get("timeout").asLong() : this.defaultTimeout;
            final long expTime = rpcRequestBody.has("expirationTime") ? rpcRequestBody.get("expirationTime").asLong() : System.currentTimeMillis() + Math.max(this.minTimeout, timeout);
            final UUID rpcRequestUUID = rpcRequestBody.has("requestUUID") ? UUID.fromString(rpcRequestBody.get("requestUUID").asText()) : UUID.randomUUID();
            final boolean persisted = rpcRequestBody.has("persistent") && rpcRequestBody.get("persistent").asBoolean();
            final String additionalInfo = JacksonUtil.toString((Object)rpcRequestBody.get("additionalInfo"));
            final Integer retries = rpcRequestBody.has("retries") ? Integer.valueOf(rpcRequestBody.get("retries").asInt()) : null;
            this.accessValidator.validate(currentUser, Operation.RPC_CALL, (EntityId)deviceId, new HttpValidationCallback((DeferredResult<ResponseEntity>)response, new FutureCallback<DeferredResult<ResponseEntity>>(){

                public void onSuccess(@Nullable DeferredResult<ResponseEntity> result) {
                    ToDeviceRpcRequest rpcRequest = new ToDeviceRpcRequest(rpcRequestUUID, tenantId, deviceId, oneWay, expTime, body, persisted, retries, additionalInfo);
                    AbstractRpcController.this.deviceRpcService.processRestApiRpcRequest(rpcRequest, fromDeviceRpcResponse -> AbstractRpcController.this.reply(new LocalRequestMetaData(rpcRequest, currentUser, result), (FromDeviceRpcResponse)fromDeviceRpcResponse, timeoutStatus, noActiveConnectionStatus), currentUser);
                }

                public void onFailure(Throwable e) {
                    ResponseEntity entity = e instanceof ToErrorResponseEntity ? ((ToErrorResponseEntity)((Object)e)).toErrorResponseEntity() : new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
                    AbstractRpcController.this.logRpcCall(currentUser, (EntityId)deviceId, body, oneWay, Optional.empty(), e);
                    response.setResult((Object)entity);
                }
            }));
            return response;
        }
        catch (IllegalArgumentException ioe) {
            throw new ThingsboardException("Invalid request body", (Throwable)ioe, ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
    }

    public void reply(LocalRequestMetaData rpcRequest, FromDeviceRpcResponse response, HttpStatus timeoutStatus, HttpStatus noActiveConnectionStatus) {
        Optional rpcError = response.getError();
        DeferredResult<ResponseEntity> responseWriter = rpcRequest.getResponseWriter();
        if (rpcError.isPresent()) {
            this.logRpcCall(rpcRequest, rpcError, null);
            RpcError error = (RpcError)rpcError.get();
            switch (error) {
                case TIMEOUT: {
                    responseWriter.setResult((Object)new ResponseEntity((HttpStatusCode)timeoutStatus));
                    break;
                }
                case NO_ACTIVE_CONNECTION: {
                    responseWriter.setResult((Object)new ResponseEntity((HttpStatusCode)noActiveConnectionStatus));
                    break;
                }
                default: {
                    responseWriter.setResult((Object)new ResponseEntity((HttpStatusCode)timeoutStatus));
                    break;
                }
            }
        } else {
            Optional responseData = response.getResponse();
            if (responseData.isPresent() && !StringUtils.isEmpty((String)((String)responseData.get()))) {
                String data = (String)responseData.get();
                try {
                    this.logRpcCall(rpcRequest, rpcError, null);
                    responseWriter.setResult((Object)new ResponseEntity((Object)JacksonUtil.toJsonNode((String)data), (HttpStatusCode)HttpStatus.OK));
                }
                catch (IllegalArgumentException e) {
                    log.debug("Failed to decode device response: {}", (Object)data, (Object)e);
                    this.logRpcCall(rpcRequest, rpcError, e);
                    responseWriter.setResult((Object)new ResponseEntity((HttpStatusCode)HttpStatus.NOT_ACCEPTABLE));
                }
            } else {
                this.logRpcCall(rpcRequest, rpcError, null);
                responseWriter.setResult((Object)new ResponseEntity((HttpStatusCode)HttpStatus.OK));
            }
        }
    }

    private void logRpcCall(LocalRequestMetaData rpcRequest, Optional<RpcError> rpcError, Throwable e) {
        this.logRpcCall(rpcRequest.getUser(), (EntityId)rpcRequest.getRequest().getDeviceId(), rpcRequest.getRequest().getBody(), rpcRequest.getRequest().isOneway(), rpcError, null);
    }

    private void logRpcCall(SecurityUser user, EntityId entityId, ToDeviceRpcRequestBody body, boolean oneWay, Optional<RpcError> rpcError, Throwable e) {
        Object rpcErrorStr = "";
        if (rpcError.isPresent()) {
            rpcErrorStr = "RPC Error: " + rpcError.get().name();
        }
        String method = body.getMethod();
        String params = body.getParams();
        this.auditLogService.logEntityAction(user.getTenantId(), user.getCustomerId(), user.getId(), user.getName(), (EntityId)((UUIDBased)entityId), null, ActionType.RPC_CALL, BaseController.toException(e), new Object[]{rpcErrorStr, oneWay, method, params});
    }
}

