/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors.stats;

import com.fasterxml.jackson.databind.JsonNode;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.actors.TbActor;
import org.thingsboard.server.actors.TbActorId;
import org.thingsboard.server.actors.TbStringActorId;
import org.thingsboard.server.actors.service.ContextAwareActor;
import org.thingsboard.server.actors.service.ContextBasedCreator;
import org.thingsboard.server.actors.stats.StatsPersistMsg;
import org.thingsboard.server.common.data.event.Event;
import org.thingsboard.server.common.data.event.StatisticsEvent;
import org.thingsboard.server.common.msg.MsgType;
import org.thingsboard.server.common.msg.TbActorMsg;

public class StatsActor
extends ContextAwareActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatsActor.class);

    public StatsActor(ActorSystemContext context) {
        super(context);
    }

    @Override
    protected boolean doProcess(TbActorMsg msg) {
        log.debug("Received message: {}", (Object)msg);
        if (msg.getMsgType().equals((Object)MsgType.STATS_PERSIST_MSG)) {
            this.onStatsPersistMsg((StatsPersistMsg)msg);
            return true;
        }
        return false;
    }

    public void onStatsPersistMsg(StatsPersistMsg msg) {
        if (msg.isEmpty()) {
            return;
        }
        this.systemContext.getEventService().saveAsync((Event)StatisticsEvent.builder().tenantId(msg.getTenantId()).entityId(msg.getEntityId().getId()).serviceId(this.systemContext.getServiceInfoProvider().getServiceId()).messagesProcessed(msg.getMessagesProcessed()).errorsOccurred(msg.getErrorsOccurred()).build());
    }

    private JsonNode toBodyJson(String serviceId, long messagesProcessed, long errorsOccurred) {
        return JacksonUtil.newObjectNode().put("server", serviceId).put("messagesProcessed", messagesProcessed).put("errorsOccurred", errorsOccurred);
    }

    public static class ActorCreator
    extends ContextBasedCreator {
        private final String actorId;

        public ActorCreator(ActorSystemContext context, String actorId) {
            super(context);
            this.actorId = actorId;
        }

        public TbActorId createActorId() {
            return new TbStringActorId(this.actorId);
        }

        public TbActor createActor() {
            return new StatsActor(this.context);
        }
    }
}

