/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors.service;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.actors.DefaultTbActorSystem;
import org.thingsboard.server.actors.TbActorCreator;
import org.thingsboard.server.actors.TbActorRef;
import org.thingsboard.server.actors.TbActorSystem;
import org.thingsboard.server.actors.TbActorSystemSettings;
import org.thingsboard.server.actors.app.AppActor;
import org.thingsboard.server.actors.app.AppInitMsg;
import org.thingsboard.server.actors.service.ActorService;
import org.thingsboard.server.actors.stats.StatsActor;
import org.thingsboard.server.common.msg.TbActorMsg;
import org.thingsboard.server.common.msg.queue.PartitionChangeMsg;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.queue.discovery.TbApplicationEventListener;
import org.thingsboard.server.queue.discovery.event.PartitionChangeEvent;
import org.thingsboard.server.queue.util.AfterStartUp;

@Service
public class DefaultActorService
extends TbApplicationEventListener<PartitionChangeEvent>
implements ActorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultActorService.class);
    public static final String APP_DISPATCHER_NAME = "app-dispatcher";
    public static final String TENANT_DISPATCHER_NAME = "tenant-dispatcher";
    public static final String DEVICE_DISPATCHER_NAME = "device-dispatcher";
    public static final String RULE_DISPATCHER_NAME = "rule-dispatcher";
    public static final String CF_MANAGER_DISPATCHER_NAME = "cf-manager-dispatcher";
    public static final String CF_ENTITY_DISPATCHER_NAME = "cf-entity-dispatcher";
    @Autowired
    private ActorSystemContext actorContext;
    private TbActorSystem system;
    private TbActorRef appActor;
    @Value(value="${actors.system.throughput:5}")
    private int actorThroughput;
    @Value(value="${actors.system.max_actor_init_attempts:10}")
    private int maxActorInitAttempts;
    @Value(value="${actors.system.scheduler_pool_size:1}")
    private int schedulerPoolSize;
    @Value(value="${actors.system.app_dispatcher_pool_size:1}")
    private int appDispatcherSize;
    @Value(value="${actors.system.tenant_dispatcher_pool_size:2}")
    private int tenantDispatcherSize;
    @Value(value="${actors.system.device_dispatcher_pool_size:4}")
    private int deviceDispatcherSize;
    @Value(value="${actors.system.rule_dispatcher_pool_size:8}")
    private int ruleDispatcherSize;
    @Value(value="${actors.system.cfm_dispatcher_pool_size:2}")
    private int calculatedFieldManagerDispatcherSize;
    @Value(value="${actors.system.cfe_dispatcher_pool_size:8}")
    private int calculatedFieldEntityDispatcherSize;

    @PostConstruct
    public void initActorSystem() {
        log.info("Initializing actor system.");
        this.actorContext.setActorService(this);
        TbActorSystemSettings settings = new TbActorSystemSettings(this.actorThroughput, this.schedulerPoolSize, this.maxActorInitAttempts);
        this.system = new DefaultTbActorSystem(settings);
        this.system.createDispatcher(APP_DISPATCHER_NAME, this.initDispatcherExecutor(APP_DISPATCHER_NAME, this.appDispatcherSize));
        this.system.createDispatcher(TENANT_DISPATCHER_NAME, this.initDispatcherExecutor(TENANT_DISPATCHER_NAME, this.tenantDispatcherSize));
        this.system.createDispatcher(DEVICE_DISPATCHER_NAME, this.initDispatcherExecutor(DEVICE_DISPATCHER_NAME, this.deviceDispatcherSize));
        this.system.createDispatcher(RULE_DISPATCHER_NAME, this.initDispatcherExecutor(RULE_DISPATCHER_NAME, this.ruleDispatcherSize));
        this.system.createDispatcher(CF_MANAGER_DISPATCHER_NAME, this.initDispatcherExecutor(CF_MANAGER_DISPATCHER_NAME, this.calculatedFieldManagerDispatcherSize));
        this.system.createDispatcher(CF_ENTITY_DISPATCHER_NAME, this.initDispatcherExecutor(CF_ENTITY_DISPATCHER_NAME, this.calculatedFieldEntityDispatcherSize));
        this.actorContext.setActorSystem(this.system);
        this.appActor = this.system.createRootActor(APP_DISPATCHER_NAME, (TbActorCreator)new AppActor.ActorCreator(this.actorContext));
        this.actorContext.setAppActor(this.appActor);
        TbActorRef statsActor = this.system.createRootActor(TENANT_DISPATCHER_NAME, (TbActorCreator)new StatsActor.ActorCreator(this.actorContext, "StatsActor"));
        this.actorContext.setStatsActor(statsActor);
        log.info("Actor system initialized.");
    }

    private ExecutorService initDispatcherExecutor(String dispatcherName, int poolSize) {
        if (poolSize == 0) {
            int cores = Runtime.getRuntime().availableProcessors();
            poolSize = Math.max(1, cores / 2);
        }
        if (poolSize == 1) {
            return Executors.newSingleThreadExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)dispatcherName));
        }
        return ThingsBoardExecutors.newWorkStealingPool((int)poolSize, (String)dispatcherName);
    }

    @AfterStartUp(order=9)
    public void onApplicationEvent(ApplicationReadyEvent applicationReadyEvent) {
        log.info("Received application ready event. Sending application init message to actor system");
        this.appActor.tellWithHighPriority((TbActorMsg)new AppInitMsg());
    }

    protected void onTbApplicationEvent(PartitionChangeEvent event) {
        log.info("Received partition change event.");
        this.appActor.tellWithHighPriority((TbActorMsg)new PartitionChangeMsg(event.getServiceType()));
    }

    protected boolean filterTbApplicationEvent(PartitionChangeEvent event) {
        return event.getServiceType() == ServiceType.TB_RULE_ENGINE || event.getServiceType() == ServiceType.TB_CORE;
    }

    @PreDestroy
    public void stopActorSystem() {
        if (this.system != null) {
            log.info("Stopping actor system.");
            this.system.stop();
            log.info("Actor system stopped.");
        }
    }
}

